/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.model;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.SessionScoped;
import jakarta.faces.event.ActionEvent;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ModelManager;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.faces.fileupload.FileUploadController;
import org.openbpmn.bpmn.BPMNModel;
import org.openbpmn.bpmn.exceptions.BPMNModelException;
import org.openbpmn.bpmn.util.BPMNModelFactory;

@Named
@SessionScoped
public class ModelController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ModelController.class.getName());
    protected ItemCollection modelUploads = null;
    protected ModelManager modelManager = null;
    @Inject
    protected ModelService modelService;
    @Inject
    protected WorkflowService workflowService;
    @Inject
    FileUploadController fileUploadController;

    @PostConstruct
    void init() {
        this.modelUploads = new ItemCollection();
        this.modelManager = new ModelManager((WorkflowContext)this.workflowService);
    }

    public ItemCollection getModelUploads() {
        return this.modelUploads;
    }

    public void setModelUploads(ItemCollection modelUploads) {
        this.modelUploads = modelUploads;
    }

    public List<String> getGroups(String version) {
        try {
            BPMNModel model = this.modelManager.getModel(version);
            Set groups = this.modelManager.findAllGroupsByModel(model);
            return new ArrayList<String>(groups);
        }
        catch (ModelException e) {
            logger.warning("Unable to load groups:" + e.getMessage());
            return new ArrayList<String>();
        }
    }

    public List<String> getWorkflowGroups() throws ModelException {
        return this.modelService.findAllWorkflowGroups();
    }

    public String getVersionByGroup(String group) throws ModelException {
        return this.modelService.findVersionByGroup(group);
    }

    public List<ItemCollection> findAllTasksByGroup(String group) {
        List<Object> result = new ArrayList<ItemCollection>();
        if (group == null || group.isEmpty()) {
            return result;
        }
        try {
            String version = this.modelService.findVersionByGroup(group);
            BPMNModel model = this.modelManager.getModel(version);
            result = this.modelManager.findTasks(model, group);
        }
        catch (ModelException e) {
            logger.warning("Failed to call findAllTasksByGroup for '" + group + "'");
        }
        return result;
    }

    public List<ItemCollection> findAllStartTasksByGroup(String version, String group) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        try {
            BPMNModel model = this.modelManager.getModel(version);
            return this.modelManager.findStartTasks(model, group);
        }
        catch (ModelException e) {
            logger.severe("Failed to find start tasks for workflow group '" + group + "' : " + e.getMessage());
            return result;
        }
    }

    public List<String> getVersions() {
        return this.modelService.getVersions();
    }

    public ItemCollection getModelEntity(String version) {
        return this.modelService.loadModelMetaData(version);
    }

    public void doUploadModel(ActionEvent event) throws ModelException {
        try {
            this.fileUploadController.attacheFiles(this.modelUploads);
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        List fileList = this.getModelUploads().getFileData();
        if (fileList == null) {
            return;
        }
        for (FileData file : fileList) {
            if (file.getName().endsWith(".bpmn")) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getContent());
                try {
                    BPMNModel model = BPMNModelFactory.read((InputStream)inputStream);
                    this.modelService.saveModel(model);
                    continue;
                }
                catch (BPMNModelException e) {
                    throw new ModelException("INVALID_MODEL", "Unable to read model file: " + file.getName(), (Exception)((Object)e));
                }
            }
            logger.log(Level.WARNING, "Invalid Model Type. Model {0} can't be imported!", file.getName());
        }
        this.modelUploads = new ItemCollection();
    }

    public void deleteModel(String modelversion) throws AccessDeniedException, ModelException {
        this.modelService.deleteModelData(modelversion);
    }

    public ItemCollection getProcessEntity(int processid, String modelversion) {
        try {
            BPMNModel model = this.modelManager.getModel(modelversion);
            return this.modelManager.findTaskByID(model, processid);
        }
        catch (ModelException e) {
            logger.warning("Unable to load task " + processid + " in model version '" + modelversion + "' - " + e.getMessage());
            return null;
        }
    }

    public String getProcessDescription(int processid, String modelversion, ItemCollection documentContext) {
        ItemCollection pe = null;
        try {
            BPMNModel model = this.modelManager.getModel(modelversion);
            pe = this.modelManager.findTaskByID(model, processid);
        }
        catch (ModelException e1) {
            logger.warning("Unable to load task " + processid + " in model version '" + modelversion + "' - " + e1.getMessage());
        }
        if (pe == null) {
            return "";
        }
        String desc = pe.getItemValueString("documentation");
        try {
            desc = this.workflowService.adaptText(desc, documentContext);
        }
        catch (PluginException e) {
            logger.warning("Unable to update processDescription: " + e.getMessage());
        }
        return desc;
    }

    public String getProcessDescriptionByInitialTask(ItemCollection initialTask, String modelVersion, String workflowGroup) {
        String result = "";
        if (initialTask != null) {
            ItemCollection dummy = new ItemCollection();
            dummy.setItemValue("$workflowstatus", (Object)initialTask.getItemValueString("name"));
            dummy.setItemValue("$workflowgroup", (Object)workflowGroup);
            result = this.getProcessDescription(initialTask.getItemValueInteger("taskid"), modelVersion, dummy);
        }
        return result;
    }
}

