/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.office.util;

import jakarta.ejb.EJBException;
import jakarta.el.ELException;
import jakarta.enterprise.context.ContextException;
import jakarta.enterprise.context.NonexistentConversationException;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerWrapper;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.imixs.workflow.exceptions.WorkflowException;

public class ImixsExceptionHandler
extends ExceptionHandlerWrapper {
    private static Logger logger = Logger.getLogger(ImixsExceptionHandler.class.getName());

    public ImixsExceptionHandler(ExceptionHandler wrapped) {
        super(wrapped);
    }

    public void handle() {
        this.handleImixsWorkflowException(FacesContext.getCurrentInstance());
        this.getWrapped().handle();
    }

    public void handleImixsWorkflowException(FacesContext context) {
        Iterator unhandledExceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
        if (context == null || !unhandledExceptionQueuedEvents.hasNext()) {
            return;
        }
        Throwable exception = ((ExceptionQueuedEvent)unhandledExceptionQueuedEvents.next()).getContext().getException();
        while (exception.getCause() != null && (exception instanceof FacesException || exception instanceof ELException || exception instanceof NonexistentConversationException)) {
            exception = exception.getCause();
        }
        if (!(exception instanceof WorkflowException || exception instanceof EJBException || exception instanceof ContextException)) {
            return;
        }
        if (exception instanceof EJBException || exception instanceof NonexistentConversationException) {
            Throwable rootCause = ImixsExceptionHandler.findCauseUsingPlainJava(exception);
            this.redirectErrorPage(context, exception, rootCause);
        } else {
            this.createFacesMessage(context, exception);
        }
        unhandledExceptionQueuedEvents.remove();
        while (unhandledExceptionQueuedEvents.hasNext()) {
            unhandledExceptionQueuedEvents.next();
            unhandledExceptionQueuedEvents.remove();
        }
    }

    private void createFacesMessage(FacesContext context, Throwable exception) {
        String exceptionType = exception.getClass().getSimpleName();
        String exceptionName = exception.getClass().getName();
        String exceptionMessage = exception.getMessage();
        context.getAttributes().put("exceptionMessage", exceptionMessage);
        context.getAttributes().put("exceptionName", exceptionName);
        context.getAttributes().put("exceptionType", exceptionType);
        context.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, exception.toString(), exceptionMessage));
        context.validationFailed();
        context.getPartialViewContext().getRenderIds().add("globalMessages");
    }

    private void redirectErrorPage(FacesContext context, Throwable exception, Throwable rootCause) {
        String exceptionMessage = rootCause.getMessage();
        String exceptionName = rootCause.getClass().getName();
        String exceptionType = rootCause.getClass().getSimpleName();
        ExternalContext external = context.getExternalContext();
        String uri = external.getRequestContextPath() + external.getRequestServletPath();
        Map requestScope = external.getRequestMap();
        requestScope.put("jakarta.servlet.error.request_uri", uri);
        requestScope.put("jakarta.servlet.error.exception", exception);
        logger.info("redirectErrorPage for exception type: " + exceptionType);
        String viewId = "/error.xhtml";
        if ("OptimisticLockException".equals(exceptionType)) {
            viewId = "/error_optimisticlock.xhtml";
        }
        if ("NonexistentConversationException".equals(exceptionType)) {
            viewId = "/error_conversationexpired.xhtml";
        }
        Application application = context.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = viewHandler.createView(context, viewId);
        context.setViewRoot(viewRoot);
        try {
            external.responseReset();
            ViewDeclarationLanguage viewDeclarationLanguage = viewHandler.getViewDeclarationLanguage(context, viewId);
            viewDeclarationLanguage.buildView(context, viewRoot);
            context.getPartialViewContext().setRenderAll(true);
            viewDeclarationLanguage.renderView(context, viewRoot);
            context.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            requestScope.remove("jakarta.servlet.error.exception");
        }
    }

    private static Throwable findCauseUsingPlainJava(Throwable throwable) {
        Throwable rootCause;
        Objects.requireNonNull(throwable);
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }
}

