/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.signature.adapter;

import java.util.Optional;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestFilter;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.workflow.exceptions.ProcessingErrorException;

@ApplicationScoped
public class DocumentClientFactory {
    public static final String SIGNATURE_SERVICE_ENDPOINT = "signature.service.endpoint";
    public static final String SIGNATURE_SERVICE_USER = "SIGNATURE_SERVICE_USER";
    public static final String SIGNATURE_SERVICE_PASSWORD = "SIGNATURE_SERVICE_PASSWORD";
    public static final String SIGNATURE_SERVICE_AUTHMETHOD = "SIGNATURE_SERVICE_AUTHMETHOD";
    @Inject
    @ConfigProperty(name="signature.service.endpoint")
    Optional<String> signatureAPIEndpoint;
    @Inject
    @ConfigProperty(name="SIGNATURE_SERVICE_USER")
    Optional<String> signatureServiceUser;
    @Inject
    @ConfigProperty(name="SIGNATURE_SERVICE_PASSWORD")
    Optional<String> signatureServicePassword;
    @Inject
    @ConfigProperty(name="SIGNATURE_SERVICE_AUTHMETHOD")
    Optional<String> signatureServiceAuthMethod;
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry metricRegistry;
    boolean mpMetricNoSupport = false;
    private static Logger logger = Logger.getLogger(DocumentClientFactory.class.getName());

    public DocumentClient initDocumentClient() {
        if (!this.signatureAPIEndpoint.isPresent()) {
            throw new ProcessingErrorException(this.getClass().getSimpleName(), "SIGNING_ERROR", "Missing signature service endpoint!");
        }
        logger.finest("...... SIGNATURE_SERVICE_ENDPOINT = " + this.signatureAPIEndpoint.get());
        DocumentClient documentClient = new DocumentClient(this.signatureAPIEndpoint.get());
        if (this.signatureServiceAuthMethod.isPresent() && "Basic".equalsIgnoreCase(this.signatureServiceAuthMethod.get())) {
            BasicAuthenticator basicAuth = new BasicAuthenticator(this.signatureServiceUser.get(), this.signatureServicePassword.get());
            documentClient.registerClientRequestFilter((ClientRequestFilter)basicAuth);
        }
        return documentClient;
    }
}

