/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.signature.adapter;

import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.imixs.archive.core.SnapshotService;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.RestAPIException;
import org.imixs.signature.adapter.DocumentClientFactory;
import org.imixs.signature.adapter.X509ProfileHandler;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

public class SignatureAdapter
implements SignalAdapter {
    public static final String ERROR_SIGNATURE_API = "ERROR_SIGNATURE_API";
    public static final String PDF_REGEX = "^.+\\.([pP][dD][fF])$";
    public static final String OPTION_AUTOCREATE = "autocreate";
    public static final String OPTION_ROOTSIGNATURE = "rootsignature";
    public static final String OPTION_POSITION_X = "position-x";
    public static final String OPTION_POSITION_Y = "position-y";
    public static final String OPTION_DIMENSION_W = "dimension-w";
    public static final String OPTION_DIMENSION_H = "dimension-h";
    public static final String OPTION_VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String OPTION_AUTO_ALIGNMENT = "autoAlignment";
    public static final String OPTION_PAGE = "page";
    public static final String OPTION_FILEPATTERN = "filepattern";
    @Inject
    WorkflowService workflowService;
    @Inject
    DocumentService documentService;
    @Inject
    DocumentClientFactory clientHelper;
    @Inject
    SnapshotService snapshotService;
    @Inject
    X509ProfileHandler x509ProfileHandler;
    private static Logger logger = Logger.getLogger(SignatureAdapter.class.getName());

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException, PluginException {
        String file_pattern = PDF_REGEX;
        DocumentClient documentClient = this.clientHelper.initDocumentClient();
        String certAlias = this.workflowService.getUserName();
        try {
            List fileNames = document.getFileNames();
            if (fileNames.size() > 0) {
                ItemCollection x509Profile;
                ItemCollection signingWorkitem = new ItemCollection();
                signingWorkitem.setItemValue("$workflowstatus", (Object)document.getItemValueString("$workflowstatus"));
                ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, "signature", document, false);
                if (evalItemCollection != null) {
                    if (evalItemCollection.hasItem(OPTION_FILEPATTERN)) {
                        file_pattern = evalItemCollection.getItemValueString(OPTION_FILEPATTERN);
                        signingWorkitem.setItemValue(OPTION_FILEPATTERN, (Object)file_pattern);
                    }
                    if (evalItemCollection.hasItem(OPTION_AUTOCREATE)) {
                        signingWorkitem.setItemValue(OPTION_AUTOCREATE, (Object)evalItemCollection.getItemValueBoolean(OPTION_AUTOCREATE));
                    }
                    if (evalItemCollection.hasItem(OPTION_ROOTSIGNATURE)) {
                        signingWorkitem.setItemValue(OPTION_ROOTSIGNATURE, (Object)evalItemCollection.getItemValueBoolean(OPTION_ROOTSIGNATURE));
                    }
                    if (evalItemCollection.hasItem(OPTION_PAGE)) {
                        signingWorkitem.setItemValue(OPTION_PAGE, (Object)evalItemCollection.getItemValueInteger(OPTION_PAGE));
                    }
                    if (evalItemCollection.hasItem(OPTION_POSITION_X)) {
                        signingWorkitem.setItemValue(OPTION_POSITION_X, (Object)Float.valueOf(evalItemCollection.getItemValueFloat(OPTION_POSITION_X)));
                    }
                    if (evalItemCollection.hasItem(OPTION_POSITION_Y)) {
                        signingWorkitem.setItemValue(OPTION_POSITION_Y, (Object)Float.valueOf(evalItemCollection.getItemValueFloat(OPTION_POSITION_Y)));
                    }
                    if (evalItemCollection.hasItem(OPTION_DIMENSION_W)) {
                        signingWorkitem.setItemValue(OPTION_DIMENSION_W, (Object)Float.valueOf(evalItemCollection.getItemValueFloat(OPTION_DIMENSION_W)));
                    }
                    if (evalItemCollection.hasItem(OPTION_DIMENSION_H)) {
                        signingWorkitem.setItemValue(OPTION_DIMENSION_H, (Object)Float.valueOf(evalItemCollection.getItemValueFloat(OPTION_DIMENSION_H)));
                    }
                    if (evalItemCollection.hasItem(OPTION_VERTICAL_ALIGNMENT)) {
                        signingWorkitem.setItemValue(OPTION_VERTICAL_ALIGNMENT, (Object)evalItemCollection.getItemValueBoolean(OPTION_VERTICAL_ALIGNMENT));
                    }
                    if (evalItemCollection.hasItem(OPTION_AUTO_ALIGNMENT)) {
                        signingWorkitem.setItemValue(OPTION_AUTO_ALIGNMENT, (Object)evalItemCollection.getItemValueBoolean(OPTION_AUTO_ALIGNMENT));
                    }
                }
                if ((x509Profile = this.x509ProfileHandler.findX509Profile(certAlias)) != null) {
                    signingWorkitem.setItemValue("x509.cn", (Object)x509Profile.getItemValue("txtusername"));
                    signingWorkitem.setItemValue("x509.o", (Object)x509Profile.getItemValue("x509.o"));
                    signingWorkitem.setItemValue("x509.ou", (Object)x509Profile.getItemValue("x509.ou"));
                    signingWorkitem.setItemValue("x509.city", (Object)x509Profile.getItemValue("x509.city"));
                    signingWorkitem.setItemValue("x509.state", (Object)x509Profile.getItemValue("x509.state"));
                    signingWorkitem.setItemValue("x509.country", (Object)x509Profile.getItemValue("x509.country"));
                }
                signingWorkitem.setItemValue("signature.count", (Object)document.getItemValue("signature.count"));
                Pattern filePatternMatcher = Pattern.compile(file_pattern);
                for (String fileName : fileNames) {
                    if (!filePatternMatcher.matcher(fileName).find()) continue;
                    logger.info("......start signing " + fileName + " ...");
                    FileData fileData = document.getFileData(fileName);
                    byte[] sourceContent = fileData.getContent();
                    if (sourceContent.length == 0) {
                        ItemCollection snapshot = this.snapshotService.findSnapshot(document);
                        fileData = snapshot.getFileData(fileName);
                        sourceContent = fileData.getContent();
                    }
                    signingWorkitem.addFileData(fileData);
                }
                if (signingWorkitem.getFileData().size() > 0) {
                    signingWorkitem.setItemValue("certAlias", (Object)certAlias);
                    FileData fileDataSignature = this.loadSignatureImageFromProfile(certAlias);
                    if (fileDataSignature != null) {
                        signingWorkitem.addFileData(fileDataSignature);
                    } else if (!signingWorkitem.getItemValueBoolean(OPTION_ROOTSIGNATURE)) {
                        logger.warning("Missing signature image for profile '" + certAlias + "'!");
                    }
                    XMLDocument xmlDataCollection = XMLDocumentAdapter.getDocument((ItemCollection)signingWorkitem);
                    XMLDataCollection signedXMLData = documentClient.postXMLDocument("sign", xmlDataCollection);
                    if (signedXMLData != null && signedXMLData.getDocument().length > 0) {
                        ItemCollection signedWorkitem = XMLDocumentAdapter.putDocument((XMLDocument)signedXMLData.getDocument()[0]);
                        List fileDataList = signedWorkitem.getFileData();
                        for (FileData signedFileData : fileDataList) {
                            document.addFileData(signedFileData);
                            logger.info("......signing " + signedFileData.getName() + " successful.");
                            document.appendItemValue("$snapshot.overwriteFileContent", (Object)signedFileData.getName());
                        }
                        document.setItemValue("signature.count", (Object)signedWorkitem.getItemValue("signature.count"));
                    }
                } else {
                    logger.info("......no files are matching the file pattern!");
                }
            }
        }
        catch (RestAPIException | PluginException e) {
            throw new PluginException(this.getClass().getSimpleName(), ERROR_SIGNATURE_API, "Signature Error: One of the documents could not be signed!", (Exception)e);
        }
        return document;
    }

    private FileData loadSignatureImageFromProfile(String certAlias) {
        try {
            List userProfileList = this.documentService.find("type:profile AND txtname:" + certAlias, 1, 0);
            if (userProfileList.size() > 0) {
                ItemCollection profile = (ItemCollection)userProfileList.get(0);
                FileData fileData = this.snapshotService.getWorkItemFile(profile.getUniqueID(), "signature.jpg");
                if (fileData == null) {
                    fileData = this.snapshotService.getWorkItemFile(profile.getUniqueID(), "signature.png");
                }
                if (fileData == null) {
                    fileData = this.snapshotService.getWorkItemFile(profile.getUniqueID(), "signature.gif");
                }
                if (fileData != null && fileData.getContent() != null && fileData.getContent().length > 0) {
                    return fileData;
                }
            }
        }
        catch (QueryException e) {
            logger.warning("Failed to load signature image from profile : " + e.getMessage());
        }
        return null;
    }
}

