/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.signature.api;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.bouncycastle.operator.OperatorCreationException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.signature.ca.CAService;
import org.imixs.signature.pdf.SigningService;
import org.imixs.signature.pdf.cert.CertificateVerificationException;
import org.imixs.signature.pdf.cert.SigningException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Named
@Path(value="sign")
@Produces(value={"application/xml", "application/json"})
public class SignatureResource {
    public static final String PDF_REGEX = "^.+\\.([pP][dD][fF])$";
    public static final String OPTION_AUTOCREATE = "autocreate";
    public static final String OPTION_ROOTSIGNATURE = "rootsignature";
    public static final String OPTION_POSITION_X = "position-x";
    public static final String OPTION_POSITION_Y = "position-y";
    public static final String OPTION_DIMENSION_W = "dimension-w";
    public static final String OPTION_DIMENSION_H = "dimension-h";
    public static final String OPTION_VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String OPTION_AUTO_ALIGNMENT = "autoAlignment";
    public static final String OPTION_PAGE = "page";
    public static final String OPTION_FILEPATTERN = "filepattern";
    @Inject
    @ConfigProperty(name="signature.rootcert.alias")
    Optional<String> rootCertAlias;
    @Inject
    @ConfigProperty(name="signature.rootcert.password")
    Optional<String> rootCertPassword;
    @Inject
    SigningService signatureService;
    @Inject
    CAService caService;
    private static Logger logger = Logger.getLogger(SignatureResource.class.getName());

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response signPDF(XMLDocument xmlDocument) {
        boolean autocreate = true;
        boolean rootsignature = false;
        String file_pattern = PDF_REGEX;
        float positionx = 30.0f;
        float positiony = 700.0f;
        float dimensionw = 170.0f;
        float dimensionh = 100.0f;
        int page = 0;
        boolean verticalAlignment = false;
        boolean autoAlignment = true;
        ItemCollection document = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument);
        ItemCollection signedDocument = new ItemCollection();
        try {
            List fileNames = document.getFileNames();
            if (fileNames.size() > 0) {
                if (document.hasItem(OPTION_AUTOCREATE)) {
                    autocreate = document.getItemValueBoolean(OPTION_AUTOCREATE);
                }
                if (document.hasItem(OPTION_ROOTSIGNATURE)) {
                    rootsignature = document.getItemValueBoolean(OPTION_ROOTSIGNATURE);
                }
                if (document.hasItem(OPTION_POSITION_X)) {
                    positionx = document.getItemValueFloat(OPTION_POSITION_X);
                }
                if (document.hasItem(OPTION_POSITION_Y)) {
                    positiony = document.getItemValueFloat(OPTION_POSITION_Y);
                }
                if (document.hasItem(OPTION_DIMENSION_W)) {
                    dimensionw = document.getItemValueFloat(OPTION_DIMENSION_W);
                }
                if (document.hasItem(OPTION_DIMENSION_H)) {
                    dimensionh = document.getItemValueFloat(OPTION_DIMENSION_H);
                }
                if (document.hasItem(OPTION_VERTICAL_ALIGNMENT)) {
                    verticalAlignment = document.getItemValueBoolean(OPTION_VERTICAL_ALIGNMENT);
                }
                if (document.hasItem(OPTION_AUTO_ALIGNMENT)) {
                    autoAlignment = document.getItemValueBoolean(OPTION_AUTO_ALIGNMENT);
                }
                if (document.hasItem(OPTION_PAGE)) {
                    page = document.getItemValueInteger(OPTION_PAGE);
                }
                if (document.hasItem(OPTION_FILEPATTERN)) {
                    file_pattern = document.getItemValueString(OPTION_FILEPATTERN);
                }
                int signatureCount = document.getItemValueInteger("signature.count");
                Pattern filePatternMatcher = Pattern.compile(file_pattern);
                for (String fileName : fileNames) {
                    if (!filePatternMatcher.matcher(fileName).find()) continue;
                    String certPassword = "";
                    String certAlias = null;
                    if (rootsignature && this.rootCertAlias.isPresent()) {
                        certAlias = (String)this.rootCertAlias.get();
                        if (this.rootCertPassword.isPresent()) {
                            certPassword = (String)this.rootCertPassword.get();
                        }
                        if (!this.caService.existsCertificate(certAlias)) {
                            throw new ProcessingErrorException(this.getClass().getSimpleName(), "SIGNING_ERROR", "Root certificate '" + certAlias + "' does not exist!");
                        }
                        logger.info("......signing " + fileName + " with root certificate '" + certAlias + "'...");
                    } else {
                        certAlias = document.getItemValueString("certAlias");
                        logger.info("......signing " + fileName + " by '" + certAlias + "'...");
                        if (!this.caService.existsCertificate(certAlias)) {
                            if (!autocreate) {
                                throw new CertificateVerificationException("certificate for alias '" + certAlias + "' not found.");
                            }
                            this.caService.createCertificate(certAlias, document);
                            if (!this.caService.existsCertificate(certAlias)) {
                                throw new ProcessingErrorException(this.getClass().getSimpleName(), "SIGNING_ERROR", "No certificate exists for user '" + certAlias + "'");
                            }
                        }
                    }
                    FileData fileData = document.getFileData(fileName);
                    byte[] sourceContent = fileData.getContent();
                    byte[] signedContent = null;
                    if (rootsignature) {
                        signedContent = this.signatureService.signPDF(sourceContent, certAlias, certPassword, false);
                    } else {
                        byte[] signatureImage = null;
                        FileData fileDataSignature = this.getSignatureImage(document);
                        if (fileDataSignature != null) {
                            signatureImage = fileDataSignature.getContent();
                        }
                        if (autoAlignment && signatureCount > 0) {
                            if (verticalAlignment) {
                                positiony += (float)signatureCount * dimensionh + 10.0f;
                            } else {
                                positionx += (float)signatureCount * dimensionw + 10.0f;
                            }
                        }
                        Rectangle2D.Float humanRect = new Rectangle2D.Float(positionx, positiony, dimensionw, dimensionh);
                        signedContent = this.signatureService.signPDF(sourceContent, certAlias, certPassword, false, (Rectangle2D)humanRect, page, "Signature" + signatureCount, signatureImage, document.getItemValueString("$workflowstatus"));
                    }
                    FileData signedFileData = new FileData(fileName, signedContent, "application/pdf", null);
                    signedDocument.addFileData(signedFileData);
                    logger.info("......" + fileName + " signed");
                }
                if (!rootsignature) {
                    signedDocument.setItemValue("signature.count", (Object)(signatureCount + 1));
                }
            }
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException | OperatorCreationException | CertificateVerificationException | SigningException e) {
            logger.warning("Failed to query documents: " + e.getMessage());
            e.printStackTrace();
        }
        return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)signedDocument), (String)"application/xml").build();
    }

    private FileData getSignatureImage(ItemCollection doc) {
        FileData fileData = doc.getFileData("signature.jpg");
        if (fileData == null) {
            fileData = doc.getFileData("signature.png");
        }
        if (fileData == null) {
            fileData = doc.getFileData("signature.gif");
        }
        if (fileData != null && fileData.getContent() != null && fileData.getContent().length > 0) {
            return fileData;
        }
        return null;
    }
}

