/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.signature.api;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.bouncycastle.operator.OperatorCreationException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.signature.ca.CAService;
import org.imixs.signature.pdf.SigningService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Named
@Path(value="certificate")
@Produces(value={"application/xml", "application/json"})
public class X509CertificateResource {
    public static final String PDF_REGEX = "^.+\\.([pP][dD][fF])$";
    @Inject
    @ConfigProperty(name="signature.rootcert.alias")
    Optional<String> rootCertAlias;
    @Inject
    @ConfigProperty(name="signature.rootcert.password")
    Optional<String> rootCertPassword;
    @Inject
    SigningService signatureService;
    @Inject
    CAService caService;
    private static Logger logger = Logger.getLogger(X509CertificateResource.class.getName());

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response signPDF(XMLDocument xmlDocument) {
        ItemCollection document = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument);
        String certAlias = document.getItemValueString("txtname");
        logger.finest(".......adding new certificate for userid '" + certAlias + "'");
        try {
            this.caService.createCertificate(certAlias, document);
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | UnrecoverableKeyException | CertificateException | OperatorCreationException e) {
            logger.warning("Failed to query documents: " + e.getMessage());
            e.printStackTrace();
        }
        logger.info("**************** FINISHED ***********************");
        ItemCollection stats = new ItemCollection();
        logger.info("**************** FINISHED ***********************");
        return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)stats), (String)"application/xml").build();
    }
}

