/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.signature.ca;

import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.imixs.signature.service.KeystoreService;

public class X509CertificateGenerator {
    private static final String BC_PROVIDER = "BC";
    private static final String DEFAULT_KEY_ALGORITHM = "RSA";
    private static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static Logger logger = Logger.getLogger(KeystoreService.class.getName());
    private String keyAlgorithm = "RSA";
    private String signatureAlgorithm = "SHA256withRSA";

    public X509CertificateGenerator() throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public X509Certificate generateRootCertificate(KeyPair rootKeyPair, String cn) throws OperatorCreationException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        X500Name rootCertIssuer;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date startDate = calendar.getTime();
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        BigInteger rootSerialNum = new BigInteger(Long.toString(new SecureRandom().nextLong()));
        X500Name rootCertSubject = rootCertIssuer = new X500Name("CN=" + cn);
        ContentSigner rootCertContentSigner = new JcaContentSignerBuilder(this.getSignatureAlgorithm()).setProvider(BC_PROVIDER).build(rootKeyPair.getPrivate());
        JcaX509v3CertificateBuilder rootCertBuilder = new JcaX509v3CertificateBuilder(rootCertIssuer, rootSerialNum, startDate, endDate, rootCertSubject, rootKeyPair.getPublic());
        JcaX509ExtensionUtils rootCertExtUtils = new JcaX509ExtensionUtils();
        rootCertBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        rootCertBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)rootCertExtUtils.createSubjectKeyIdentifier(rootKeyPair.getPublic()));
        X509CertificateHolder rootCertHolder = rootCertBuilder.build(rootCertContentSigner);
        X509Certificate rootCert = new JcaX509CertificateConverter().setProvider(BC_PROVIDER).getCertificate(rootCertHolder);
        return rootCert;
    }

    public X509Certificate[] generateSignedCertificate(X509Certificate rootCert, PrivateKey rootPrivateKey, KeyPair issuedCertKeyPair, String cn, String o, List<String> ou, String city, String state, String country) throws NoSuchAlgorithmException, OperatorCreationException, CertIOException, CertificateException, InvalidKeyException, NoSuchProviderException, SignatureException {
        logger.fine("...generating new certificate for user " + cn + "...");
        if (cn == null || cn.isEmpty()) {
            throw new IllegalArgumentException("cn is empty or null!");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        Date startDate = calendar.getTime();
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        X500Name issuedCertSubject = new X500Name("CN=" + cn);
        BigInteger issuedCertSerialNum = new BigInteger(Long.toString(new SecureRandom().nextLong()));
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(issuedCertSubject, issuedCertKeyPair.getPublic());
        JcaContentSignerBuilder csrBuilder = new JcaContentSignerBuilder(this.getSignatureAlgorithm()).setProvider(BC_PROVIDER);
        ContentSigner csrContentSigner = csrBuilder.build(rootPrivateKey);
        PKCS10CertificationRequest csr = p10Builder.build(csrContentSigner);
        X500Name rootCertIssuer = new X500Name(rootCert.getSubjectDN().toString());
        X500NameBuilder builder = new X500NameBuilder(RFC4519Style.INSTANCE);
        builder.addRDN(RFC4519Style.cn, cn);
        if (ou != null && !ou.isEmpty()) {
            for (String _ou : ou) {
                builder.addRDN(RFC4519Style.ou, _ou);
            }
        }
        if (o != null && !o.isEmpty()) {
            builder.addRDN(RFC4519Style.o, o);
        }
        if (city != null && !city.isEmpty()) {
            builder.addRDN(RFC4519Style.l, city);
        }
        if (state != null && !state.isEmpty()) {
            builder.addRDN(RFC4519Style.st, state);
        }
        X509v3CertificateBuilder issuedCertBuilder = new X509v3CertificateBuilder(rootCertIssuer, issuedCertSerialNum, startDate, endDate, builder.build(), csr.getSubjectPublicKeyInfo());
        JcaX509ExtensionUtils issuedCertExtUtils = new JcaX509ExtensionUtils();
        issuedCertBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        issuedCertBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)issuedCertExtUtils.createAuthorityKeyIdentifier(rootCert));
        issuedCertBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)issuedCertExtUtils.createSubjectKeyIdentifier(csr.getSubjectPublicKeyInfo()));
        issuedCertBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(128));
        X509CertificateHolder issuedCertHolder = issuedCertBuilder.build(csrContentSigner);
        X509Certificate issuedCert = new JcaX509CertificateConverter().setProvider(BC_PROVIDER).getCertificate(issuedCertHolder);
        issuedCert.verify(rootCert.getPublicKey(), BC_PROVIDER);
        X509Certificate[] certChain = new X509Certificate[]{issuedCert, rootCert};
        return certChain;
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.getKeyAlgorithm(), BC_PROVIDER);
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            logger.severe("Failed to generate keypair: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void exportKeyPairToKeystore(Certificate[] certChain, PrivateKey privKey, String password, String alias, KeyStore keyStore, String fileName, String storePass) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (password == null) {
            keyStore.setKeyEntry(alias, privKey, null, certChain);
        } else {
            keyStore.setKeyEntry(alias, privKey, password.toCharArray(), certChain);
        }
        FileOutputStream keyStoreOs = new FileOutputStream(fileName);
        keyStore.store(keyStoreOs, storePass.toCharArray());
    }

    public void writeCertToFileBase64Encoded(Certificate certificate, String fileName) throws Exception {
        FileOutputStream certificateOut = new FileOutputStream(fileName);
        certificateOut.write("-----BEGIN CERTIFICATE-----".getBytes());
        certificateOut.write(Base64.encode((byte[])certificate.getEncoded()));
        certificateOut.write("-----END CERTIFICATE-----".getBytes());
        certificateOut.close();
    }
}

