/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.signature.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.imixs.signature.pdf.CMSProcessableInputStream;
import org.imixs.signature.pdf.util.ValidationTimeStamp;

public class Signature
implements SignatureInterface {
    private Certificate[] certificateChain;
    private PrivateKey privateKey;
    private String tsaUrl;

    public Signature(Certificate[] certificateChain, PrivateKey privateKey) throws UnrecoverableKeyException, CertificateNotYetValidException, CertificateExpiredException, KeyStoreException, NoSuchAlgorithmException, IOException {
        this(certificateChain, privateKey, null);
    }

    public Signature(Certificate[] certificateChain, PrivateKey privateKey, String _tsaURL) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateNotYetValidException, CertificateExpiredException {
        Certificate certificate;
        this.certificateChain = certificateChain;
        this.tsaUrl = _tsaURL;
        this.privateKey = privateKey;
        if (certificateChain != null && certificateChain.length > 0 && (certificate = this.certificateChain[0]) instanceof X509Certificate) {
            ((X509Certificate)certificate).checkValidity();
        }
    }

    public byte[] sign(InputStream content) throws IOException {
        try {
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            X509Certificate cert = (X509Certificate)this.certificateChain[0];
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA256WithRSA").build(this.privateKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(sha1Signer, cert));
            gen.addCertificates((Store)new JcaCertStore(Arrays.asList(this.certificateChain)));
            CMSProcessableInputStream msg = new CMSProcessableInputStream(content);
            CMSSignedData signedData = gen.generate((CMSTypedData)msg, false);
            if (this.tsaUrl != null && this.tsaUrl.length() > 0) {
                ValidationTimeStamp validation = new ValidationTimeStamp(this.tsaUrl);
                signedData = validation.addSignedTimeStamp(signedData);
            }
            return signedData.getEncoded();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException | CMSException | OperatorCreationException e) {
            throw new IOException(e);
        }
    }
}

