/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.signature.pdf.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.apache.pdfbox.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.Attributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.imixs.signature.pdf.util.TSAClient;

public class ValidationTimeStamp {
    private TSAClient tsaClient;

    public ValidationTimeStamp(String tsaUrl) throws NoSuchAlgorithmException, MalformedURLException {
        if (tsaUrl != null) {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            this.tsaClient = new TSAClient(new URL(tsaUrl), null, null, digest);
        }
    }

    public byte[] getTimeStampToken(InputStream content) throws IOException {
        return this.tsaClient.getTimeStampToken(IOUtils.toByteArray((InputStream)content));
    }

    public CMSSignedData addSignedTimeStamp(CMSSignedData signedData) throws IOException {
        SignerInformationStore signerStore = signedData.getSignerInfos();
        ArrayList<SignerInformation> newSigners = new ArrayList<SignerInformation>();
        for (SignerInformation signer : signerStore.getSigners()) {
            newSigners.add(this.signTimeStamp(signer));
        }
        return CMSSignedData.replaceSigners((CMSSignedData)signedData, (SignerInformationStore)new SignerInformationStore(newSigners));
    }

    private SignerInformation signTimeStamp(SignerInformation signer) throws IOException {
        AttributeTable unsignedAttributes = signer.getUnsignedAttributes();
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (unsignedAttributes != null) {
            vector = unsignedAttributes.toASN1EncodableVector();
        }
        byte[] token = this.tsaClient.getTimeStampToken(signer.getSignature());
        ASN1ObjectIdentifier oid = PKCSObjectIdentifiers.id_aa_signatureTimeStampToken;
        Attribute signatureTimeStamp = new Attribute(oid, (ASN1Set)new DERSet((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])token)));
        vector.add((ASN1Encodable)signatureTimeStamp);
        Attributes signedAttributes = new Attributes(vector);
        return SignerInformation.replaceUnsignedAttributes((SignerInformation)signer, (AttributeTable)new AttributeTable(signedAttributes));
    }
}

