/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.adminclient;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.naming.InitialContext;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.adminclient.EntityBean;
import org.imixs.workflow.jee.ejb.EntityServiceRemote;

public class EntityServiceFacade {
    private final String DEPRECATED_NO_VERSION = "DEPRECATED-NO-VERSION";
    private String indexName;
    private int indexType;
    private ArrayList indexList = new ArrayList();
    private List<ItemCollection> entities = null;
    private ArrayList<Map> models = null;
    private String query = "SELECT entity FROM Entity entity \nORDER BY entity.created DESC";
    private String filename = "/home/ix-jee-export";
    private String loginfo = "";
    private String ejbEntityServiceName = "";
    int row = 0;
    int count = 30;
    private boolean endOfList = false;
    private HtmlDataTable dataTable;
    private EntityBean entityBean = (EntityBean)FacesContext.getCurrentInstance().getApplication().getELResolver().getValue(FacesContext.getCurrentInstance().getELContext(), null, (Object)"entityBean");
    EntityServiceRemote entityService = null;
    String errorMessage = "";
    String currentModelVersion;
    private String updateField;
    private String updateValue;
    private String updateFieldType;

    public String getLoginfo() {
        return this.loginfo;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setErrorMessage(String error_Message) {
        this.errorMessage = error_Message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void setRow(int startpos) {
        this.row = startpos;
    }

    public int getRow() {
        return this.row;
    }

    public String getUpdateField() {
        return this.updateField;
    }

    public void setUpdateField(String updateField) {
        this.updateField = updateField;
    }

    public String getUpdateFieldType() {
        return this.updateFieldType;
    }

    public void setUpdateFieldType(String updateFieldType) {
        this.updateFieldType = updateFieldType;
    }

    public String getUpdateValue() {
        return this.updateValue;
    }

    public void setUpdateValue(String updateValue) {
        this.updateValue = updateValue;
    }

    public void doDelete(ActionEvent event) throws Exception {
        ItemCollection currentSelection = null;
        UIComponent component = event.getComponent();
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            currentSelection = (ItemCollection)((UIData)parent).getRowData();
            this.entityService.remove(currentSelection);
            this.doRefresh(event);
        }
    }

    public void doRefresh(ActionEvent event) {
        this.entities = null;
    }

    public void doReset(ActionEvent event) {
        this.entities = null;
        this.row = 0;
    }

    public void doSelectModel(ActionEvent event) throws Exception {
        Map currentSelection = null;
        UIComponent component = event.getComponent();
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            currentSelection = (Map)((UIData)parent).getRowData();
            break;
        }
        this.currentModelVersion = currentSelection.get("$modelversion").toString();
        System.out.println("SELECTED MODEL: " + this.currentModelVersion);
    }

    public void doDeleteModel(ActionEvent event) throws Exception {
        System.out.println("DELETING MODEL: " + this.currentModelVersion);
        String sQuery = "DEPRECATED-NO-VERSION".equals(this.currentModelVersion) ? "SELECT process FROM Entity AS process \t JOIN process.textItems as t\t WHERE t.itemName = 'type' AND t.itemValue IN('ProcessEntity', 'ActivityEntity', 'WorkflowEnvironmentEntity')" : "SELECT process FROM Entity AS process \t JOIN process.textItems as t\t JOIN process.textItems as v\t WHERE t.itemName = 'type' AND t.itemValue IN('ProcessEntity', 'ActivityEntity', 'WorkflowEnvironmentEntity') \t AND v.itemName = '$modelversion' AND v.itemValue = '" + this.currentModelVersion + "'";
        Collection col = this.entityService.findAllEntities(sQuery, 0, -1);
        for (ItemCollection aworkitem : col) {
            if ("DEPRECATED-NO-VERSION".equals(this.currentModelVersion)) {
                if (aworkitem.hasItem("$modelversion")) continue;
                this.entityService.remove(aworkitem);
                continue;
            }
            this.entityService.remove(aworkitem);
        }
        this.models = null;
    }

    public void doSearch(ActionEvent e) {
        this.entities = null;
    }

    private void loadEntities() {
        this.entities = new ArrayList();
        this.setErrorMessage("");
        if (this.entityService != null && this.query != null && !"".equals(this.query)) {
            System.out.println("AdminClient Load Entities: " + this.query);
            try {
                Collection col = this.entityService.findAllEntities(this.query, this.row, this.count);
                this.endOfList = col.size() < this.count;
                for (ItemCollection aworkitem : col) {
                    this.entities.add(aworkitem);
                }
            }
            catch (Exception eqle) {
                this.setErrorMessage(eqle.getLocalizedMessage());
            }
        }
    }

    public String doSaveIndex() {
        try {
            this.entityService.addIndex(this.indexName, this.indexType);
            return "indexliste";
        }
        catch (Exception e) {
            return "failure";
        }
    }

    public void doDeleteIndex(ActionEvent event) {
        try {
            List children = event.getComponent().getChildren();
            for (int i = 0; i < children.size(); ++i) {
                UIParameter currentParam;
                if (!(children.get(i) instanceof UIParameter) || !(currentParam = (UIParameter)children.get(i)).getName().equals("name") || currentParam.getValue() == null) continue;
                this.indexName = currentParam.getValue().toString();
            }
            this.entityService.removeIndex(this.indexName);
        }
        catch (Exception e) {
            System.out.println("m2: Index delete error: " + e);
        }
    }

    public void doSelect(ActionEvent event) {
        ItemCollection currentSelection = null;
        UIComponent component = event.getComponent();
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIData)) continue;
            currentSelection = (ItemCollection)((UIData)parent).getRowData();
            this.entityBean.setEntity(currentSelection);
            break;
        }
    }

    public void doQueryModelVersions(ActionEvent e) throws Exception {
        this.models = new ArrayList();
        if (this.entityService != null) {
            String modelQuery = "SELECT process FROM Entity AS process JOIN process.textItems as t JOIN process.textItems as n WHERE t.itemName = 'type' AND t.itemValue = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' AND n.itemValue = 'environment.profile'";
            Collection col = this.entityService.findAllEntities(modelQuery, 0, -1);
            for (ItemCollection aworkitem : col) {
                Map map = aworkitem.getAllItems();
                map.put("entity_id", aworkitem.getItemValueString("$uniqueid"));
                map.put("entity_created", aworkitem.getItemValueDate("$created"));
                String sModel = "DEPRECATED-NO-VERSION";
                if (aworkitem.hasItem("$modelversion")) {
                    sModel = aworkitem.getItemValueString("$modelversion");
                }
                map.put("$modelversion", sModel);
                map.put("entity_modified", aworkitem.getItemValueDate("$modified"));
                this.models.add(map);
            }
        }
    }

    public ArrayList<Map> getModels() {
        if (this.models == null) {
            try {
                this.doQueryModelVersions(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.models;
    }

    public HtmlDataTable getDataTable() {
        return this.dataTable;
    }

    public void setDataTable(HtmlDataTable dataTable) {
        this.dataTable = dataTable;
    }

    public List<ItemCollection> getEntities() {
        if (this.entities == null) {
            this.loadEntities();
        }
        return this.entities;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String aname) {
        this.indexName = aname;
    }

    public int getIndexType() {
        return this.indexType;
    }

    public void setIndexType(int type) {
        this.indexType = type;
    }

    public List getIndexList() {
        this.indexList = new ArrayList();
        return this.indexList;
    }

    public boolean isEndOfList() {
        return this.endOfList;
    }

    public void loadNext(ActionEvent e) {
        this.row += this.count;
        this.doSearch(e);
    }

    public void loadPrev(ActionEvent e) {
        this.row -= this.count;
        if (this.row < 0) {
            this.row = 0;
        }
        this.doSearch(e);
    }

    public String exportWorkItemList() throws Exception {
        boolean hasMoreData = true;
        int JUNK_SIZE = 100;
        long totalcount = 0L;
        int startpos = 0;
        if (this.entityService != null) {
            int icount = 0;
            if (this.filename == null || "".equals(this.filename)) {
                return "";
            }
            if (this.query == null | "".equals(this.query)) {
                return "";
            }
            try {
                FileOutputStream fos = new FileOutputStream(this.filename);
                ObjectOutputStream out = new ObjectOutputStream(fos);
                while (hasMoreData) {
                    Collection col = this.entityService.findAllEntities(this.query, startpos, JUNK_SIZE);
                    if (col.size() < JUNK_SIZE) {
                        hasMoreData = false;
                    }
                    startpos += col.size();
                    System.out.println("ExportWorktiems - read " + (totalcount += (long)col.size()) + " entries....");
                    for (ItemCollection aworkitem : col) {
                        Map hmap = aworkitem.getAllItems();
                        out.writeObject(hmap);
                        ++icount;
                    }
                }
                out.close();
                this.loginfo = "Export successfull! " + icount + " Entities exported into " + this.filename + ".";
            }
            catch (IOException ex) {
                this.loginfo = "Export Error : " + ex.getMessage();
                ex.printStackTrace();
            }
        }
        return "success";
    }

    public String importWorkItemList() throws Exception {
        int JUNK_SIZE = 100;
        long totalcount = 0L;
        int icount = 0;
        if (this.entityService != null) {
            if (this.filename == null || "".equals(this.filename)) {
                return "";
            }
            if (this.query == null | "".equals(this.query)) {
                return "";
            }
            try {
                FileInputStream fis = new FileInputStream(this.filename);
                ObjectInputStream in = new ObjectInputStream(fis);
                try {
                    Map hmap;
                    ItemCollection itemCol;
                    while ((itemCol = new ItemCollection(hmap = (Map)in.readObject())) != null) {
                        String aImportUniqueID = itemCol.getItemValueString("$Uniqueid");
                        if (!itemCol.hasItem("$WriteAccess")) {
                            itemCol.replaceItemValue("$WriteAccess", (Object)itemCol.getItemValue("namWorkflowWriteAccess"));
                        }
                        if (!itemCol.hasItem("$ReadAccess")) {
                            itemCol.replaceItemValue("$ReadAccess", (Object)itemCol.getItemValue("namWorkflowReadAccess"));
                        }
                        this.entityService.save(itemCol);
                        ++totalcount;
                        if (++icount < JUNK_SIZE) continue;
                        icount = 0;
                        System.out.println("ImportWorktiems - read " + totalcount + " entries....");
                    }
                }
                catch (EOFException eofe) {
                    // empty catch block
                }
                this.loginfo = "Import successfull! " + totalcount + " Entities imported from " + this.filename + ".";
                in.close();
            }
            catch (IOException ex) {
                this.loginfo = "Export Error : " + ex.getMessage();
                ex.printStackTrace();
            }
        }
        return "success";
    }

    public void removeWorkItemList(ActionEvent event) throws Exception {
        if (this.entityService != null) {
            if (this.query == null | "".equals(this.query)) {
                return;
            }
            this.entities = null;
            Collection col = this.entityService.findAllEntities(this.query, this.row, this.count);
            for (ItemCollection aworkitem : col) {
                this.entityService.remove(aworkitem);
            }
        }
    }

    public void bulkUpdateWorkItemList(ActionEvent event) throws Exception {
        if (this.entityService != null) {
            if (this.query == null | "".equals(this.query)) {
                return;
            }
            if (this.updateField == null | "".equals(this.updateField)) {
                return;
            }
            if (this.updateValue == null) {
                return;
            }
            Vector<Object> vNewValueList = new Vector<Object>();
            String[] tokens = this.updateValue.split("\n");
            for (int i = 0; i < tokens.length; ++i) {
                String sValue = tokens[i].trim();
                if ("1".equals(this.updateFieldType)) {
                    vNewValueList.addElement(new Integer(sValue));
                    continue;
                }
                if ("2".equals(this.updateFieldType)) {
                    vNewValueList.addElement(new Double(sValue));
                    continue;
                }
                if ("3".equals(this.updateFieldType)) {
                    SimpleDateFormat cetFormat = new SimpleDateFormat("dd/MM/yyyy:hh:mm:ss", Locale.ENGLISH);
                    vNewValueList.addElement(cetFormat.parse(sValue));
                    continue;
                }
                vNewValueList.addElement(sValue);
            }
            this.entities = null;
            Collection col = this.entityService.findAllEntities(this.query, this.row, this.count);
            for (ItemCollection aworkitem : col) {
                aworkitem.replaceItemValue(this.updateField, vNewValueList);
                this.entityService.save(aworkitem);
            }
        }
    }

    public String getEjbEntityPersistenceManagerName() {
        return this.ejbEntityServiceName;
    }

    public void setEjbEntityPersistenceManagerName(String ejbModuleName) throws Exception {
        this.ejbEntityServiceName = ejbModuleName;
        if (ejbModuleName == null || "".equals(ejbModuleName)) {
            return;
        }
        try {
            String globalJNDIName = "java:global/" + this.ejbEntityServiceName + "/EntityService!org.imixs.workflow.jee.ejb.EntityServiceRemote";
            InitialContext ic = new InitialContext();
            this.entityService = (EntityServiceRemote)ic.lookup(globalJNDIName);
            this.entityBean.setIndexList(this.getIndexList());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.entityService = null;
        }
    }

    public boolean isEntityPersistenceManagerLoaded() {
        return this.entityService != null;
    }
}

