/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.adminclient;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIParameter;
import javax.faces.event.ActionEvent;
import javax.naming.InitialContext;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.jee.ejb.WorkflowSchedulerRemote;

public class ScheduleWorkflowBean {
    private String ejbScheduledWorkflowServiceName = "";
    WorkflowSchedulerRemote scheduledWorkflowService = null;
    boolean enabled;
    Date stopDate;
    int hours = 24;
    int minutes;
    private ItemCollection timerDescription = new ItemCollection();

    public boolean isScheduledWorkflowServiceLoaded() {
        return this.scheduledWorkflowService != null;
    }

    public String getEjbScheduledWorkflowServiceName() {
        return this.ejbScheduledWorkflowServiceName;
    }

    public void setEjbScheduledWorkflowServiceName(String ejbName) {
        if (ejbName == null || "".equals(ejbName)) {
            return;
        }
        try {
            this.ejbScheduledWorkflowServiceName = ejbName;
            InitialContext ic = new InitialContext();
            this.scheduledWorkflowService = (WorkflowSchedulerRemote)ic.lookup(ejbName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.scheduledWorkflowService = null;
        }
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public boolean isEnabled() {
        ItemCollection itemCol = null;
        String id = this.timerDescription.getItemValueString("id");
        if (!"".equals(id)) {
            try {
                itemCol = this.scheduledWorkflowService.findTimerDescription(id);
                if (!id.equals(itemCol.getItemValueString("id"))) {
                    itemCol = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                itemCol = null;
            }
        }
        return itemCol != null;
    }

    public void doCreate(ActionEvent event) {
        int interval = (this.minutes + this.hours * 60) * 60 * 1000;
        try {
            ItemCollection itmcol = new ItemCollection();
            itmcol.replaceItemValue("numInterval", (Object)interval);
            Calendar calNow = Calendar.getInstance();
            Date startDate = calNow.getTime();
            itmcol.replaceItemValue("datstart", (Object)startDate);
            calNow = Calendar.getInstance();
            this.stopDate = calNow.getTime();
            itmcol.replaceItemValue("datstop", (Object)this.stopDate);
            this.timerDescription = itmcol;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doEnable(ActionEvent event) {
        int interval = (this.getMinutes() + this.getHours() * 60) * 60 * 1000;
        try {
            this.timerDescription.replaceItemValue("numInterval", (Object)interval);
            String id = this.timerDescription.getItemValueString("id");
            this.scheduledWorkflowService.scheduleWorkflow(this.timerDescription);
            this.timerDescription = this.scheduledWorkflowService.findTimerDescription(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doDisable(ActionEvent event) {
        try {
            String id = this.timerDescription.getItemValueString("id");
            this.scheduledWorkflowService.cancelScheduleWorkflow(id);
            this.timerDescription = new ItemCollection();
            this.timerDescription.replaceItemValue("id", (Object)id);
        }
        catch (Exception e) {
            this.scheduledWorkflowService = null;
        }
    }

    public void doReschedule(ActionEvent event) {
        try {
            ItemCollection itemcol;
            String id = this.timerDescription.getItemValueString("id");
            this.scheduledWorkflowService.cancelScheduleWorkflow(id);
            int interval = (this.getMinutes() + this.getHours() * 60) * 60 * 1000;
            this.timerDescription.replaceItemValue("numInterval", (Object)interval);
            this.scheduledWorkflowService.scheduleWorkflow(this.timerDescription);
            this.timerDescription = itemcol = this.scheduledWorkflowService.findTimerDescription(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void findTimerByID(String id) {
        try {
            ItemCollection itemcol = this.scheduledWorkflowService.findTimerDescription(id);
            if (itemcol == null) {
                itemcol = new ItemCollection();
                itemcol.replaceItemValue("id", (Object)id);
            }
            int iIntervall = itemcol.getItemValueInteger("numinterval");
            iIntervall /= 1000;
            this.hours = (iIntervall /= 60) / 60;
            this.minutes = iIntervall - this.hours * 60;
            this.timerDescription = itemcol;
        }
        catch (Exception e) {
            this.scheduledWorkflowService = null;
        }
    }

    public void loadTimer(ActionEvent event) {
        List children = event.getComponent().getChildren();
        String sID = "";
        for (int i = 0; i < children.size(); ++i) {
            UIParameter currentParam;
            if (!(children.get(i) instanceof UIParameter) || !(currentParam = (UIParameter)children.get(i)).getName().equals("id") || currentParam.getValue() == null) continue;
            sID = currentParam.getValue().toString();
        }
        this.findTimerByID(sID);
    }

    public ArrayList<ItemCollection> getTimers() throws Exception {
        ArrayList<ItemCollection> timerList = new ArrayList<ItemCollection>();
        Collection col = this.scheduledWorkflowService.findAllTimerDescriptions();
        for (ItemCollection adescription : col) {
            timerList.add(adescription);
        }
        return timerList;
    }

    public Map getItem() throws Exception {
        return this.timerDescription.getItem();
    }

    public Map getItemList() throws Exception {
        return this.timerDescription.getItemList();
    }

    public Map getItemListArray() throws Exception {
        return this.timerDescription.getItemListArray();
    }
}

