/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.util.Enumeration;
import java.util.Vector;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;

public class AccessPlugin
implements Plugin {
    ItemCollection documentContext;
    ItemCollection documentActivity;
    Vector itemReadRollback;
    Vector itemWriteRollback;
    WorkflowContext workflowContext;

    public void init(WorkflowContext actx) throws Exception {
        this.workflowContext = actx;
    }

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws Exception {
        try {
            int j;
            this.documentContext = adocumentContext;
            this.documentActivity = adocumentActivity;
            this.validate();
            Vector itemRead = this.documentContext.getItemValue("$readAccess");
            this.itemReadRollback = this.documentContext.getItemValue("$readAccess");
            Vector vectorAccess = "1".equals(this.documentActivity.getItemValueString("keyaccessmode")) ? itemRead : new Vector();
            if (this.workflowContext.getDebugLevel() == 2) {
                System.out.println("[AccessPlugin] AccessMode: '" + this.documentActivity.getItemValueString("keyaccessmode") + "'");
            }
            if (vectorAccess == null) {
                vectorAccess = new Vector();
            }
            this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("namaddreadaccess"));
            this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("keyaddreadroles"));
            this.mergeMappedFieldValues(vectorAccess, this.documentActivity.getItemValue("keyaddreadfields"));
            vectorAccess = this.uniqueVector(vectorAccess);
            this.documentContext.replaceItemValue("$readAccess", vectorAccess);
            if (this.workflowContext.getDebugLevel() == 2 && vectorAccess.size() > 0) {
                System.out.println("[AccessPlugin] ReadAccess:");
                for (j = 0; j < vectorAccess.size(); ++j) {
                    System.out.println("              " + (String)vectorAccess.elementAt(j));
                }
            }
            Vector itemWrite = this.documentContext.getItemValue("$writeAccess");
            this.itemWriteRollback = this.documentContext.getItemValue("$writeAccess");
            vectorAccess = "1".equals(this.documentActivity.getItemValueString("keyaccessmode")) ? itemWrite : new Vector();
            if (vectorAccess == null) {
                vectorAccess = new Vector();
            }
            this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("namaddwriteaccess"));
            this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("keyaddwriteroles"));
            this.mergeMappedFieldValues(vectorAccess, this.documentActivity.getItemValue("keyaddwritefields"));
            vectorAccess = this.uniqueVector(vectorAccess);
            this.documentContext.replaceItemValue("$writeAccess", vectorAccess);
            if (this.workflowContext.getDebugLevel() == 2 && vectorAccess.size() > 0) {
                System.out.println("[AccessPlugin] WriteAccess:");
                for (j = 0; j < vectorAccess.size(); ++j) {
                    System.out.println("               " + (String)vectorAccess.elementAt(j));
                }
            }
        }
        catch (Exception e) {
            System.out.println("[AccessPlugin] Error run()" + e.toString());
            return 2;
        }
        return 0;
    }

    public void close(int status) throws Exception {
        try {
            if (status == 2) {
                this.documentContext.replaceItemValue("$writeAccess", this.itemWriteRollback);
                this.documentContext.replaceItemValue("$readAccess", this.itemReadRollback);
            }
        }
        catch (Exception e) {
            System.out.println("[AccessPlugin] Error close() " + e.toString());
            throw e;
        }
    }

    private void mergeVectors(Vector p_VectorDestination, Vector p_VectorSource) {
        if (p_VectorSource != null && p_VectorSource.size() > 0) {
            Enumeration enumSource = p_VectorSource.elements();
            while (enumSource.hasMoreElements()) {
                Object o = enumSource.nextElement();
                if (p_VectorDestination.indexOf(o) != -1) continue;
                p_VectorDestination.addElement(o);
            }
        }
    }

    private void mergeMappedFieldValues(Vector p_VectorDestination, Vector p_VectorFieldList) {
        try {
            if (p_VectorFieldList != null && p_VectorFieldList.size() > 0) {
                Enumeration enumFields = p_VectorFieldList.elements();
                while (enumFields.hasMoreElements()) {
                    String sFeldName = (String)enumFields.nextElement();
                    Vector vValues = this.documentContext.getItemValue(sFeldName);
                    if (vValues == null || vValues.size() <= 0) continue;
                    Enumeration enumValues = vValues.elements();
                    while (enumValues.hasMoreElements()) {
                        Object o = enumValues.nextElement();
                        if (p_VectorDestination.indexOf(o) != -1) continue;
                        p_VectorDestination.addElement(o);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("[AccessPlugin] Error addMappedFieldValuesToVector() " + e.toString());
        }
    }

    private void validate() throws Exception {
        try {
            if (!this.documentActivity.hasItem("keyaccessmode")) {
                this.documentActivity.replaceItemValue("keyaccessmode", "");
            }
            if (!this.documentActivity.hasItem("namaddreadaccess")) {
                this.documentActivity.replaceItemValue("namaddreadaccess", "");
            }
            if (!this.documentActivity.hasItem("keyaddreadroles")) {
                this.documentActivity.replaceItemValue("keyaddreadroles", "");
            }
            if (!this.documentActivity.hasItem("keyaddreadfields")) {
                this.documentActivity.replaceItemValue("keyaddreadfields", "");
            }
            if (!this.documentActivity.hasItem("namaddwriteaccess")) {
                this.documentActivity.replaceItemValue("namaddwriteaccess", "");
            }
            if (!this.documentActivity.hasItem("keyaddwriteroles")) {
                this.documentActivity.replaceItemValue("keyaddwriteroles", "");
            }
            if (!this.documentActivity.hasItem("keyaddreadfields")) {
                this.documentActivity.replaceItemValue("keyaddreadfields", "");
            }
            if (!this.documentContext.hasItem("$readAccess")) {
                this.documentContext.replaceItemValue("$readAccess", "");
            }
            if (!this.documentContext.hasItem("$writeAccess")) {
                this.documentContext.replaceItemValue("$writeAccess", "");
            }
        }
        catch (Exception e) {
            System.out.println("[AccessPlugin] Error validate()() " + e.toString());
            throw e;
        }
    }

    private Vector uniqueVector(Vector p_Vector) {
        int iVectorSize = p_Vector.size();
        Vector cleanedVector = new Vector();
        for (int i = 0; i < iVectorSize; ++i) {
            Object o = p_Vector.elementAt(i);
            if (o == null || cleanedVector.indexOf(o) > -1 || "".equals(o.toString())) continue;
            cleanedVector.add(o);
        }
        p_Vector = cleanedVector;
        if (p_Vector.size() == 0) {
            p_Vector.addElement("");
        }
        return p_Vector;
    }
}

