/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.services.dataobjects;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.services.dataobjects.Entity;
import org.imixs.workflow.services.dataobjects.Item;

public class EntityAdapter {
    public static ItemCollection getItemCollection(Entity entity) {
        ItemCollection itemCol = new ItemCollection();
        if (entity == null) {
            return itemCol;
        }
        try {
            Item[] items = entity.getItems();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    Item it = items[i];
                    String key = it.getName();
                    Vector<Object> myVector = new Vector<Object>(Arrays.asList(it.getValues()));
                    itemCol.replaceItemValue(key, myVector);
                }
            }
        }
        catch (Exception e) {
            System.out.println("[EntityAdapter] getItemCollection error");
            System.out.println(e.toString());
            itemCol = null;
        }
        return itemCol;
    }

    public static Entity putItemCollection(ItemCollection aItemCollection) throws Exception {
        String sName = null;
        Entity entity = new Entity();
        int i = 0;
        try {
            if (aItemCollection != null) {
                Iterator it = aItemCollection.getAllItems().entrySet().iterator();
                int max = aItemCollection.getAllItems().entrySet().size();
                Item[] items = new Item[max];
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    sName = (String)entry.getKey();
                    Vector vOrg = (Vector)entry.getValue();
                    Item item = new Item();
                    item.setName(sName);
                    item.setValues(vOrg.toArray());
                    items[i] = item;
                    ++i;
                }
                entity.setItems(items);
            }
        }
        catch (Exception e) {
            System.out.println("[EntityAdapter] Error putItemCollection (" + sName + ")");
            throw e;
        }
        return entity;
    }
}

