/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.imixs.workflow.ItemCollection;

public class ItemCollectionAdapter {
    ItemCollection itemCollection;
    ItemAdapter itemAdapter;
    ItemListAdapter itemListAdapter;
    ItemListArrayAdapter itemListArrayAdapter;

    public ItemCollectionAdapter() {
        this.itemCollection = new ItemCollection();
        this.itemAdapter = new ItemAdapter(this.itemCollection);
        this.itemListAdapter = new ItemListAdapter(this.itemCollection);
        this.itemListArrayAdapter = new ItemListArrayAdapter(this.itemCollection);
    }

    public ItemCollectionAdapter(ItemCollection acol) {
        this.itemCollection = acol;
        this.itemAdapter = new ItemAdapter(this.itemCollection);
        this.itemListAdapter = new ItemListAdapter(this.itemCollection);
        this.itemListArrayAdapter = new ItemListArrayAdapter(this.itemCollection);
    }

    public ItemCollection getItemCollection() {
        return this.itemCollection;
    }

    public void setItemCollection(ItemCollection acol) {
        this.itemCollection = acol;
        this.itemAdapter.setItemCollection(this.itemCollection);
        this.itemListAdapter.setItemCollection(this.itemCollection);
        this.itemListArrayAdapter.setItemCollection(this.itemCollection);
    }

    public Map getItem() {
        return this.itemAdapter;
    }

    public Map getItemList() {
        return this.itemListAdapter;
    }

    public Map getItemListArray() {
        return this.itemListArrayAdapter;
    }

    class ItemListArrayAdapter
    extends ItemAdapter {
        public ItemListArrayAdapter(ItemCollection acol) {
            this.itemCollection = acol;
        }

        public Object get(Object key) {
            try {
                if (!this.itemCollection.hasItem(key.toString())) {
                    this.itemCollection.replaceItemValue(key.toString(), "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList aList = new ArrayList();
            Vector col = this.itemCollection.getItemValue(key.toString());
            for (Object aEntryValue : col) {
                aList.add(aEntryValue);
            }
            return aList;
        }

        public Object put(Object key, Object value) {
            try {
                String valueClass = value.getClass().getName();
                if (value instanceof List) {
                    Vector v = new Vector();
                    List aList = (List)value;
                    for (Object aEntryValue : aList) {
                        v.add(aEntryValue);
                    }
                    this.itemCollection.replaceItemValue(key.toString(), v);
                } else {
                    this.itemCollection.replaceItemValue(key.toString(), value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return value;
        }
    }

    class ItemListAdapter
    extends ItemAdapter {
        public ItemListAdapter(ItemCollection acol) {
            this.itemCollection = acol;
        }

        public Object get(Object key) {
            try {
                if (!this.itemCollection.hasItem(key.toString())) {
                    this.itemCollection.replaceItemValue(key.toString(), "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.itemCollection.getItemValue(key.toString());
        }
    }

    class ItemAdapter
    implements Map {
        ItemCollection itemCollection;

        public ItemAdapter() {
            this.itemCollection = new ItemCollection();
        }

        public ItemAdapter(ItemCollection acol) {
            this.itemCollection = acol;
        }

        public void setItemCollection(ItemCollection acol) {
            this.itemCollection = acol;
        }

        public Object get(Object key) {
            try {
                if (!this.itemCollection.hasItem(key.toString())) {
                    this.itemCollection.replaceItemValue(key.toString(), "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Vector v = this.itemCollection.getItemValue(key.toString());
            if (v.size() > 0) {
                return v.firstElement();
            }
            return null;
        }

        public Object put(Object key, Object value) {
            try {
                this.itemCollection.replaceItemValue(key.toString(), value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return value;
        }

        public void clear() {
            this.itemCollection.getAllItems().clear();
        }

        public boolean containsKey(Object key) {
            return this.itemCollection.getAllItems().containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.itemCollection.getAllItems().containsValue(value);
        }

        public Set entrySet() {
            return this.itemCollection.getAllItems().entrySet();
        }

        public boolean isEmpty() {
            return this.itemCollection.getAllItems().isEmpty();
        }

        public Set keySet() {
            return this.itemCollection.getAllItems().keySet();
        }

        public void putAll(Map m) {
            this.itemCollection.getAllItems().putAll(m);
        }

        public Object remove(Object key) {
            return this.itemCollection.getAllItems().remove(key);
        }

        public int size() {
            return this.itemCollection.getAllItems().size();
        }

        public Collection values() {
            return this.itemCollection.getAllItems().values();
        }
    }
}

