/*******************************************************************************
 *  Imixs IX Workflow Technology
 *  Copyright (C) 2001, 2008 Imixs Software Solutions GmbH,  
 *  http://www.imixs.com
 *  
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the terms of the GNU General Public License 
 *  as published by the Free Software Foundation; either version 2 
 *  of the License, or (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 *  General Public License for more details.
 *  
 *  You can receive a copy of the GNU General Public
 *  License at http://www.gnu.org/licenses/gpl.html
 *  
 *  Contributors:  
 *  	Imixs Software Solutions GmbH - initial API and implementation
 *  	Ralph Soika
 *******************************************************************************/

package org.imixs.workflow;

/**
 * This Interface defines the Context which is used to supply a basic enviroment
 * for the exchange between a WorkflowManager an the registered Plugin Moduls.
 * Normaly the WorkflowManager Implementation itself implents this Interface to
 * provide the Context for the Workflow components.
 * 
 * @author imixs.com
 * @version 1.0
 * @see org.imixs.workflow.WorkflowKernel
 */

public interface WorkflowContext {

	/**
	 * This Methode returns the Runtime enviroment for a workflow
	 * Implementation. is usesd to initialize the plugin.
	 * 
	 * @return a Session Object
	 */
	public Object getSessionContext();

	/**
	 * This Methode returns a defined Model Implementation.
	 * 
	 * @return Model
	 */
	public Model getModel();

	/**
	 * This Methode returns the defined DebugLevel.
	 * 
	 * @return DebugLevel
	 */
	public int getDebugLevel();
}
