package org.imixs.workflow.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import org.imixs.workflow.ItemCollection;

/**
 * This Class adapts the Imixs ItemCollection Class for usage in a JSF
 * Application. Using the ItemCollectionAdapter allows simplified access to
 * attributes from a JSP/JSF page
 * 
 * Each attribute accessed by the ItemCollectionAdapter will be added
 * automatically to the corresponding ItemCollection Class
 * 
 * Examples:
 * 
 * #{myControllerMB.item['numpersonen']}
 * 
 * #{myControllerMB.itemList['teamlist']}
 * 
 * @author rsoika
 * 
 */
public class ItemCollectionAdapter {
	ItemCollection itemCollection;

	ItemAdapter itemAdapter;
	ItemListAdapter itemListAdapter;
	ItemListArrayAdapter itemListArrayAdapter;

	public ItemCollectionAdapter() {
		itemCollection = new ItemCollection();
		itemAdapter = new ItemAdapter(itemCollection);
		itemListAdapter = new ItemListAdapter(itemCollection);
		itemListArrayAdapter = new ItemListArrayAdapter(itemCollection);
	}

	public ItemCollectionAdapter(ItemCollection acol) {
		itemCollection = acol;
		itemAdapter = new ItemAdapter(itemCollection);
		itemListAdapter = new ItemListAdapter(itemCollection);
		itemListArrayAdapter = new ItemListArrayAdapter(itemCollection);
	}

	public ItemCollection getItemCollection() {
		return itemCollection;
	}

	public void setItemCollection(ItemCollection acol) {
		itemCollection = acol;
		itemAdapter.setItemCollection(itemCollection);
		itemListAdapter.setItemCollection(itemCollection);
		itemListArrayAdapter.setItemCollection(itemCollection);
	}

	public Map getItem() {
		return itemAdapter;
	}

	public Map getItemList() {
		return itemListAdapter;
	}

	public Map getItemListArray() {
		return itemListArrayAdapter;
	}

	/**
	 * This class helps to addapt the behavior of a singel value item to be used
	 * in a jsf page using a expression language like this:
	 * 
	 * #{mybean.item['txtMyItem']}
	 * 
	 * 
	 * @author rsoika
	 * 
	 */
	class ItemAdapter implements Map {
		ItemCollection itemCollection;

		public ItemAdapter() {
			itemCollection = new ItemCollection();
		}

		public ItemAdapter(ItemCollection acol) {
			itemCollection = acol;
		}

		public void setItemCollection(ItemCollection acol) {
			itemCollection = acol;
		}

		/**
		 * returns a single value out of the ItemCollection if the key dos not
		 * exist the method will create a value automatical
		 */
		@SuppressWarnings("unchecked")
		public Object get(Object key) {
			// check if a value for this key is available...
			// if not create a new empty value
			try {
				if (!itemCollection.hasItem(key.toString()))
					itemCollection.replaceItemValue(key.toString(), "");
			} catch (Exception e) {

				e.printStackTrace();
			}

			// return first value from vector if size >0
			Vector v = itemCollection.getItemValue(key.toString());
			if (v.size() > 0)
				return v.firstElement();
			else
				// otherwise return null
				return null;
		}

		/**
		 * puts a single value into the ItemCollection
		 */
		public Object put(Object key, Object value) {
			try {
				itemCollection.replaceItemValue(key.toString(), value);
			} catch (Exception e) {
				e.printStackTrace();
			}
			return value;
		}

		/* ############### Default methods ################# */

		public void clear() {
			itemCollection.getAllItems().clear();
		}

		public boolean containsKey(Object key) {
			return itemCollection.getAllItems().containsKey(key);
		}

		public boolean containsValue(Object value) {
			return itemCollection.getAllItems().containsValue(value);
		}

		public Set entrySet() {
			return itemCollection.getAllItems().entrySet();
		}

		public boolean isEmpty() {
			return itemCollection.getAllItems().isEmpty();
		}

		public Set keySet() {
			return itemCollection.getAllItems().keySet();
		}

		public void putAll(Map m) {
			itemCollection.getAllItems().putAll(m);

		}

		public Object remove(Object key) {
			return itemCollection.getAllItems().remove(key);
		}

		public int size() {
			return itemCollection.getAllItems().size();
		}

		public Collection values() {
			return itemCollection.getAllItems().values();
		}

	}

	/**
	 * This class helps to addapt the behavior of a multivalue item to be used
	 * in a jsf page using a expression language like this:
	 * 
	 * #{mybean.item['txtMyList']}
	 * 
	 * 
	 * @author rsoika
	 * 
	 */
	class ItemListAdapter extends ItemAdapter {

		public ItemListAdapter(ItemCollection acol) {
			itemCollection = acol;
		}

		/**
		 * returns a multi value out of the ItemCollection if the key dos not
		 * exist the method will create a value automatical
		 */
		public Object get(Object key) {
			// check if a value for this key is available...
			// if not create a new empty value
			try {
				if (!itemCollection.hasItem(key.toString()))
					itemCollection.replaceItemValue(key.toString(), "");
			} catch (Exception e) {

				e.printStackTrace();
			}
			// return vector
			return itemCollection.getItemValue(key.toString());
		}

	}

	class ItemListArrayAdapter extends ItemAdapter {

		public ItemListArrayAdapter(ItemCollection acol) {
			itemCollection = acol;
		}

		/**
		 * returns a multi value out of the ItemCollection if the key dos not
		 * exist the method will create a value automatical
		 */
		public Object get(Object key) {
			// check if a value for this key is available...
			// if not create a new empty value
			try {
				if (!itemCollection.hasItem(key.toString()))
					itemCollection.replaceItemValue(key.toString(), "");
			} catch (Exception e) {
				e.printStackTrace();
			}
			// return new ArrayList Object containing values from vector
			ArrayList<Object> aList = new ArrayList<Object>();
			Collection col=itemCollection.getItemValue(key.toString());			
			for (Object aEntryValue : col) {
				aList.add(aEntryValue);
			}
			return aList;

		}

		/**
		 * puts a arraylist value into the ItemCollection
		 */
		public Object put(Object key, Object value) {
			try {
				String valueClass=value.getClass().getName();
				// convert List into Vector object
				if (value instanceof List) {
					Vector v=new Vector();
					List aList=(List)value;					
					for (Object aEntryValue : aList) {
						v.add(aEntryValue);						
					}					
					itemCollection.replaceItemValue(key.toString(), v);				
				} else // non convertable object!
					itemCollection.replaceItemValue(key.toString(), value);
				
			} catch (Exception e) {
				e.printStackTrace();
			}
			return value;
		}
	}
}