/*******************************************************************************
 *  Imixs IX Workflow Technology
 *  Copyright (C) 2001, 2008 Imixs Software Solutions GmbH,  
 *  http://www.imixs.com
 *  
 *  This program is free software; you can redistribute it and/or 
 *  modify it under the terms of the GNU General Public License 
 *  as published by the Free Software Foundation; either version 2 
 *  of the License, or (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 *  General Public License for more details.
 *  
 *  You can receive a copy of the GNU General Public
 *  License at http://www.gnu.org/licenses/gpl.html
 *  
 *  Contributors:  
 *  	Imixs Software Solutions GmbH - initial API and implementation
 *  	Ralph Soika
 *******************************************************************************/

package org.imixs.workflow.plugins;

import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Plugin;

/**
 * This Pluginmodul generates a result message. The Plugin checks if the activiy
 * document has an "txtActivityResult" attribute. The value will be parsed for
 * "<field>attribute</field>" tags and these tags will be replaced with the
 * values of the corresponding attributes of the workitem.
 * 
 * The final result will be stored into the attribute
 * "txtworkflowresultmessage".
 * 
 * This field could be used by an application to display individual messages
 * (e.g HTML Code) or return result Strings (e.g. JSF Action Results)
 * 
 * @author Ralph Soika
 * @version 1.0
 * @see org.imixs.workflow.WorkflowManager
 * 
 */
public class ResultPlugin extends AbstractPlugin {
	ItemCollection documentContext;
	String sActivityResult;

	public int run(ItemCollection adocumentContext,
			ItemCollection adocumentActivity) throws Exception {
		try {

			documentContext = adocumentContext;

			// get ResultMessage
			sActivityResult = adocumentActivity
					.getItemValueString("txtActivityResult");
			sActivityResult = replaceDynamicValues(sActivityResult,
					adocumentContext);

		} catch (Exception e) {
			System.out.println("[ResultPlugin] Error run(): " + e.toString());
			return Plugin.PLUGIN_ERROR;
		}

		return Plugin.PLUGIN_OK;
	}

	public void close(int status) {
		try {
			// restore changes?
			if (status < Plugin.PLUGIN_ERROR) {
				documentContext.replaceItemValue("txtworkflowresultmessage",
						sActivityResult);
			}
		} catch (Exception e) {
			System.out.println("[ResultPlugin] Error close(): " + e.toString());

		}
	}

}
