/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class ItemCollection
implements Serializable {
    private Hashtable hash = new Hashtable();

    public ItemCollection() {
    }

    public ItemCollection(Map map) throws Exception {
        for (Map.Entry entry : map.entrySet()) {
            this.replaceItemValue(entry.getKey().toString(), entry.getValue());
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemCollection)) {
            return false;
        }
        return this.hash.equals(((ItemCollection)o).getAllItems());
    }

    public Vector getItemValue(String aName) {
        Object o = this.hash.get(aName = aName.toLowerCase());
        if (o == null) {
            return new Vector();
        }
        Vector v = (Vector)o;
        for (int i = 0; i < v.size(); ++i) {
            if (v.get(i) != null) continue;
            v.remove(i);
        }
        return v;
    }

    public String getItemValueString(String aName) {
        try {
            aName = aName.toLowerCase();
            Vector v = this.getItemValue(aName);
            if (v.size() == 0) {
                return "";
            }
            Object o = v.firstElement();
            if (o == null) {
                return "";
            }
            return (String)o;
        }
        catch (ClassCastException e) {
            return "";
        }
    }

    public int getItemValueInteger(String aName) {
        try {
            aName = aName.toLowerCase();
            Vector v = this.getItemValue(aName);
            if (v.size() == 0) {
                return 0;
            }
            String sValue = v.firstElement().toString();
            return new Double(sValue).intValue();
        }
        catch (NumberFormatException e) {
            return 0;
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    public Date getItemValueDate(String aName) {
        try {
            aName = aName.toLowerCase();
            Vector v = this.getItemValue(aName);
            if (v.size() == 0) {
                return null;
            }
            Object o = v.firstElement();
            if (!(o instanceof Date)) {
                return null;
            }
            return (Date)o;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public double getItemValueDouble(String aName) {
        try {
            aName = aName.toLowerCase();
            Vector v = this.getItemValue(aName);
            if (v.size() == 0) {
                return 0.0;
            }
            return (Double)v.firstElement();
        }
        catch (ClassCastException e) {
            return 0.0;
        }
    }

    public boolean getItemValueBoolean(String aName) {
        try {
            aName = aName.toLowerCase();
            Vector v = this.getItemValue(aName);
            if (v.size() == 0) {
                return false;
            }
            String sValue = v.firstElement().toString();
            return new Boolean(sValue);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean hasItem(String aName) {
        return this.hash.get(aName = aName.toLowerCase()) != null;
    }

    public Map getAllItems() {
        return this.hash;
    }

    public void replaceItemValue(String aName, Object o) throws Exception {
        if (o == null || aName == null) {
            return;
        }
        if (!(o instanceof Serializable)) {
            throw new Exception("[ItemCollection] replaceItemValue() Object no Serializable!");
        }
        aName = aName.toLowerCase();
        if (!(o instanceof Vector)) {
            Vector<Object> v = new Vector<Object>();
            v.addElement(o);
            this.hash.put(aName, v);
        } else {
            Vector v = (Vector)o;
            for (int i = 0; i < v.size(); ++i) {
                if (v.get(i) != null) continue;
                v.remove(i);
            }
            this.hash.put(aName, v);
        }
    }

    public void replaceAllItems(Map map) throws Exception {
        for (Map.Entry entry : map.entrySet()) {
            this.replaceItemValue(entry.getKey().toString(), entry.getValue());
        }
    }

    public void removeItem(String name) {
        name = name.toLowerCase();
        this.getAllItems().remove(name);
    }
}

