/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow;

import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import org.imixs.workflow.ExtendedWorkflowContext;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;

public class WorkflowKernel {
    protected int iDebugLevel = -1;
    public static final int DEBUG_OFF = 0;
    public static final int DEBUG_ERRORS = 1;
    public static final int DEBUG_VERBOSE = 2;
    private Vector vectorPluginsClassNames = null;
    private Vector vectorPlugins = null;
    private WorkflowContext ctx = null;
    private ItemCollection documentContext = null;
    private ItemCollection documentActivity = null;
    private ItemCollection documentProcess = null;
    private Vector vectorEdgeHistory = new Vector();

    public WorkflowKernel(WorkflowContext actx) {
        this.ctx = actx;
        this.iDebugLevel = this.ctx.getDebugLevel();
        if (this.iDebugLevel > 0) {
            System.out.println("[imixs.org WorkflowKernel (V5.201105242320) }");
            if (this.iDebugLevel == 1) {
                System.out.println("[WorkflowKernel] DebugLevel=SHOW_ERRORS ");
            } else {
                System.out.println("[WorkflowKernel] DebugLevel=VERBOSE ");
            }
        }
        this.vectorPluginsClassNames = new Vector();
        this.vectorPlugins = new Vector();
    }

    public void registerPlugin(String aClassName) throws Exception {
        this.vectorPluginsClassNames.addElement(aClassName);
        if (this.iDebugLevel == 2) {
            System.out.println("[WorkflowKernel] register Plugin: " + aClassName);
        }
    }

    public void process(ItemCollection document) throws Exception {
        try {
            this.vectorEdgeHistory = new Vector();
            this.documentContext = document;
            if ("".equals(this.documentContext.getItemValueString("$UniqueID"))) {
                this.documentContext.replaceItemValue("$UniqueID", WorkflowKernel.generateUniqueID());
            }
            if ("".equals(this.documentContext.getItemValueString("$WorkItemID"))) {
                this.documentContext.replaceItemValue("$WorkItemID", WorkflowKernel.generateUniqueID());
            }
            while (this.hasMoreActivities()) {
                this.processActivity();
            }
        }
        catch (Exception e2) {
            System.out.println("[WorkflowKernel]  error process() ");
            System.out.println(e2.toString());
            String sLog = DateFormat.getDateTimeInstance(2, 2).format(new Date());
            sLog = sLog + "|" + this.documentContext.getItemValueInteger("$ProcessID") + "." + this.documentContext.getItemValueInteger("$ActivityID");
            this.documentContext.replaceItemValue("txtworkflowactivityerror", sLog);
            throw e2;
        }
        finally {
            this.documentContext.replaceItemValue("$activityid", new Integer(0));
            this.documentContext.replaceItemValue("$activityidlist", new Integer(0));
        }
    }

    private boolean hasMoreActivities() throws Exception {
        try {
            try {
                int integerID = this.documentContext.getItemValueInteger("$activityid");
                if (integerID > 0) {
                    return true;
                }
                throw new Exception("no $activityid found");
            }
            catch (Exception e) {
                Vector v = this.documentContext.getItemValue("$activityidlist");
                while (v.indexOf(new Integer(0)) > -1) {
                    v.remove(v.indexOf(new Integer(0)));
                }
                if (v != null && v.size() > 0) {
                    int iNextID = 0;
                    Object oA = v.firstElement();
                    if (oA instanceof Integer) {
                        iNextID = (Integer)oA;
                    }
                    if (oA instanceof Double) {
                        iNextID = ((Double)oA).intValue();
                    }
                    if (iNextID > 0) {
                        if (this.iDebugLevel == 2) {
                            System.out.println("[WorkflowKernel] loading next entry from $activityidlist=" + iNextID);
                        }
                        v.removeElementAt(0);
                        this.documentContext.replaceItemValue("$activityid", new Integer(iNextID));
                        this.documentContext.replaceItemValue("$activityidlist", v);
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception e2) {
            System.out.println("[WorkflowKernel]  error hasMoreActivities() ");
            System.out.println(e2.toString());
            throw e2;
        }
    }

    public static String generateUniqueID() {
        String sIDPart1 = Long.toHexString(System.currentTimeMillis());
        double d = Math.random() * 9.0E8;
        int i = new Double(d).intValue();
        String sIDPart2 = Integer.toHexString(i);
        String id = sIDPart1 + "-" + sIDPart2;
        return id;
    }

    private void processActivity() throws Exception {
        try {
            this.loadActivity();
            this.loadPlugins();
            int iStatus = this.runPlugins();
            this.closePlugins(iStatus);
            if (iStatus == 2) {
                throw new Exception("[WorkflowKernel] Error in Plugin detected.");
            }
            this.writeLog();
            this.vectorEdgeHistory.addElement(this.documentActivity.getItemValueInteger("numprocessid") + "." + this.documentActivity.getItemValueInteger("numactivityid"));
            int iNewProcessID = this.documentActivity.getItemValueInteger("numnextprocessid");
            if (this.iDebugLevel == 2) {
                System.out.println("[WorkflowKernel] new ProcessID=" + iNewProcessID + "");
            }
            String sModelVersion = this.documentContext.getItemValueString("$modelversion");
            this.documentProcess = this.ctx instanceof ExtendedWorkflowContext ? ((ExtendedWorkflowContext)this.ctx).getExtendedModel().getProcessEntityByVersion(iNewProcessID, sModelVersion) : this.ctx.getModel().getProcessEntity(iNewProcessID);
            if (iNewProcessID > 0) {
                this.documentContext.replaceItemValue("$processid", new Integer(iNewProcessID));
            }
            this.documentContext.replaceItemValue("$activityid", new Integer(0));
            if (this.iDebugLevel == 2) {
                System.out.println("[WorkflowKernel] set newProcessID: " + iNewProcessID + " sucessfull");
            }
            String sFollowUp = this.documentActivity.getItemValueString("keyFollowUp");
            int iNextActivityID = this.documentActivity.getItemValueInteger("numNextActivityID");
            if ("1".equals(sFollowUp) && iNextActivityID > 0) {
                this.appendActivityID(iNextActivityID);
            }
        }
        catch (Exception e2) {
            System.out.println("[WorkflowKernel]  error processActivity() ");
            System.out.println(e2.toString());
            throw e2;
        }
    }

    private void appendActivityID(int aID) {
        try {
            Vector<Integer> v = this.documentContext.getItemValue("$ActivityIDList");
            if (v == null) {
                v = new Vector<Integer>();
            }
            if (v.size() == 1 && "".equals(v.elementAt(0).toString())) {
                v = new Vector();
            }
            v.addElement(new Integer(aID));
            while (v.indexOf(new Integer(0)) > -1) {
                v.remove(v.indexOf(new Integer(0)));
            }
            this.documentContext.replaceItemValue("$ActivityIDList", v);
            if (this.iDebugLevel == 2) {
                System.out.println("[WorkflowKernel]  append new Activity ID=" + aID);
            }
        }
        catch (Exception e) {
            System.out.println("[WorkflowKernel] ERROR - appendActivityID : " + aID);
        }
    }

    private void writeLog() throws Exception {
        try {
            String sLog = DateFormat.getDateTimeInstance(2, 2).format(new Date());
            sLog = sLog + "|" + this.documentActivity.getItemValueInteger("numprocessid") + "." + this.documentActivity.getItemValueInteger("numactivityid") + ":=" + this.documentActivity.getItemValueInteger("numnextprocessid");
            Vector<String> vLog = this.documentContext.getItemValue("txtworkflowactivitylog");
            if (vLog == null) {
                vLog = new Vector<String>();
            }
            vLog.addElement(sLog);
            this.documentContext.replaceItemValue("txtworkflowactivitylog", vLog);
            this.documentContext.replaceItemValue("numlastactivityid", new Integer(this.documentActivity.getItemValueInteger("numactivityid")));
        }
        catch (Exception e) {
            System.out.println("[WorkflowKernel] Error writeLog() " + e.toString());
            throw e;
        }
    }

    private void loadActivity() throws Exception {
        try {
            int aProcessID = this.documentContext.getItemValueInteger("$processid");
            int aActivityID = this.documentContext.getItemValueInteger("$activityid");
            String sModelVersion = this.documentContext.getItemValueString("$modelversion");
            this.documentActivity = this.ctx instanceof ExtendedWorkflowContext ? ((ExtendedWorkflowContext)this.ctx).getExtendedModel().getActivityEntityByVersion(aProcessID, aActivityID, sModelVersion) : this.ctx.getModel().getActivityEntity(aProcessID, aActivityID);
            if (this.documentActivity == null) {
                throw new Exception("[WorkflowKernel] model entry " + aProcessID + "." + aActivityID + " not found");
            }
            if (this.iDebugLevel == 2) {
                System.out.println("[WorkflowKernel] loadActivity: " + aProcessID + "." + aActivityID + " successfully");
            }
            if (this.vectorEdgeHistory != null && this.vectorEdgeHistory.indexOf(aProcessID + "." + aActivityID) != -1) {
                throw new Exception("[WorkflowKernel] loop detected " + aProcessID + "." + aActivityID + "," + this.vectorEdgeHistory.toString());
            }
        }
        catch (Exception e) {
            System.out.println("[WorkflowKernel] Error loadActivity()");
            throw e;
        }
    }

    private void loadPlugins() throws Exception {
        try {
            if (this.vectorPluginsClassNames.size() == 0 && this.iDebugLevel >= 2) {
                System.out.println("[WorkflowKernel] Warning loadPlugins: no plugins defined!");
            }
            for (int i = 0; i < this.vectorPluginsClassNames.size(); ++i) {
                String sPluginClass = this.vectorPluginsClassNames.elementAt(i).toString();
                if (sPluginClass == null || "".equals(sPluginClass)) continue;
                if (this.iDebugLevel == 2) {
                    System.out.println("[WorkflowKernel] loading Plugin " + sPluginClass + "...");
                }
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(sPluginClass);
                    Plugin plugin = (Plugin)clazz.newInstance();
                    plugin.init(this.ctx);
                    this.vectorPlugins.add(plugin);
                    continue;
                }
                catch (Exception e) {
                    throw new Exception("[WorkflowKernel] Could not create Plugin: " + sPluginClass + " Reason: " + e.toString());
                }
            }
        }
        catch (Exception e) {
            System.out.println("[WorkflowKernel] Error loadPlugins()");
            throw e;
        }
    }

    private int runPlugins() throws Exception {
        try {
            Vector vectorPluginLog = this.documentContext.getItemValue("txtWorkflowPluginLog");
            for (int i = 0; i < this.vectorPlugins.size(); ++i) {
                Plugin plugin = (Plugin)this.vectorPlugins.elementAt(i);
                if (this.iDebugLevel == 2) {
                    System.out.println("[WorkflowKernel] running Plugin: " + plugin.getClass().getName() + "...");
                }
                int iStatus = plugin.run(this.documentContext, this.documentActivity);
                String sLog = DateFormat.getDateTimeInstance(1, 2).format(new Date());
                vectorPluginLog.addElement(sLog + " " + plugin.getClass().getName() + "=" + iStatus);
                if (iStatus != 2) continue;
                this.documentContext.replaceItemValue("txtWorkflowPluginLog", vectorPluginLog);
                return 2;
            }
            this.documentContext.replaceItemValue("txtWorkflowPluginLog", vectorPluginLog);
            return 0;
        }
        catch (Exception e) {
            System.out.println("[WorkflowKernel] Error runPlugins()");
            throw e;
        }
    }

    private void closePlugins(int astatus) throws Exception {
        try {
            for (int i = 0; i < this.vectorPlugins.size(); ++i) {
                Plugin plugin = (Plugin)this.vectorPlugins.elementAt(i);
                if (this.iDebugLevel == 2) {
                    System.out.println("[WorkflowKernel] closing Plugin: " + plugin.getClass().getName() + "...");
                }
                plugin.close(astatus);
            }
            this.vectorPlugins = new Vector();
        }
        catch (Exception e) {
            System.out.println("[WorkflowKernel] Error closePlugins()");
            throw e;
        }
    }
}

