/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;

public abstract class AbstractPlugin
implements Plugin {
    public WorkflowContext ctx;

    public void init(WorkflowContext actx) throws Exception {
        this.ctx = actx;
    }

    public String replaceDynamicValues(String aString, ItemCollection documentContext) throws Exception {
        if (aString == null) {
            return "";
        }
        try {
            int iStartPos;
            while ((iStartPos = aString.toLowerCase().indexOf("<FIELD>".toLowerCase())) != -1) {
                int iEndPos = aString.toLowerCase().indexOf("</FIELD>".toLowerCase(), iStartPos);
                if (iEndPos == -1) {
                    return aString;
                }
                String sFieldName = aString.substring(iStartPos + "<FIELD>".toLowerCase().length(), iEndPos);
                String sFormat = null;
                if (sFieldName.indexOf("[") > -1 && sFieldName.indexOf("]") > -1) {
                    sFormat = sFieldName.substring(sFieldName.indexOf("[") + 1, sFieldName.indexOf("]"));
                    sFieldName = sFieldName.substring(0, sFieldName.indexOf("["));
                }
                String sFeldWert = this.formatItemValues(sFieldName, documentContext.getItemValue(sFieldName), ", ", sFormat);
                aString = aString.substring(0, iStartPos) + sFeldWert + aString.substring(iEndPos + "</FIELD>".toLowerCase().length());
            }
            return aString;
        }
        catch (Exception e) {
            System.out.println("[AbstractPlugin] Error: replaceDynamicValues() " + e.toString());
            throw e;
        }
    }

    public String formatItemValues(String sFeldname, Object aItem, String sDelimeter, String sFormat) throws Exception {
        String sString = "";
        if (aItem == null) {
            return "";
        }
        if (aItem instanceof Collection) {
            Collection col = (Collection)aItem;
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                String aValue = this.formatObjectValue(o, sFormat);
                if (sFeldname.toLowerCase().startsWith("nam")) {
                    aValue = AbstractPlugin.getAbbreviateName(aValue);
                }
                sString = sString + aValue;
                if (!it.hasNext()) continue;
                sString = sString + sDelimeter;
            }
            return sString;
        }
        sString = this.formatObjectValue(aItem, sFormat);
        if (sFeldname.toLowerCase().startsWith("nam")) {
            sString = AbstractPlugin.getAbbreviateName(sString);
        }
        return sString;
    }

    private String formatObjectValue(Object o, String format) {
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            String singleValue = "";
            if (format != null) {
                SimpleDateFormat formatter = new SimpleDateFormat(format);
                singleValue = formatter.format(dateValue);
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
            return singleValue;
        }
        return o.toString();
    }

    public static String getCommonName(String aName) {
        if (aName == null || "".equals(aName) || aName.indexOf("=") == -1) {
            return aName;
        }
        try {
            String sResult = aName.substring(aName.indexOf("=") + 1);
            int iPos = sResult.indexOf("/");
            if (iPos > -1) {
                return sResult.substring(0, iPos);
            }
            return sResult;
        }
        catch (Exception exception) {
            return aName;
        }
    }

    public static String getAbbreviateName(String aName) {
        if (aName == null || "".equals(aName) || aName.indexOf("=") == -1) {
            return aName;
        }
        try {
            String sResult = aName.substring(aName.indexOf("=") + 1);
            while (sResult.indexOf("=") > -1) {
                int iPos1 = sResult.indexOf("/");
                int iPos2 = sResult.indexOf("=");
                sResult = sResult.substring(0, iPos1 + 1) + sResult.substring(iPos2 + 1);
            }
            return sResult;
        }
        catch (Exception exception) {
            return aName;
        }
    }
}

