/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.imixs.workflow.ItemCollection;

public class ItemCollectionAdapter {
    ItemCollection itemCollection;
    ItemAdapter itemAdapter;
    ItemListAdapter itemListAdapter;
    ItemListArrayAdapter itemListArrayAdapter;

    public ItemCollectionAdapter() {
        this.itemCollection = new ItemCollection();
        this.itemAdapter = new ItemAdapter(this.itemCollection);
        this.itemListAdapter = new ItemListAdapter(this.itemCollection);
        this.itemListArrayAdapter = new ItemListArrayAdapter(this.itemCollection);
    }

    public ItemCollectionAdapter(ItemCollection acol) {
        this.itemCollection = acol;
        this.itemAdapter = new ItemAdapter(this.itemCollection);
        this.itemListAdapter = new ItemListAdapter(this.itemCollection);
        this.itemListArrayAdapter = new ItemListArrayAdapter(this.itemCollection);
    }

    public ItemCollection getItemCollection() {
        return this.itemCollection;
    }

    public void setItemCollection(ItemCollection acol) {
        this.itemCollection = acol;
        this.itemAdapter.setItemCollection(this.itemCollection);
        this.itemListAdapter.setItemCollection(this.itemCollection);
        this.itemListArrayAdapter.setItemCollection(this.itemCollection);
    }

    public void addFile(byte[] data, String fileName, String contentType) throws Exception {
        if (data != null) {
            Vector<Object> vectorFileInfo = null;
            if (fileName.indexOf(92) > -1) {
                fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
            }
            if (fileName.indexOf(47) > -1) {
                fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
            }
            if (contentType == null || "".equals(contentType)) {
                contentType = "application/unknown";
            }
            HashMap mapFiles = null;
            Vector vFiles = this.getItemCollection().getItemValue("$file");
            mapFiles = vFiles != null && vFiles.size() > 0 ? (HashMap)vFiles.elementAt(0) : new HashMap();
            vectorFileInfo = (Vector<Object>)mapFiles.get(fileName);
            vectorFileInfo = new Vector<Object>();
            vectorFileInfo.add(contentType);
            vectorFileInfo.add(data);
            mapFiles.put(fileName, vectorFileInfo);
            this.getItemCollection().replaceItemValue("$file", mapFiles);
        }
    }

    public void removeFile(String aFilename) throws Exception {
        if (this.getItemCollection() != null) {
            String[] files = new String[]{};
            HashMap mapFiles = null;
            try {
                Vector vFiles = this.getItemCollection().getItemValue("$file");
                if (vFiles != null && vFiles.size() > 0) {
                    mapFiles = (HashMap)vFiles.elementAt(0);
                    mapFiles.remove(aFilename);
                    this.getItemCollection().replaceItemValue("$file", mapFiles);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String[] getFiles() {
        String[] files = new String[]{};
        if (this.getItemCollection() != null) {
            HashMap mapFiles = null;
            Vector vFiles = this.getItemCollection().getItemValue("$file");
            if (vFiles != null && vFiles.size() > 0) {
                mapFiles = (HashMap)vFiles.elementAt(0);
                files = new String[mapFiles.entrySet().size()];
                Iterator iter = mapFiles.entrySet().iterator();
                int iFileCount = 0;
                while (iter.hasNext()) {
                    String aFileName;
                    Map.Entry mapEntry = iter.next();
                    files[iFileCount] = aFileName = mapEntry.getKey().toString();
                    ++iFileCount;
                }
            }
        }
        return files;
    }

    public Map getItem() {
        return this.itemAdapter;
    }

    public Map getItemList() {
        return this.itemListAdapter;
    }

    public Map getItemListArray() {
        return this.itemListArrayAdapter;
    }

    class ItemListArrayAdapter
    extends ItemAdapter {
        public ItemListArrayAdapter(ItemCollection acol) {
            this.itemCollection = acol;
        }

        public Object get(Object key) {
            try {
                if (!this.itemCollection.hasItem(key.toString())) {
                    this.itemCollection.replaceItemValue(key.toString(), "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList aList = new ArrayList();
            Vector col = this.itemCollection.getItemValue(key.toString());
            for (Object aEntryValue : col) {
                aList.add(aEntryValue);
            }
            return aList;
        }

        public Object put(Object key, Object value) {
            block10: {
                if (key == null) {
                    return null;
                }
                try {
                    if (value == null) {
                        this.itemCollection.replaceItemValue(key.toString(), new Vector());
                        return null;
                    }
                    if (value instanceof List || value instanceof Object[]) {
                        Vector<Object> v = new Vector<Object>();
                        if (value instanceof List) {
                            for (Object aEntryValue : (List)value) {
                                v.add(aEntryValue);
                            }
                        } else if (value instanceof Object[]) {
                            for (Object aEntryValue : (Object[])value) {
                                v.add(aEntryValue);
                            }
                        }
                        this.itemCollection.replaceItemValue(key.toString(), v);
                        break block10;
                    }
                    this.itemCollection.replaceItemValue(key.toString(), value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return value;
        }
    }

    class ItemListAdapter
    extends ItemAdapter {
        public ItemListAdapter(ItemCollection acol) {
            this.itemCollection = acol;
        }

        public Object get(Object key) {
            try {
                if (!this.itemCollection.hasItem(key.toString())) {
                    this.itemCollection.replaceItemValue(key.toString(), "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.itemCollection.getItemValue(key.toString());
        }
    }

    class ItemAdapter
    implements Map {
        ItemCollection itemCollection;

        public ItemAdapter() {
            this.itemCollection = new ItemCollection();
        }

        public ItemAdapter(ItemCollection acol) {
            this.itemCollection = acol;
        }

        public void setItemCollection(ItemCollection acol) {
            this.itemCollection = acol;
        }

        public Object get(Object key) {
            try {
                if (!this.itemCollection.hasItem(key.toString())) {
                    this.itemCollection.replaceItemValue(key.toString(), "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Vector v = this.itemCollection.getItemValue(key.toString());
            if (v.size() > 0) {
                return v.firstElement();
            }
            return null;
        }

        public Object put(Object key, Object value) {
            try {
                if (key == null) {
                    return null;
                }
                this.itemCollection.replaceItemValue(key.toString(), value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return value;
        }

        public void clear() {
            this.itemCollection.getAllItems().clear();
        }

        public boolean containsKey(Object key) {
            return this.itemCollection.getAllItems().containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.itemCollection.getAllItems().containsValue(value);
        }

        public Set entrySet() {
            return this.itemCollection.getAllItems().entrySet();
        }

        public boolean isEmpty() {
            return this.itemCollection.getAllItems().isEmpty();
        }

        public Set keySet() {
            return this.itemCollection.getAllItems().keySet();
        }

        public void putAll(Map m) {
            this.itemCollection.getAllItems().putAll(m);
        }

        public Object remove(Object key) {
            return this.itemCollection.getAllItems().remove(key);
        }

        public int size() {
            return this.itemCollection.getAllItems().size();
        }

        public Collection values() {
            return this.itemCollection.getAllItems().values();
        }
    }
}

