/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.util.Enumeration;
import java.util.Vector;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowContext;

public class OwnerPlugin
implements Plugin {
    ItemCollection documentContext;
    ItemCollection documentActivity;
    Vector itemOwnerRollback;
    WorkflowContext workflowContext;

    public void init(WorkflowContext actx) throws Exception {
        this.workflowContext = actx;
    }

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws Exception {
        try {
            this.documentContext = adocumentContext;
            this.documentActivity = adocumentActivity;
            this.validate();
            Vector itemOwner = this.documentContext.getItemValue("namowner");
            this.itemOwnerRollback = this.documentContext.getItemValue("namOwners");
            Vector vectorAccess = "1".equals(this.documentActivity.getItemValueString("keyOwnershipMode")) ? itemOwner : new Vector();
            if (this.workflowContext.getDebugLevel() == 2) {
                System.out.println("[OwnerPlugin] AccessMode: '" + this.documentActivity.getItemValueString("keyOwnershipMode") + "'");
            }
            if (vectorAccess == null) {
                vectorAccess = new Vector();
            }
            this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("namOwnershipNames"));
            this.mergeMappedFieldValues(vectorAccess, this.documentActivity.getItemValue("keyOwnershipFields"));
            vectorAccess = this.uniqueVector(vectorAccess);
            this.documentContext.replaceItemValue("namOwner", (Object)vectorAccess);
            if (this.workflowContext.getDebugLevel() == 2 && vectorAccess.size() > 0) {
                System.out.println("[OwnerPlugin] Owner:");
                for (int j = 0; j < vectorAccess.size(); ++j) {
                    System.out.println("              " + (String)vectorAccess.elementAt(j));
                }
            }
        }
        catch (Exception e) {
            System.out.println("[AccessPlugin] Error run()" + e.toString());
            return 2;
        }
        return 0;
    }

    public void close(int status) throws Exception {
        try {
            if (status == 2) {
                this.documentContext.replaceItemValue("namOwner", (Object)this.itemOwnerRollback);
            }
        }
        catch (Exception e) {
            System.out.println("[AccessPlugin] Error close() " + e.toString());
            throw e;
        }
    }

    private void mergeVectors(Vector p_VectorDestination, Vector p_VectorSource) {
        if (p_VectorSource != null && p_VectorSource.size() > 0) {
            Enumeration enumSource = p_VectorSource.elements();
            while (enumSource.hasMoreElements()) {
                Object o = enumSource.nextElement();
                if (p_VectorDestination.indexOf(o) != -1) continue;
                p_VectorDestination.addElement(o);
            }
        }
    }

    private void mergeMappedFieldValues(Vector p_VectorDestination, Vector p_VectorFieldList) {
        try {
            if (p_VectorFieldList != null && p_VectorFieldList.size() > 0) {
                Enumeration enumFields = p_VectorFieldList.elements();
                while (enumFields.hasMoreElements()) {
                    String sFeldName = (String)enumFields.nextElement();
                    Vector vValues = this.documentContext.getItemValue(sFeldName);
                    if (vValues == null || vValues.size() <= 0) continue;
                    Enumeration enumValues = vValues.elements();
                    while (enumValues.hasMoreElements()) {
                        Object o = enumValues.nextElement();
                        if (p_VectorDestination.indexOf(o) != -1) continue;
                        p_VectorDestination.addElement(o);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("[AccessPlugin] Error addMappedFieldValuesToVector() " + e.toString());
        }
    }

    private void validate() throws Exception {
        try {
            if (!this.documentActivity.hasItem("keyOwnershipMode")) {
                this.documentActivity.replaceItemValue("keyOwnershipMode", (Object)"");
            }
            if (!this.documentActivity.hasItem("namOwnershipNames")) {
                this.documentActivity.replaceItemValue("namOwnershipNames", (Object)"");
            }
            if (!this.documentActivity.hasItem("keyOwnershipFields")) {
                this.documentActivity.replaceItemValue("keyOwnershipFields", (Object)"");
            }
            if (!this.documentContext.hasItem("namOwner")) {
                this.documentContext.replaceItemValue("namOwner", (Object)"");
            }
        }
        catch (Exception e) {
            System.out.println("[OwnerPlugin] Error validate()() " + e.toString());
            throw e;
        }
    }

    private Vector uniqueVector(Vector p_Vector) {
        int iVectorSize = p_Vector.size();
        Vector cleanedVector = new Vector();
        for (int i = 0; i < iVectorSize; ++i) {
            Object o = p_Vector.elementAt(i);
            if (o == null || cleanedVector.indexOf(o) > -1 || "".equals(o.toString())) continue;
            cleanedVector.add(o);
        }
        p_Vector = cleanedVector;
        if (p_Vector.size() == 0) {
            p_Vector.addElement("");
        }
        return p_Vector;
    }
}

