/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins.jee;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.plugins.jee.AbstractPlugin;

public class MailPlugin
extends AbstractPlugin {
    int idebugmode;
    public ItemCollection adocumentContext;
    Session mailSession;
    MimeMessage mailMessage = null;
    Multipart mimeMultipart = null;
    @Resource(name="IX_MAIL_SESSION")
    private String sIXMailSession = "org.imixs.workflow.jee.mailsession";

    private boolean debugMode() throws Exception {
        return this.idebugmode > 0;
    }

    @Override
    public void init(WorkflowContext actx) throws Exception {
        super.init(actx);
        this.idebugmode = actx.getDebugLevel();
        InitialContext ic = new InitialContext();
        String snName = "";
        snName = "java:comp/env/mail/" + this.sIXMailSession;
        this.mailSession = (Session)ic.lookup(snName);
    }

    @Override
    public int run(ItemCollection documentContext, ItemCollection documentActivity) throws Exception {
        String sReplyTo = "";
        this.adocumentContext = documentContext;
        try {
            if (this.debugMode()) {
                System.out.println("[MailPlugin] JEE V08.0714 ...");
            }
            this.mailMessage = null;
            if ("1".equals(documentActivity.getItemValueString("keyMailInactive"))) {
                return 0;
            }
            String snamMailReceifer = documentActivity.getItemValueString("namMailReceiver");
            String skeyMailReceiverFields = documentActivity.getItemValueString("keyMailReceiverFields");
            Object inetAddr = null;
            if (snamMailReceifer != null && !"".equals(documentActivity.getItemValueString("namMailReceiver")) || skeyMailReceiverFields != null && !"".equals(documentActivity.getItemValueString("keyMailReceiverFields"))) {
                Vector vectorRecipients;
                String sFrom = this.getUserName();
                if (sFrom == null || "".equals(sFrom)) {
                    return 0;
                }
                this.initializeMailMessage();
                sReplyTo = "1".equals(documentActivity.getItemValueString("keyMailReplyToCurrentUser")) ? this.getUserName() : documentActivity.getItemValueString("namMailReplyToUser");
                this.mailMessage.setFrom((Address)this.getInternetAddress(sFrom));
                if (sReplyTo != null && !"".equals(sReplyTo)) {
                    InternetAddress[] resplysAdrs = new InternetAddress[]{this.getInternetAddress(sReplyTo)};
                    this.mailMessage.setReplyTo((Address[])resplysAdrs);
                }
                if ((vectorRecipients = documentActivity.getItemValue("namMailReceiver")) == null) {
                    vectorRecipients = new Vector();
                }
                this.mergeMappedFieldValues(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFields"));
                if (vectorRecipients.size() == 0) {
                    this.mailMessage = null;
                    return 0;
                }
                InternetAddress[] recipientsTo = this.getInternetAddressArray(vectorRecipients);
                this.mailMessage.setRecipients(Message.RecipientType.TO, (Address[])recipientsTo);
                vectorRecipients = documentActivity.getItemValue("namMailReceiverCC");
                if (vectorRecipients == null) {
                    vectorRecipients = new Vector();
                }
                this.mergeMappedFieldValues(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFieldsCC"));
                InternetAddress[] recipientsCC = this.getInternetAddressArray(vectorRecipients);
                this.mailMessage.setRecipients(Message.RecipientType.CC, (Address[])recipientsCC);
                this.mailMessage.setSubject(this.replaceDynamicValues(documentActivity.getItemValueString("txtMailSubject"), documentContext));
                String aBodyText = documentActivity.getItemValueString("rtfMailBody");
                if (aBodyText != null) {
                    aBodyText = this.replaceDynamicValues(aBodyText, documentContext);
                    MimeBodyPart messagePart = new MimeBodyPart();
                    messagePart.setText(aBodyText);
                    this.mimeMultipart.addBodyPart((BodyPart)messagePart);
                }
                if (recipientsTo.length > 0 && this.debugMode()) {
                    int j;
                    System.out.println("[MailPlugin] New Mail prepered for sending...");
                    System.out.println("[MailPlugin] Type: PlainText");
                    System.out.println("[MailPlugin] From: " + sFrom);
                    System.out.println("[MailPlugin] SendTo (" + recipientsTo.length + " Receipients):");
                    for (j = 0; j < recipientsTo.length; ++j) {
                        System.out.println("[MailPlugin]     " + recipientsTo[j].getAddress());
                    }
                    System.out.println("[MailPlugin] CopyTo (" + recipientsCC.length + " Receipients):");
                    for (j = 0; j < recipientsCC.length; ++j) {
                        System.out.println("[MailPlugin]     " + recipientsCC[j].getAddress());
                    }
                }
            } else if (this.debugMode()) {
                System.out.println("[MailPlugin] No Receipients defined for this Activity...");
            }
        }
        catch (Exception e) {
            System.out.println("[MailPlugin] Warning run():" + e.toString());
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    @Override
    public void close(int status) throws Exception {
        if (status == 0 && this.mailSession != null && this.mailMessage != null) {
            try {
                if (this.debugMode()) {
                    System.out.println("[MailPlugin] SendMessage now...");
                }
                Transport trans = this.mailSession.getTransport("smtp");
                trans.connect(this.mailSession.getProperty("mail.smtp.user"), this.mailSession.getProperty("mail.smtp.password"));
                this.mailMessage.setContent(this.mimeMultipart);
                this.mailMessage.saveChanges();
                trans.sendMessage((Message)this.mailMessage, this.mailMessage.getAllRecipients());
                trans.close();
            }
            catch (Exception esend) {
                esend.printStackTrace();
            }
        }
    }

    public void initializeMailMessage() throws AddressException, MessagingException {
        this.mailMessage = new MimeMessage(this.mailSession);
        this.mailMessage.setSentDate(new Date());
        this.mailMessage.setFrom();
        this.mimeMultipart = new MimeMultipart();
    }

    private void mergeMappedFieldValues(ItemCollection documentContext, Vector p_VectorDestination, Vector p_VectorFieldList) {
        try {
            if (p_VectorFieldList != null && p_VectorFieldList.size() > 0) {
                Enumeration enumFields = p_VectorFieldList.elements();
                while (enumFields.hasMoreElements()) {
                    String sFeldName = (String)enumFields.nextElement();
                    Vector vValues = documentContext.getItemValue(sFeldName);
                    if (vValues == null || vValues.size() <= 0) continue;
                    Enumeration enumValues = vValues.elements();
                    while (enumValues.hasMoreElements()) {
                        Object o = enumValues.nextElement();
                        if (p_VectorDestination.indexOf(o) != -1) continue;
                        p_VectorDestination.addElement(o);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("[MailPlugin] mergeMappedFieldValues Error :" + e.toString());
            e.printStackTrace();
        }
    }

    public InternetAddress getInternetAddress(String aAddr) throws AddressException {
        InternetAddress inetAddr = null;
        try {
            inetAddr = aAddr.indexOf(" ") > -1 ? new InternetAddress("\"" + aAddr + "\"") : new InternetAddress(aAddr);
        }
        catch (AddressException ae) {
            ae.printStackTrace();
            return null;
        }
        return inetAddr;
    }

    private InternetAddress[] getInternetAddressArray(Vector aList) {
        InternetAddress inetAddr = null;
        Vector<InternetAddress> vReceipsTemp = new Vector<InternetAddress>();
        for (int i = 0; i < aList.size(); ++i) {
            try {
                inetAddr = this.getInternetAddress(aList.elementAt(i).toString());
                if (inetAddr == null || "".equals(inetAddr.getAddress())) continue;
                vReceipsTemp.add(inetAddr);
                continue;
            }
            catch (AddressException e) {
                // empty catch block
            }
        }
        InternetAddress[] receipsAdrs = new InternetAddress[vReceipsTemp.size()];
        for (int i = 0; i < vReceipsTemp.size(); ++i) {
            receipsAdrs[i] = (InternetAddress)vReceipsTemp.elementAt(i);
        }
        return receipsAdrs;
    }

    public Session getMailSession() {
        return this.mailSession;
    }

    public Message getMailMessage() {
        return this.mailMessage;
    }

    public Multipart getMultipart() {
        return this.mimeMultipart;
    }
}

