/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.jee.ejb.EntityServiceRemote;
import org.imixs.workflow.jee.jpa.CalendarItem;
import org.imixs.workflow.jee.jpa.DoubleItem;
import org.imixs.workflow.jee.jpa.Entity;
import org.imixs.workflow.jee.jpa.EntityIndex;
import org.imixs.workflow.jee.jpa.IntegerItem;
import org.imixs.workflow.jee.jpa.ReadAccess;
import org.imixs.workflow.jee.jpa.TextItem;
import org.imixs.workflow.jee.jpa.WriteAccess;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class EntityService
implements EntityServiceRemote {
    public static final int TYP_TEXT = 0;
    public static final int TYP_INT = 1;
    public static final int TYP_DOUBLE = 2;
    public static final int TYP_CALENDAR = 3;
    public static final String ACCESSLEVEL_NOACCESS = "org.imixs.ACCESSLEVEL.NOACCESS";
    public static final String ACCESSLEVEL_READERACCESS = "org.imixs.ACCESSLEVEL.READERACCESS";
    public static final String ACCESSLEVEL_AUTHORACCESS = "org.imixs.ACCESSLEVEL.AUTHORACCESS";
    public static final String ACCESSLEVEL_EDITORACCESS = "org.imixs.ACCESSLEVEL.EDITORACCESS";
    public static final String ACCESSLEVEL_MANAGERACCESS = "org.imixs.ACCESSLEVEL.MANAGERACCESS";
    public static final String UNIQUEID = "$uniqueid";
    public static final String USER_GROUP_LIST = "org.imixs.USER.GROUPLIST";
    private static Logger logger = Logger.getLogger("org.imixs.workflow");
    @Resource
    SessionContext ctx;
    @Resource(name="READ_ACCESS_FIELDS")
    private String readAccessFields = "";
    @Resource(name="WRITE_ACCESS_FIELDS")
    private String writeAccessFields = "";
    @Resource(name="ACCESS_ROLES")
    private String accessRoles = "";
    @PersistenceContext(unitName="org.imixs.workflow.jee.jpa")
    private EntityManager manager;

    public List<String> getUserNameList() {
        Vector<String> userNameList = new Vector<String>();
        userNameList.add(this.ctx.getCallerPrincipal().getName().toString());
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS," + this.accessRoles;
        StringTokenizer roleListTokens = new StringTokenizer(roleList, ",");
        while (roleListTokens.hasMoreTokens()) {
            try {
                String testRole = roleListTokens.nextToken().trim();
                if ("".equals(testRole) || !this.ctx.isCallerInRole(testRole)) continue;
                userNameList.add(testRole);
            }
            catch (Exception e) {}
        }
        String[] applicationGroups = this.getUserGroupList();
        if (applicationGroups != null) {
            for (String auserRole : applicationGroups) {
                userNameList.add(auserRole);
            }
        }
        return userNameList;
    }

    @Override
    public String getAccessRoles() {
        return this.accessRoles;
    }

    @Override
    public String getReadAccessFields() {
        return this.readAccessFields;
    }

    @Override
    public String getWriteAccessFields() {
        return this.writeAccessFields;
    }

    @Override
    public ItemCollection save(ItemCollection itemcol) throws AccessDeniedException {
        Calendar cal;
        Entity activeEntity = null;
        ItemCollection slimItemCollection = null;
        Collection<EntityIndex> entityIndexCache = this.getIndices();
        this.manager.setFlushMode(FlushModeType.COMMIT);
        String sID = itemcol.getItemValueString(UNIQUEID);
        if (!"".equals(sID) && (activeEntity = (Entity)this.manager.find(Entity.class, (Object)sID)) == null) {
            logger.fine("[EntityService] Entity '" + sID + "' not found!");
        }
        if (activeEntity == null) {
            if (!(this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_EDITORACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_AUTHORACCESS))) {
                throw new AccessDeniedException("[EntityService] You are not allowed to perform this operation");
            }
            activeEntity = new Entity(sID);
            Date datCreated = itemcol.getItemValueDate("$Created");
            if (datCreated != null) {
                cal = Calendar.getInstance();
                cal.setTime(datCreated);
                activeEntity.setCreated(cal);
            }
            this.manager.persist((Object)activeEntity);
        } else if (!this.isCallerAuthor(activeEntity) || !this.isCallerReader(activeEntity)) {
            throw new AccessDeniedException("[EntityService] You are not allowed to perform this operation");
        }
        itemcol.removeItem("$isauthor");
        String aType = itemcol.getItemValueString("type");
        if ("".equals(aType)) {
            aType = "Entity";
        }
        activeEntity.setType(aType);
        cal = Calendar.getInstance();
        itemcol.replaceItemValue(UNIQUEID, (Object)activeEntity.getId());
        itemcol.replaceItemValue("$modified", (Object)cal.getTime());
        itemcol.replaceItemValue("$created", (Object)activeEntity.getCreated().getTime());
        slimItemCollection = new ItemCollection(itemcol.getAllItems());
        this.updateReadAccessList(slimItemCollection, activeEntity);
        this.updateWriteAccessList(slimItemCollection, activeEntity);
        this.explodeEntity(slimItemCollection, activeEntity, entityIndexCache);
        activeEntity.setData(slimItemCollection.getAllItems());
        itemcol.replaceItemValue("$isauthor", (Object)this.isCallerAuthor(activeEntity));
        return itemcol;
    }

    @Override
    public ItemCollection load(String id) {
        Entity activeEntity = null;
        activeEntity = (Entity)this.manager.find(Entity.class, (Object)id);
        if (activeEntity != null && this.isCallerReader(activeEntity)) {
            return this.implodeEntity(activeEntity);
        }
        return null;
    }

    @Override
    public void remove(ItemCollection itemcol) throws AccessDeniedException {
        Entity activeEntity = null;
        String sID = itemcol.getItemValueString(UNIQUEID);
        activeEntity = (Entity)this.manager.find(Entity.class, (Object)sID);
        if (activeEntity != null) {
            if (!this.isCallerReader(activeEntity) || !this.isCallerAuthor(activeEntity)) {
                throw new AccessDeniedException("[EntityService] You are not allowed to perform this operation");
            }
            for (TextItem textItem : activeEntity.getTextItems()) {
                this.manager.remove((Object)textItem);
            }
            activeEntity.getTextItems().clear();
            for (CalendarItem calendarItem : activeEntity.getCalendarItems()) {
                this.manager.remove((Object)calendarItem);
            }
            activeEntity.getCalendarItems().clear();
            for (IntegerItem integerItem : activeEntity.getIntegerItems()) {
                this.manager.remove((Object)integerItem);
            }
            activeEntity.getIntegerItems().clear();
            for (DoubleItem doubleItem : activeEntity.getDoubleItems()) {
                this.manager.remove((Object)doubleItem);
            }
            activeEntity.getDoubleItems().clear();
            for (WriteAccess writeAccess : activeEntity.getWriteAccessList()) {
                this.manager.remove((Object)writeAccess);
            }
            activeEntity.getWriteAccessList().clear();
            for (ReadAccess readAccess : activeEntity.getReadAccessList()) {
                this.manager.remove((Object)readAccess);
            }
        } else {
            throw new AccessDeniedException("[EntityService] invalid $uniqueid");
        }
        activeEntity.getReadAccessList().clear();
        this.manager.remove((Object)activeEntity);
    }

    @Override
    public void addIndex(String stitel, int ityp) throws AccessDeniedException {
        EntityIndex activeEntityIndex = (EntityIndex)this.manager.find(EntityIndex.class, (Object)(stitel = stitel.toLowerCase()));
        if (activeEntityIndex != null) {
            return;
        }
        if (!this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            throw new AccessDeniedException("[EntityService] You are not allowed to add index fields");
        }
        logger.info("[EntityServiceBean] add new Index: " + stitel + ":" + ityp);
        activeEntityIndex = new EntityIndex(stitel, ityp);
        this.manager.persist((Object)activeEntityIndex);
        List entityList = null;
        Query q = this.manager.createQuery("SELECT entity FROM Entity entity");
        entityList = q.getResultList();
        logger.info("[EntityServiceBean] found " + entityList.size() + " existing entities. Starting update...");
        this.updateAllEntityIndexFields(entityList, stitel);
        logger.info("[EntityServiceBean] index update completed");
    }

    @Override
    public void removeIndex(String stitel) throws AccessDeniedException {
        int indexType = 0;
        EntityIndex activeEntityIndex = (EntityIndex)this.manager.find(EntityIndex.class, (Object)(stitel = stitel.toLowerCase()));
        if (activeEntityIndex == null) {
            return;
        }
        if (!this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            throw new AccessDeniedException("[EntityService] You are not allowed to add index fields");
        }
        indexType = activeEntityIndex.getTyp();
        logger.info("[EntityService] remove Index: " + stitel + ":" + indexType);
        this.manager.remove((Object)activeEntityIndex);
        List entityList = null;
        String query = "SELECT wi FROM Entity wi ";
        switch (indexType) {
            case 3: {
                query = query + " JOIN wi.calendarItems AS i1 WHERE i1.itemName='" + stitel + "'";
                break;
            }
            case 2: {
                query = query + " JOIN wi.doubleItems AS i1 WHERE i1.itemName='" + stitel + "'";
                break;
            }
            case 1: {
                query = query + " JOIN wi.integerItems AS i1 WHERE i1.itemName='" + stitel + "'";
                break;
            }
            default: {
                query = query + " JOIN wi.textItems AS i1 WHERE i1.itemName='" + stitel + "'";
            }
        }
        logger.info("[EntityServiceBean] remove Index - update query=" + query);
        Query q = this.manager.createQuery(query);
        entityList = q.getResultList();
        logger.info("[EntityServiceBean] found " + entityList.size() + " affected entities. Starting update...");
        this.updateAllEntityIndexFields(entityList, null);
        logger.info("[EntityServiceBean] index update completed");
    }

    public Collection<EntityIndex> getIndices() {
        logger.finer("getIndiecies....");
        Query q = this.manager.createQuery("SELECT entityindex FROM EntityIndex entityindex");
        return q.getResultList();
    }

    @Override
    public Collection<ItemCollection> findAllEntities(String query, int startpos, int count) throws InvalidAccessException {
        Vector<ItemCollection> vectorResult = new Vector<ItemCollection>();
        query = this.optimizeQuery(query);
        try {
            List entityList;
            Query q = this.manager.createQuery(query);
            if (startpos >= 0) {
                q.setFirstResult(startpos);
            }
            if (count > 0) {
                q.setMaxResults(count);
            }
            if ((entityList = q.getResultList()) == null) {
                return vectorResult;
            }
            for (Entity aEntity : entityList) {
                vectorResult.add(this.implodeEntity(aEntity));
            }
        }
        catch (RuntimeException nre) {
            throw new InvalidAccessException("[EntityService] Error findAllEntities: '" + query + "' ", (Exception)nre);
        }
        return vectorResult;
    }

    @Override
    public ItemCollection findParentEntity(ItemCollection child) throws InvalidAccessException {
        String parentUniqueID = child.getItemValueString("$uniqueidref");
        return this.load(parentUniqueID);
    }

    @Override
    public Collection<ItemCollection> findChildEntities(ItemCollection child, int start, int count) throws InvalidAccessException {
        String parentUniqueID = child.getItemValueString(UNIQUEID);
        String sQuery = "SELECT wi FROM Entity AS wi ";
        sQuery = sQuery + " JOIN wi.textItems as t2 ";
        sQuery = sQuery + " WHERE t2.itemName = '$uniqueidref' and t2.itemValue = '" + parentUniqueID + "' ";
        return this.findAllEntities(sQuery, start, count);
    }

    private boolean isCallerReader(Entity aEntity) {
        List<ReadAccess> readAccessList = aEntity.getReadAccessList();
        if (this.ctx.isCallerInRole(ACCESSLEVEL_NOACCESS)) {
            return false;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            return true;
        }
        if (readAccessList == null || readAccessList.size() == 0) {
            return true;
        }
        boolean notemptyfield = false;
        List<String> auserNameList = this.getUserNameList();
        for (ReadAccess aReadAccess : readAccessList) {
            if (aReadAccess == null || "".equals(aReadAccess.getValue())) continue;
            notemptyfield = true;
            if (auserNameList.indexOf(aReadAccess.getValue()) <= -1) continue;
            return true;
        }
        return !notemptyfield;
    }

    private boolean isCallerAuthor(Entity aEntity) {
        List<WriteAccess> writeAccessList = aEntity.getWriteAccessList();
        if (this.ctx.isCallerInRole(ACCESSLEVEL_NOACCESS)) {
            return false;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_EDITORACCESS)) {
            return true;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_AUTHORACCESS)) {
            if (writeAccessList == null || writeAccessList.size() == 0) {
                return false;
            }
            List<String> auserNameList = this.getUserNameList();
            for (WriteAccess aWriteAccess : writeAccessList) {
                if (aWriteAccess == null || "".equals(aWriteAccess.getValue()) || auserNameList.indexOf(aWriteAccess.getValue()) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getUserGroupList() {
        String[] applicationUserGroupList = (String[])this.ctx.getContextData().get(USER_GROUP_LIST);
        if (applicationUserGroupList != null) {
            for (int i = 0; i < applicationUserGroupList.length; ++i) {
                applicationUserGroupList[i] = applicationUserGroupList[i].trim();
            }
        }
        return applicationUserGroupList;
    }

    private void updateWriteAccessList(ItemCollection itemCol, Entity aEntity) {
        ArrayList<String> vAccessFieldList = new ArrayList<String>();
        for (WriteAccess aItem : aEntity.getWriteAccessList()) {
            this.manager.remove((Object)aItem);
        }
        aEntity.getWriteAccessList().clear();
        vAccessFieldList.add("$writeAccess");
        if (this.writeAccessFields != null && !"".equals(this.writeAccessFields)) {
            String[] stringArrayList;
            for (String aentry : stringArrayList = this.writeAccessFields.split(",")) {
                vAccessFieldList.add(aentry);
            }
        }
        for (String aentry : vAccessFieldList) {
            List vEntryList = itemCol.getItemValue(aentry);
            for (Object avalue : vEntryList) {
                if (avalue == null || "".equals(avalue.toString())) continue;
                WriteAccess newItem = new WriteAccess(avalue.toString());
                this.manager.persist((Object)newItem);
                aEntity.getWriteAccessList().add(newItem);
            }
        }
    }

    private void updateReadAccessList(ItemCollection itemCol, Entity aEntity) {
        ArrayList<String> vAccessFieldList = new ArrayList<String>();
        for (ReadAccess aItem : aEntity.getReadAccessList()) {
            this.manager.remove((Object)aItem);
        }
        aEntity.getReadAccessList().clear();
        vAccessFieldList.add("$readAccess");
        if (this.readAccessFields != null && !"".equals(this.readAccessFields)) {
            String[] stringArrayList;
            for (String aentry : stringArrayList = this.readAccessFields.split(",")) {
                vAccessFieldList.add(aentry);
            }
        }
        for (String aentry : vAccessFieldList) {
            List vEntryList = itemCol.getItemValue(aentry);
            for (Object avalue : vEntryList) {
                if (avalue == null || "".equals(avalue.toString())) continue;
                ReadAccess newItem = new ReadAccess(avalue.toString());
                this.manager.persist((Object)newItem);
                aEntity.getReadAccessList().add(newItem);
            }
        }
    }

    private void explodeEntity(ItemCollection itemCol, Entity aEntity, Collection<EntityIndex> entityIndexCache) {
        for (TextItem textItem : aEntity.getTextItems()) {
            this.manager.remove((Object)textItem);
        }
        aEntity.getTextItems().clear();
        for (CalendarItem calendarItem : aEntity.getCalendarItems()) {
            this.manager.remove((Object)calendarItem);
        }
        aEntity.getCalendarItems().clear();
        for (IntegerItem integerItem : aEntity.getIntegerItems()) {
            this.manager.remove((Object)integerItem);
        }
        aEntity.getIntegerItems().clear();
        for (DoubleItem doubleItem : aEntity.getDoubleItems()) {
            this.manager.remove((Object)doubleItem);
        }
        aEntity.getDoubleItems().clear();
        for (EntityIndex entityIndex : entityIndexCache) {
            Serializable newItem;
            Vector vInvalidValues;
            List valueList;
            if (entityIndex.getTyp() == 0) {
                valueList = itemCol.getItemValue(entityIndex.getName());
                for (Object asingleValue : valueList) {
                    TextItem newItem2 = new TextItem(entityIndex.getName(), asingleValue.toString());
                    this.manager.persist((Object)newItem2);
                    aEntity.getTextItems().add(newItem2);
                }
                itemCol.removeItem(entityIndex.getName());
                continue;
            }
            if (entityIndex.getTyp() == 1) {
                valueList = itemCol.getItemValue(entityIndex.getName());
                boolean bClassCastException = false;
                vInvalidValues = new Vector();
                for (Object asingleValue : valueList) {
                    try {
                        newItem = new IntegerItem(entityIndex.getName(), (Integer)asingleValue);
                        this.manager.persist((Object)newItem);
                        aEntity.getIntegerItems().add((IntegerItem)newItem);
                    }
                    catch (ClassCastException cce) {
                        bClassCastException = true;
                        logger.warning("explodeEntity - " + entityIndex.getName() + " TYP_INT: " + cce.getMessage());
                        vInvalidValues.add(asingleValue);
                    }
                }
                if (!bClassCastException) {
                    itemCol.removeItem(entityIndex.getName());
                    continue;
                }
                itemCol.replaceItemValue(entityIndex.getName(), vInvalidValues);
                continue;
            }
            if (entityIndex.getTyp() == 2) {
                valueList = itemCol.getItemValue(entityIndex.getName());
                boolean bClassCastException = false;
                vInvalidValues = new Vector();
                for (Object asingleValue : valueList) {
                    try {
                        newItem = new DoubleItem(entityIndex.getName(), (Double)asingleValue);
                        this.manager.persist((Object)newItem);
                        aEntity.getDoubleItems().add((DoubleItem)newItem);
                    }
                    catch (ClassCastException cce) {
                        bClassCastException = true;
                        logger.warning("explodeEntity - " + entityIndex.getName() + " TYP_DOUBLE: " + cce.getMessage());
                        vInvalidValues.add(asingleValue);
                    }
                }
                if (!bClassCastException) {
                    itemCol.removeItem(entityIndex.getName());
                    continue;
                }
                itemCol.replaceItemValue(entityIndex.getName(), vInvalidValues);
                continue;
            }
            if (entityIndex.getTyp() == 3) {
                valueList = itemCol.getItemValue(entityIndex.getName());
                boolean bClassCastException = false;
                vInvalidValues = new Vector();
                for (Object asingleValue : valueList) {
                    try {
                        if (asingleValue instanceof Date) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime((Date)asingleValue);
                            asingleValue = cal;
                        }
                        newItem = new CalendarItem(entityIndex.getName(), (Calendar)asingleValue);
                        this.manager.persist((Object)newItem);
                        aEntity.getCalendarItems().add((CalendarItem)newItem);
                    }
                    catch (ClassCastException cce) {
                        bClassCastException = true;
                        logger.warning("explodeEntity - " + entityIndex.getName() + " TYP_CALENDAR: " + cce.getMessage());
                        vInvalidValues.add(asingleValue);
                    }
                }
                if (!bClassCastException) {
                    itemCol.removeItem(entityIndex.getName());
                    continue;
                }
                itemCol.replaceItemValue(entityIndex.getName(), vInvalidValues);
                continue;
            }
            logger.warning(" explodeEntity - " + entityIndex.getName() + " Indextype:" + entityIndex.getTyp() + " unknown!");
        }
    }

    private ItemCollection implodeEntity(Entity aEntity) {
        List vValue;
        ItemCollection itemCollection = new ItemCollection();
        try {
            itemCollection.replaceItemValue("$isauthor", (Object)this.isCallerAuthor(aEntity));
        }
        catch (Exception e1) {
            // empty catch block
        }
        for (TextItem textItem : aEntity.getTextItems()) {
            try {
                vValue = itemCollection.getItemValue(textItem.itemName);
                vValue.add(textItem.itemValue);
                itemCollection.replaceItemValue(textItem.itemName, (Object)vValue);
            }
            catch (Exception e) {
                logger.warning("[EntityService] could not implode ItemValue: " + textItem.itemName);
            }
        }
        for (IntegerItem ii : aEntity.getIntegerItems()) {
            try {
                vValue = itemCollection.getItemValue(ii.itemName);
                vValue.add(ii.itemValue);
                itemCollection.replaceItemValue(ii.itemName, (Object)vValue);
            }
            catch (Exception e) {
                logger.warning("[EntityService] could not implode ItemValue: " + ii.itemName);
            }
        }
        for (DoubleItem di : aEntity.getDoubleItems()) {
            try {
                vValue = itemCollection.getItemValue(di.itemName);
                vValue.add(di.itemValue);
                itemCollection.replaceItemValue(di.itemName, (Object)vValue);
            }
            catch (Exception e) {
                logger.warning("[EntityService] could not implode ItemValue: " + di.itemName);
            }
        }
        for (CalendarItem ci : aEntity.getCalendarItems()) {
            try {
                vValue = itemCollection.getItemValue(ci.itemName);
                vValue.add(ci.itemValue.getTime());
                itemCollection.replaceItemValue(ci.itemName, (Object)vValue);
            }
            catch (Exception e) {
                logger.warning("[EntityService] could not implode ItemValue: " + ci.itemName);
            }
        }
        Map<String, Object> activeMap = aEntity.getData();
        if (activeMap != null) {
            for (Map.Entry<String, Object> mapEntry : activeMap.entrySet()) {
                String activePropertyName = mapEntry.getKey().toString();
                if (itemCollection.hasItem(activePropertyName)) continue;
                Vector activePropertyValue = (Vector)mapEntry.getValue();
                Vector detachePropertyValue = new Vector();
                detachePropertyValue.addAll(activePropertyValue);
                try {
                    itemCollection.replaceItemValue(activePropertyName, detachePropertyValue);
                }
                catch (Exception e) {
                    logger.warning("[EntityService] Warning implodeEntity - " + e.getMessage());
                }
            }
        }
        return itemCollection;
    }

    private String optimizeQuery(String aQuery) throws InvalidAccessException {
        StringBuffer nameListBuf = new StringBuffer();
        String nameList = "";
        StringTokenizer st = new StringTokenizer(aQuery = aQuery.trim());
        if (st.countTokens() < 5) {
            throw new InvalidAccessException("[EntityService] Invalid query format: " + aQuery);
        }
        st.nextToken();
        String sDistinct = st.nextToken();
        if (!"distinct".equals(sDistinct.toLowerCase().trim())) {
            int iDisPos = aQuery.toLowerCase().indexOf("select") + 6;
            aQuery = aQuery.substring(0, iDisPos) + " DISTINCT" + aQuery.substring(iDisPos);
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            return aQuery;
        }
        List<String> auserNameList = this.getUserNameList();
        for (String auserName : auserNameList) {
            nameListBuf.append(",'" + auserName + "'");
        }
        nameListBuf.deleteCharAt(0);
        nameList = nameListBuf.toString();
        logger.fine("Optimized NameList = " + nameList);
        int iPos = 0;
        iPos = aQuery.toLowerCase().indexOf("join");
        if (iPos == -1) {
            iPos = aQuery.toLowerCase().indexOf("where");
        }
        if (iPos == -1) {
            iPos = aQuery.toLowerCase().indexOf("order by");
        }
        String firstPart = iPos == -1 ? aQuery : aQuery.substring(0, iPos - 1);
        firstPart = firstPart.trim();
        iPos = firstPart.length();
        String identifier = null;
        identifier = firstPart.substring(firstPart.lastIndexOf(32)).trim();
        if (identifier.endsWith(",")) {
            identifier = identifier.substring(0, identifier.length() - 1);
        }
        String aNewQuery = aQuery.substring(0, iPos);
        aNewQuery = aNewQuery + " LEFT JOIN " + identifier + ".readAccessList access807 ";
        aQuery = (aNewQuery = aNewQuery + aQuery.substring(iPos)).trim();
        int iWherePos = aQuery.toLowerCase().indexOf("where");
        if (iWherePos > -1) {
            aQuery = aNewQuery = aQuery.substring(0, iWherePos + 5) + " (access807.value IS NULL OR access807.value IN (" + nameList + ")) AND " + aQuery.substring(iWherePos + 6);
        } else {
            int iOrderPos = aQuery.toLowerCase().indexOf("order by");
            aNewQuery = iOrderPos > -1 ? aQuery.substring(0, iOrderPos - 1) + " WHERE (access807.value IS NULL OR access807.value IN (" + nameList + ")) " + aQuery.substring(iOrderPos) : aQuery + " WHERE (access807.value IS NULL OR access807.value IN(" + nameList + ")) ";
            aQuery = aNewQuery;
        }
        logger.fine("Optimized Query=" + aQuery);
        return aQuery;
    }

    private void updateAllEntityIndexFields(Collection<Entity> entityList, String newIndexField) {
        long count = 0L;
        Collection<EntityIndex> entityIndexCache = this.getIndices();
        for (Entity activeEntity : entityList) {
            ItemCollection slimItemcol = new ItemCollection(activeEntity.getData());
            if (newIndexField != null && !slimItemcol.hasItem(newIndexField)) continue;
            try {
                ItemCollection itemcol = this.implodeEntity(activeEntity);
                ItemCollection slimItemCollection = new ItemCollection(itemcol.getAllItems());
                this.updateReadAccessList(slimItemCollection, activeEntity);
                this.updateWriteAccessList(slimItemCollection, activeEntity);
                this.explodeEntity(slimItemCollection, activeEntity, entityIndexCache);
                activeEntity.setData(slimItemCollection.getAllItems());
            }
            catch (Exception merex) {
                logger.info("[EntityServiceBean] Error updateAllEntityIndexFields for Entity : " + activeEntity.getId());
                merex.printStackTrace();
            }
            ++count;
        }
        logger.info("[EntityServiceBean] " + count + " effective updates");
    }
}

