/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.imixs.workflow.ExtendedModel;
import org.imixs.workflow.ExtendedWorkflowContext;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Model;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.jee.ejb.EntityService;
import org.imixs.workflow.jee.ejb.ModelService;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class WorkflowService
implements ExtendedWorkflowContext {
    public static final int SORT_ORDER_CREATED_DESC = 0;
    public static final int SORT_ORDER_CREATED_ASC = 1;
    public static final int SORT_ORDER_MODIFIED_DESC = 2;
    public static final int SORT_ORDER_MODIFIED_ASC = 3;
    private int logLevel = 0;
    @EJB
    EntityService entityService;
    @EJB
    ModelService modelService;
    @Resource
    SessionContext ctx;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    @PostConstruct
    private void initIndexProperties() throws AccessDeniedException {
        this.entityService.addIndex("namCreator", 0);
        this.entityService.addIndex("txtWorkflowGroup", 0);
        this.entityService.addIndex("$ProcessID", 1);
        this.entityService.addIndex("$workitemid", 0);
        this.entityService.addIndex("$uniqueidref", 0);
        this.entityService.addIndex("txtname", 0);
        this.entityService.addIndex("namowner", 0);
    }

    public ItemCollection getWorkItem(String uniqueid) {
        return this.entityService.load(uniqueid);
    }

    public Collection<ItemCollection> getWorkList(String name) {
        return this.getWorkList(name, 0, -1, null, 0);
    }

    public Collection<ItemCollection> getWorkList(String name, int startpos, int count, String type, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.writeAccessList as wa JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " wa.value = '" + name + "'" + " AND s.itemName = '$workitemid' ORDER BY wi.created desc";
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByCreator(String name, int startpos, int count, String type, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as t JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = 'namcreator' and t.itemValue = '" + name + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByOwner(String name, int startpos, int count, String type, int sortorder) {
        if (name == null || "".equals(name)) {
            name = this.ctx.getCallerPrincipal().getName();
        }
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi JOIN wi.textItems as t JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = 'namowner' and t.itemValue = '" + name + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByWriteAccess(int startpos, int count, String type, int sortorder) {
        StringBuffer nameListBuffer = new StringBuffer();
        String name = this.ctx.getCallerPrincipal().getName();
        nameListBuffer.append("'" + name + "'");
        String accessRoles = this.entityService.getAccessRoles();
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS," + accessRoles;
        StringTokenizer roleListTokens = new StringTokenizer(roleList, ",");
        while (roleListTokens.hasMoreTokens()) {
            String testRole = roleListTokens.nextToken().trim();
            if ("".equals(testRole) || !this.ctx.isCallerInRole(testRole)) continue;
            nameListBuffer.append(",'" + testRole + "'");
        }
        String sQuery = "SELECT wi FROM Entity as wi  JOIN wi.writeAccessList wa  WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' ";
        }
        sQuery = sQuery + " AND wa.value IN (" + nameListBuffer.toString() + ")" + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByGroup(String name, int startpos, int count, String type, int sortorder) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.textItems as t  JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = 'txtworkflowgroup' and t.itemValue = '" + name + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByProcessID(int aid, int startpos, int count, String type, int sortorder) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.integerItems as t JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = '$processid' and t.itemValue = '" + aid + "'" + " AND s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    public Collection<ItemCollection> getWorkListByRef(String aref) {
        return this.getWorkListByRef(aref, 0, -1, null, 0);
    }

    public Collection<ItemCollection> getWorkListByRef(String aref, int startpos, int count, String type, int sortorder) {
        String sQuery = null;
        sQuery = "SELECT";
        sQuery = sQuery + " wi FROM Entity as wi  JOIN wi.textItems as t JOIN wi.textItems as s WHERE ";
        if (type != null && !"".equals(type)) {
            sQuery = sQuery + " wi.type='" + type + "' AND ";
        }
        sQuery = sQuery + " t.itemName = '$uniqueidref' and t.itemValue = '" + aref + "'" + " and s.itemName = '$workitemid' " + this.createSortOrderClause(sortorder);
        return this.entityService.findAllEntities(sQuery, startpos, count);
    }

    private String createSortOrderClause(int asortorder) {
        switch (asortorder) {
            case 1: {
                return " ORDER BY wi.created asc";
            }
            case 3: {
                return " ORDER BY wi.modified asc";
            }
            case 2: {
                return " ORDER BY wi.modified desc";
            }
        }
        return " ORDER BY wi.created desc";
    }

    public ItemCollection processWorkItem(ItemCollection itemCollection) throws AccessDeniedException, ProcessingErrorException {
        String modelversion = itemCollection.getItemValueString("$modelversion");
        ItemCollection profile = this.findModelProfile(modelversion);
        WorkflowKernel workflowkernel = new WorkflowKernel((WorkflowContext)this);
        List vPlugins = profile.getItemValue("txtPlugins");
        for (int i = 0; i < vPlugins.size(); ++i) {
            String sPlugin = (String)vPlugins.get(i);
            workflowkernel.registerPlugin(sPlugin);
        }
        String sDebug = profile.getItemValueString("keyDebugLevel");
        try {
            int idebug;
            this.logLevel = idebug = Integer.parseInt(sDebug);
        }
        catch (NumberFormatException e) {
            this.logLevel = 2;
        }
        if (!modelversion.equals(profile.getItemValueString("$ModelVersion"))) {
            logger.info("WorkflowService: modelversion '" + modelversion + "' no longer provided. Continue processing with modelversion '" + profile.getItemValueString("$ModelVersion") + "'");
            modelversion = profile.getItemValueString("$ModelVersion");
            itemCollection.replaceItemValue("$modelversion", (Object)modelversion);
        }
        String name = this.ctx.getCallerPrincipal().getName();
        if ("".equals(itemCollection.getItemValueString("namCreator"))) {
            itemCollection.replaceItemValue("namCreator", (Object)name);
        }
        itemCollection.replaceItemValue("namlasteditor", (Object)itemCollection.getItemValueString("namcurrenteditor"));
        itemCollection.replaceItemValue("namcurrenteditor", (Object)name);
        workflowkernel.process(itemCollection);
        if (this.getLogLevel() == 2) {
            logger.info("[WorkflowManager] workitem processed sucessfull");
        }
        return this.entityService.save(itemCollection);
    }

    public void removeWorkItem(ItemCollection aworkitem) throws AccessDeniedException {
        this.entityService.remove(aworkitem);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public Model getModel() {
        return this.modelService;
    }

    public ExtendedModel getExtendedModel() {
        return this.modelService;
    }

    public Object getSessionContext() {
        return this.ctx;
    }

    private ItemCollection findModelProfile(String modelversion) throws ProcessingErrorException {
        ItemCollection profile = null;
        if (modelversion == null || "".equals(modelversion)) {
            modelversion = this.modelService.getLatestVersion();
        }
        String sQuery = null;
        sQuery = "SELECT";
        Collection<ItemCollection> col = this.entityService.findAllEntities(sQuery = sQuery + " environment FROM Entity AS environment JOIN environment.textItems as n  JOIN environment.textItems as v  WHERE environment.type = 'WorkflowEnvironmentEntity' AND n.itemName = 'txtname' AND n.itemValue = 'environment.profile' AND v.itemName = '$modelversion' AND v.itemValue >= '" + modelversion + "' ORDER BY v.itemValue", 0, 1);
        if (col.size() == 0) {
            logger.severe("WorkflowService: fatal error - no valid model version '" + modelversion + "' found! Verify WorkflowModels.");
            throw new ProcessingErrorException("WorkflowService: fatal error - no valid model version '" + modelversion + "' found! Verify WorkflowModels.");
        }
        profile = col.iterator().next();
        return profile;
    }

    public EntityService getEntityService() {
        return this.entityService;
    }

    public ModelService getModelService() {
        return this.modelService;
    }

    public String getUserName() {
        return this.ctx.getCallerPrincipal().getName();
    }

    public boolean isUserInRole(String rolename) {
        try {
            return this.ctx.isCallerInRole(rolename);
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> getUserNameList() {
        return this.entityService.getUserNameList();
    }
}

