/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;

public class AccessPlugin
extends AbstractPlugin {
    ItemCollection documentContext;
    ItemCollection documentActivity;
    List itemReadRollback;
    List itemWriteRollback;
    WorkflowContext workflowContext;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        this.workflowContext = actx;
    }

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        int j;
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        this.validate();
        Vector itemRead = (Vector)this.documentContext.getItemValue("$readAccess");
        this.itemReadRollback = (Vector)this.documentContext.getItemValue("$readAccess");
        List vectorAccess = "1".equals(this.documentActivity.getItemValueString("keyaccessmode")) ? itemRead : new Vector();
        if (this.workflowContext.getLogLevel() == 2) {
            logger.info("[AccessPlugin] AccessMode: '" + this.documentActivity.getItemValueString("keyaccessmode") + "'");
        }
        if (vectorAccess == null) {
            vectorAccess = new Vector();
        }
        this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("namaddreadaccess"));
        this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("keyaddreadroles"));
        this.mergeMappedFieldValues(this.documentContext, vectorAccess, this.documentActivity.getItemValue("keyaddreadfields"));
        vectorAccess = this.uniqueList(vectorAccess);
        this.documentContext.replaceItemValue("$readAccess", vectorAccess);
        if (this.workflowContext.getLogLevel() == 2 && vectorAccess.size() > 0) {
            logger.info("[AccessPlugin] ReadAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.info("              " + (String)vectorAccess.get(j));
            }
        }
        List itemWrite = this.documentContext.getItemValue("$writeAccess");
        this.itemWriteRollback = this.documentContext.getItemValue("$writeAccess");
        vectorAccess = "1".equals(this.documentActivity.getItemValueString("keyaccessmode")) ? itemWrite : new Vector();
        if (vectorAccess == null) {
            vectorAccess = new Vector();
        }
        this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("namaddwriteaccess"));
        this.mergeVectors(vectorAccess, this.documentActivity.getItemValue("keyaddwriteroles"));
        this.mergeMappedFieldValues(this.documentContext, vectorAccess, this.documentActivity.getItemValue("keyaddwritefields"));
        vectorAccess = this.uniqueList(vectorAccess);
        this.documentContext.replaceItemValue("$writeAccess", vectorAccess);
        if (this.workflowContext.getLogLevel() == 2 && vectorAccess.size() > 0) {
            logger.info("[AccessPlugin] WriteAccess:");
            for (j = 0; j < vectorAccess.size(); ++j) {
                logger.info("               " + (String)vectorAccess.get(j));
            }
        }
        return 0;
    }

    public void close(int status) throws PluginException {
        try {
            if (status == 2) {
                this.documentContext.replaceItemValue("$writeAccess", (Object)this.itemWriteRollback);
                this.documentContext.replaceItemValue("$readAccess", (Object)this.itemReadRollback);
            }
        }
        catch (Exception e) {
            throw new PluginException("[AccessPlugin] Error close() " + e.toString());
        }
    }

    private void validate() {
        if (!this.documentActivity.hasItem("keyaccessmode")) {
            this.documentActivity.replaceItemValue("keyaccessmode", (Object)"");
        }
        if (!this.documentActivity.hasItem("namaddreadaccess")) {
            this.documentActivity.replaceItemValue("namaddreadaccess", (Object)"");
        }
        if (!this.documentActivity.hasItem("keyaddreadroles")) {
            this.documentActivity.replaceItemValue("keyaddreadroles", (Object)"");
        }
        if (!this.documentActivity.hasItem("keyaddreadfields")) {
            this.documentActivity.replaceItemValue("keyaddreadfields", (Object)"");
        }
        if (!this.documentActivity.hasItem("namaddwriteaccess")) {
            this.documentActivity.replaceItemValue("namaddwriteaccess", (Object)"");
        }
        if (!this.documentActivity.hasItem("keyaddwriteroles")) {
            this.documentActivity.replaceItemValue("keyaddwriteroles", (Object)"");
        }
        if (!this.documentActivity.hasItem("keyaddreadfields")) {
            this.documentActivity.replaceItemValue("keyaddreadfields", (Object)"");
        }
        if (!this.documentContext.hasItem("$readAccess")) {
            this.documentContext.replaceItemValue("$readAccess", (Object)"");
        }
        if (!this.documentContext.hasItem("$writeAccess")) {
            this.documentContext.replaceItemValue("$writeAccess", (Object)"");
        }
    }
}

