/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.plugins;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.plugins.AbstractPlugin;

public class RulePlugin
extends AbstractPlugin {
    private static ScriptEngine engine = null;
    private static Logger logger = Logger.getLogger("org.imixs.workflow");

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
        ScriptEngineManager manager = new ScriptEngineManager();
        engine = manager.getEngineByName("javascript");
    }

    public int run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        if (RulePlugin.evaluateBusinessRule(adocumentContext, adocumentActivity)) {
            Double d;
            Long followUpActivity;
            Boolean isValidActivity = (Boolean)engine.get("isValid");
            if (isValidActivity != null && !isValidActivity.booleanValue()) {
                throw new PluginException("BusinessRule: activity is not valid for this process instance!");
            }
            Object o = engine.get("followUp");
            if (o != null && (followUpActivity = Long.valueOf((d = Double.valueOf(o.toString())).longValue())) != null && followUpActivity > 0L) {
                adocumentActivity.replaceItemValue("keyFollowUp", (Object)"1");
                adocumentActivity.replaceItemValue("numNextActivityID", (Object)followUpActivity);
            }
            return 0;
        }
        return 0;
    }

    public void close(int status) {
    }

    public static boolean isValid(ItemCollection documentContext, ItemCollection activity) {
        Boolean isValidActivity;
        if (RulePlugin.evaluateBusinessRule(documentContext, activity) && (isValidActivity = (Boolean)engine.get("isValid")) != null) {
            return isValidActivity;
        }
        return true;
    }

    private static boolean evaluateBusinessRule(ItemCollection documentContext, ItemCollection activity) throws PluginException {
        String script = activity.getItemValueString("txtBusinessRule");
        if ("".equals(script.trim())) {
            return false;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        String sEngineType = activity.getItemValueString("txtBusinessRuleEngine");
        if ("".equals(sEngineType)) {
            sEngineType = "javascript";
        }
        engine = manager.getEngineByName(sEngineType);
        Map itemList = documentContext.getAllItems();
        for (Map.Entry entry : itemList.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value.size() <= 0) continue;
            engine.put(key.toLowerCase(), value.toArray());
        }
        logger.info("SCRIPT:" + script);
        try {
            engine.eval(script);
        }
        catch (ScriptException e) {
            throw new PluginException("BusinessRule invalid script!", (Exception)e);
        }
        return true;
    }
}

