/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.ItemCollectionComparator;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.util.XMLParser;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class ReportService {
    private static Logger logger = Logger.getLogger(ReportService.class.getName());
    @EJB
    DocumentService documentService;

    public ItemCollection getReport(String aReportName) {
        ItemCollection itemCol = this.findReport(aReportName);
        return itemCol;
    }

    public List<ItemCollection> getReportList() {
        List<ItemCollection> col = this.documentService.getDocumentsByType("ReportEntity");
        Collections.sort(col, new ItemCollectionComparator("txtname", true));
        return col;
    }

    public void updateReport(ItemCollection aReport) throws AccessDeniedException {
        String sReportName;
        ItemCollection oldReport;
        aReport.replaceItemValue("type", (Object)"ReportEntity");
        String sUniqueID = aReport.getItemValueString("$uniqueID");
        if ("".equals(sUniqueID) && (oldReport = this.findReport(sReportName = aReport.getItemValueString("txtName"))) != null) {
            aReport = this.updateReport(aReport, oldReport);
        }
        this.documentService.save(aReport);
    }

    public List<ItemCollection> executeReport(String reportName, int startPos, int maxcount, Map<String, String> params, List<String> itemList) throws QueryException {
        long l = System.currentTimeMillis();
        logger.fine("executeReport: " + reportName);
        ItemCollection reportEntity = this.findReport(reportName);
        String query = reportEntity.getItemValueString("txtQuery");
        if (maxcount == 0) {
            maxcount = -1;
        }
        if (params != null) {
            Set<String> keys = params.keySet();
            Iterator<String> iter = keys.iterator();
            while (iter.hasNext()) {
                String sKeyName = iter.next().toString();
                if (query.indexOf("?" + sKeyName) <= -1) continue;
                String sParamValue = params.get(sKeyName);
                query = query.replace("?" + sKeyName, sParamValue);
                logger.fine("executeReport set param " + sKeyName + "=" + (String)sParamValue);
            }
        }
        query = ReportService.replaceDateString(query);
        logger.fine("executeReport jpql=" + query);
        List<ItemCollection> result = this.documentService.find(query, startPos, maxcount);
        if (itemList == null) {
            itemList = reportEntity.getItemValue("txtAttributeList");
        }
        if (itemList != null && itemList.size() > 0) {
            ArrayList<ItemCollection> clonedResult = new ArrayList<ItemCollection>();
            HashMap<String, String> formatMap = new HashMap<String, String>();
            for (String field : itemList) {
                List formatList = XMLParser.findTags((String)field, (String)"format");
                if (formatList != null && formatList.size() > 0) {
                    String fieldName = field.substring(0, field.indexOf("<"));
                    List xmlValues = XMLParser.findTagValues((String)field, (String)"format");
                    if (xmlValues.size() <= 0) continue;
                    formatMap.put(fieldName, (String)xmlValues.get(0));
                    continue;
                }
                if (field.indexOf("<") > -1) {
                    field = field.substring(0, field.indexOf("<"));
                }
                formatMap.put(field, "");
            }
            HashMap<String, String> converterMap = new HashMap<String, String>();
            for (String field : itemList) {
                List formatList = XMLParser.findTags((String)field, (String)"convert");
                if (formatList == null || formatList.size() <= 0) continue;
                String fieldName = field.substring(0, field.indexOf("<"));
                List xmlValues = XMLParser.findTagValues((String)field, (String)"convert");
                if (xmlValues.size() <= 0) continue;
                converterMap.put(fieldName, (String)xmlValues.get(0));
            }
            for (ItemCollection entity : result) {
                List<ItemCollection> embeddedChildItems = this.getEmbeddedChildItems(entity, formatMap.keySet());
                if (!embeddedChildItems.isEmpty()) {
                    for (ItemCollection child : embeddedChildItems) {
                        ItemCollection clone = this.cloneEntity(child, formatMap, converterMap);
                        clonedResult.add(clone);
                    }
                    continue;
                }
                ItemCollection clone = this.cloneEntity(entity, formatMap, converterMap);
                clonedResult.add(clone);
            }
            logger.fine("executed report '" + reportName + "' in " + (System.currentTimeMillis() - l) + "ms");
            return clonedResult;
        }
        logger.fine("executed report '" + reportName + "' in " + (System.currentTimeMillis() - l) + "ms");
        return result;
    }

    private List<ItemCollection> getEmbeddedChildItems(ItemCollection entity, Set<String> fieldNames) {
        ArrayList<String> embeddedItemNames = new ArrayList<String>();
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        for (String field : fieldNames) {
            if (!(field = field.toLowerCase()).contains("~") || embeddedItemNames.contains(field = field.substring(0, field.indexOf(126)))) continue;
            embeddedItemNames.add(field);
        }
        if (!embeddedItemNames.isEmpty()) {
            for (String field : embeddedItemNames) {
                List mapChildItems = entity.getItemValue(field);
                for (Object mapOderItem : mapChildItems) {
                    if (!(mapOderItem instanceof Map)) continue;
                    ItemCollection child = new ItemCollection((Map)mapOderItem);
                    ItemCollection clone = new ItemCollection(entity);
                    Set childFieldNameList = child.getAllItems().keySet();
                    for (String childFieldName : childFieldNameList) {
                        clone.replaceItemValue(field + "~" + childFieldName, (Object)child.getItemValue(childFieldName));
                    }
                    result.add(clone);
                }
            }
        }
        return result;
    }

    private ItemCollection cloneEntity(ItemCollection entity, Map<String, String> formatMap, Map<String, String> converterMap) {
        ItemCollection clone = new ItemCollection();
        Set<String> fieldNames = formatMap.keySet();
        for (String field : fieldNames) {
            String format;
            String converter = converterMap.get(field);
            if (converter != null) {
                entity = this.convertItemValue(entity, field, converter);
            }
            if (!(format = formatMap.get(field)).isEmpty()) {
                String sLocale = XMLParser.findAttribute((String)format, (String)"locale");
                ArrayList<String> vValues = new ArrayList<String>();
                List rawValues = entity.getItemValue(field);
                for (Object rawValue : rawValues) {
                    vValues.add(this.formatObjectValue(rawValue, format, sLocale));
                }
                clone.replaceItemValue(field, vValues);
                continue;
            }
            clone.replaceItemValue(field, (Object)entity.getItemValue(field));
        }
        return clone;
    }

    public static Calendar computeDynamicDate(String xmlDate) {
        String value;
        Calendar cal = Calendar.getInstance();
        Map attributes = XMLParser.findAttributes((String)xmlDate);
        if (attributes.containsKey("MONTH")) {
            value = (String)attributes.get("MONTH");
            if ("ACTUAL_MAXIMUM".equalsIgnoreCase(value)) {
                cal.set(2, cal.getActualMaximum(2));
            } else {
                cal.set(2, Integer.parseInt(value) - 1);
            }
        }
        if (attributes.containsKey("YEAR")) {
            value = (String)attributes.get("YEAR");
            cal.set(1, Integer.parseInt(value));
        }
        if (attributes.containsKey("DAY_OF_MONTH")) {
            value = (String)attributes.get("DAY_OF_MONTH");
            if ("ACTUAL_MAXIMUM".equalsIgnoreCase(value)) {
                cal.set(5, cal.getActualMaximum(5));
            } else {
                cal.set(5, Integer.parseInt(value));
            }
        }
        if (attributes.containsKey("DAY_OF_YEAR")) {
            cal.set(6, Integer.parseInt((String)attributes.get("DAY_OF_YEAR")));
        }
        if (attributes.containsKey("ADD")) {
            value = (String)attributes.get("ADD");
            String[] fieldOffset = value.split(",");
            String field = fieldOffset[0];
            int offset = Integer.parseInt(fieldOffset[1]);
            if ("MONTH".equalsIgnoreCase(field)) {
                cal.add(2, offset);
            } else if ("DAY_OF_MONTH".equalsIgnoreCase(field)) {
                cal.add(5, offset);
            } else if ("DAY_OF_YEAR".equalsIgnoreCase(field)) {
                cal.add(6, offset);
            }
        }
        return cal;
    }

    public static String replaceDateString(String content) {
        List dates = XMLParser.findTags((String)content, (String)"date");
        for (String dateString : dates) {
            Calendar cal = ReportService.computeDynamicDate(dateString);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            String dateValue = f.format(cal.getTime());
            content = content.replace(dateString, dateValue);
        }
        return content;
    }

    private ItemCollection findReport(String aid) {
        ItemCollection result = null;
        result = this.documentService.load(aid);
        if (result == null) {
            List<ItemCollection> col;
            String searchTerm = "(type:\"ReportEntity\" AND txtname:\"" + aid + "\")";
            try {
                col = this.documentService.find(searchTerm, 1, 0);
            }
            catch (QueryException e) {
                logger.severe("findReport - invalid id: " + e.getMessage());
                return null;
            }
            if (col.size() > 0) {
                result = (ItemCollection)col.iterator().next();
            }
        }
        return result;
    }

    private ItemCollection updateReport(ItemCollection newReport, ItemCollection oldReport) {
        for (Map.Entry mapEntry : newReport.getAllItems().entrySet()) {
            String sName = mapEntry.getKey().toString();
            Object o = mapEntry.getValue();
            if (!this.isValidAttributeName(sName)) continue;
            oldReport.replaceItemValue(sName, o);
        }
        return oldReport;
    }

    private boolean isValidAttributeName(String aName) {
        if ("namcreator".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$created".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$modified".equalsIgnoreCase(aName)) {
            return false;
        }
        if ("$uniqueID".equalsIgnoreCase(aName)) {
            return false;
        }
        return !"$isAuthor".equalsIgnoreCase(aName);
    }

    private String formatObjectValue(Object o, String format, String locale) {
        String singleValue = "";
        Date dateValue = null;
        if (o instanceof Date) {
            dateValue = (Date)o;
        }
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            dateValue = cal.getTime();
        }
        if (dateValue != null) {
            if (format != null && !"".equals(format)) {
                try {
                    SimpleDateFormat formatter = null;
                    formatter = locale != null && !locale.isEmpty() ? new SimpleDateFormat(format, this.getLocaleFromString(locale)) : new SimpleDateFormat(format);
                    singleValue = formatter.format(dateValue);
                }
                catch (Exception ef) {
                    Logger logger = Logger.getLogger(AbstractPlugin.class.getName());
                    logger.warning("ReportService: Invalid format String '" + format + "'");
                    logger.warning("ReportService: Can not format value - error: " + ef.getMessage());
                    return "" + dateValue;
                }
            } else {
                singleValue = DateFormat.getDateTimeInstance(3, 3).format(dateValue);
            }
        } else if (format.contains("#")) {
            try {
                double d = Double.parseDouble(o.toString());
                DecimalFormat numberFormatter = new DecimalFormat(format);
                singleValue = numberFormatter.format(d);
            }
            catch (NumberFormatException e) {
                singleValue = "0";
            }
        } else {
            singleValue = o.toString();
        }
        return singleValue;
    }

    private ItemCollection convertItemValue(ItemCollection itemcol, String itemName, String converter) {
        if (converter == null || converter.isEmpty()) {
            return itemcol;
        }
        List values = itemcol.getItemValue(itemName);
        if (values.size() == 0) {
            values.add(null);
        }
        for (int i = 0; i < values.size(); ++i) {
            Object o = values.get(i);
            if (converter.equalsIgnoreCase("double") || converter.equalsIgnoreCase("xs:decimal")) {
                try {
                    double d = 0.0;
                    if (o != null) {
                        d = Double.parseDouble(o.toString());
                    }
                    values.set(i, d);
                }
                catch (NumberFormatException e) {
                    values.set(i, new Double(0.0));
                }
            }
            if (!converter.equalsIgnoreCase("integer") && !converter.equalsIgnoreCase("xs:int")) continue;
            try {
                int d = 0;
                if (o != null) {
                    i = Integer.parseInt(o.toString());
                }
                values.set(i, d);
                continue;
            }
            catch (NumberFormatException e) {
                values.set(i, new Integer(0));
            }
        }
        itemcol.replaceItemValue(itemName, (Object)values);
        return itemcol;
    }

    private Locale getLocaleFromString(String sLocale) {
        Locale locale = null;
        if (sLocale != null && !sLocale.isEmpty()) {
            StringTokenizer stLocale = new StringTokenizer(sLocale, "_");
            if (stLocale.countTokens() == 1) {
                String sLang = stLocale.nextToken();
                String sCount = sLang.toUpperCase();
                locale = new Locale(sLang, sCount);
            } else {
                String sLang = stLocale.nextToken();
                String sCount = stLocale.nextToken();
                locale = new Locale(sLang, sCount);
            }
        }
        return locale;
    }
}

