/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.JobHandlerMigration3X;
import org.imixs.workflow.engine.adminp.JobHandlerRebuildIndex;
import org.imixs.workflow.engine.adminp.JobHandlerRenameUser;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class AdminPService {
    public static final String JOB_RENAME_USER = "RENAME_USER";
    public static final String JOB_REBUILD_LUCENE_INDEX = "REBUILD_LUCENE_INDEX";
    public static final String JOB_MIGRATION = "MIGRATION";
    private static final int DEFAULT_INTERVAL = 1;
    @Resource
    SessionContext ctx;
    @Resource
    TimerService timerService;
    @EJB
    DocumentService documentService;
    @EJB
    JobHandlerRebuildIndex jobHandlerRebuildIndex;
    @EJB
    JobHandlerRenameUser jobHandlerRenameUser;
    @EJB
    JobHandlerMigration3X jobHandlerMigration3X;
    private static Logger logger = Logger.getLogger(AdminPService.class.getName());

    public ItemCollection createJob(ItemCollection adminp) throws AccessDeniedException {
        String jobtype = adminp.getItemValueString("job");
        if (!(jobtype.equals(JOB_RENAME_USER) || jobtype.equals(JOB_REBUILD_LUCENE_INDEX) || jobtype.equals(JOB_MIGRATION))) {
            throw new InvalidAccessException("INVALID_WORKITEM", "AdminPService: error - invalid job type");
        }
        adminp.replaceItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
        int interval = adminp.getItemValueInteger("numInterval");
        if (interval <= 0) {
            interval = 1;
            adminp.replaceItemValue("numInterval", (Object)new Long(interval));
        }
        Calendar cal = Calendar.getInstance();
        Date terminationDate = cal.getTime();
        cal.add(10, 24);
        adminp.replaceItemValue("datTerminate", (Object)terminationDate);
        adminp = this.documentService.save(adminp);
        Timer timer = this.timerService.createTimer(terminationDate, (long)(60 * interval * 1000), (Serializable)((Object)adminp.getItemValueString("$uniqueid")));
        logger.info("Job started - ID=" + timer.getInfo().toString());
        return adminp;
    }

    public void deleteJob(String id) throws AccessDeniedException {
        ItemCollection adminp = this.cancelTimer(id);
        if (adminp != null) {
            this.documentService.remove(adminp);
        }
    }

    @Timeout
    public void scheduleTimer(Timer timer) {
        String sTimerID = null;
        long lProfiler = System.currentTimeMillis();
        sTimerID = timer.getInfo().toString();
        ItemCollection adminp = this.documentService.load(sTimerID);
        try {
            if (adminp == null) {
                logger.info("Process " + sTimerID + " was removed - timer will be canceled");
                timer.cancel();
                return;
            }
            logger.info("Processing : " + sTimerID);
            boolean jobfound = false;
            String job = adminp.getItemValueString("job");
            if (job.equals(JOB_RENAME_USER)) {
                jobfound = true;
                if (this.jobHandlerRenameUser.run(adminp)) {
                    timer.cancel();
                    logger.info("Job " + adminp.getUniqueID() + " completed - timer stopped");
                }
            }
            if (job.equals(JOB_REBUILD_LUCENE_INDEX)) {
                jobfound = true;
                if (this.jobHandlerRebuildIndex.run(adminp)) {
                    timer.cancel();
                    logger.info("Job " + adminp.getUniqueID() + " completed - timer stopped");
                }
            }
            if (job.equals(JOB_MIGRATION)) {
                jobfound = true;
                if (this.jobHandlerMigration3X.run(adminp)) {
                    timer.cancel();
                    logger.info("Job " + adminp.getUniqueID() + " completed - timer stopped");
                }
            }
            if (!jobfound) {
                logger.warning("Unable to start jobtype '" + job + "' -  not defined!");
                timer.cancel();
                logger.info("Job " + adminp.getUniqueID() + " - timer stopped");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            timer.cancel();
            logger.severe("Timeout sevice stopped: " + sTimerID);
            try {
                adminp.replaceItemValue("txtworkflowStatus", (Object)"Error");
                adminp.replaceItemValue("errormessage", (Object)e.toString());
                adminp = this.documentService.save(adminp);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        logger.fine("timer call finished successfull after " + (System.currentTimeMillis() - lProfiler) + " ms");
    }

    private ItemCollection cancelTimer(String id) {
        Timer timer;
        logger.fine("cancelTimer - id:" + id + " ....");
        ItemCollection adminp = this.documentService.load(id);
        if (adminp == null) {
            logger.warning("failed to load timer data ID:" + id + " ");
        }
        if ((timer = this.findTimer(id)) != null) {
            timer.cancel();
            logger.info("cancelTimer - id:" + id + " successful.");
        } else {
            logger.info("cancelTimer - id:" + id + " failed - timer does no longer exist.");
        }
        if (adminp != null) {
            adminp.replaceItemValue("txtTimerStatus", (Object)"Stopped");
        }
        return adminp;
    }

    private Timer findTimer(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (Object obj : this.timerService.getTimers()) {
            String timerid;
            Timer timer = (Timer)obj;
            if (!(timer.getInfo() instanceof String) || !id.equals(timerid = timer.getInfo().toString())) continue;
            return timer;
        }
        logger.warning("findTimer - id:" + id + " does no longer exist.");
        return null;
    }
}

