/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;
import org.imixs.workflow.engine.lucene.LuceneUpdateService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class JobHandlerRenameUser
implements JobHandler {
    @Resource
    SessionContext ctx;
    @EJB
    DocumentService documentService;
    @EJB
    LuceneUpdateService luceneService;
    private static Logger logger = Logger.getLogger(JobHandlerRenameUser.class.getName());

    @Override
    public boolean run(ItemCollection adminp) throws AdminPException {
        List<ItemCollection> col;
        long lProfiler = System.currentTimeMillis();
        int iStart = adminp.getItemValueInteger("numStart");
        int iCount = adminp.getItemValueInteger("numMaxCount");
        int iUpdates = adminp.getItemValueInteger("numUpdates");
        int iProcessed = adminp.getItemValueInteger("numProcessed");
        String fromName = adminp.getItemValueString("namFrom");
        String to = adminp.getItemValueString("namTo");
        boolean replace = adminp.getItemValueBoolean("keyReplace");
        String summary = "Rename: " + fromName + ">>" + to + " (";
        summary = replace ? summary + "replace" : summary + "no replace";
        summary = summary + ")";
        logger.info(summary);
        adminp.replaceItemValue("txtWorkflowSummary", (Object)summary);
        adminp.replaceItemValue("txtworkflowStatus", (Object)"Processing");
        adminp = ((JobHandlerRenameUser)this.ctx.getBusinessObject(JobHandlerRenameUser.class)).saveJobEntity(adminp);
        String sQuery = "(type:\"workitem\" OR type:\"workitemarchive\" OR type:\"childworkitem\" OR type:\"childworkitemarchive\" OR type:\"workitemlob\" )";
        sQuery = sQuery + " AND ($writeaccess:\"" + fromName + "\" OR $readaccess:\"" + fromName + "\" OR namowner:\"" + fromName + "\" OR namcreator:\"" + fromName + "\" )";
        try {
            col = this.documentService.find(sQuery, iStart, iCount);
        }
        catch (QueryException e) {
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        for (ItemCollection entity : col) {
            ++iProcessed;
            boolean result = ((JobHandlerRenameUser)this.ctx.getBusinessObject(JobHandlerRenameUser.class)).updateWorkitemUserIds(entity, fromName, to, replace, adminp.getItemValueString("$uniqueid"));
            if (!result) continue;
            ++iUpdates;
        }
        adminp.replaceItemValue("numUpdates", (Object)iUpdates);
        adminp.replaceItemValue("numProcessed", (Object)iProcessed);
        adminp.replaceItemValue("numLastCount", (Object)col.size());
        adminp.replaceItemValue("numStart", (Object)(iStart += col.size()));
        String timerid = adminp.getItemValueString("$uniqueid");
        long time = (System.currentTimeMillis() - lProfiler) / 1000L;
        logger.info("run:" + timerid + " " + col.size() + " workitems processed in " + time + " sec.");
        int iMax = adminp.getItemValueInteger("numMaxCount");
        int iLast = adminp.getItemValueInteger("numLastCount");
        if (iLast < iMax) {
            adminp.replaceItemValue("txtworkflowStatus", (Object)"Finished");
            return true;
        }
        adminp.replaceItemValue("txtworkflowStatus", (Object)"Waiting");
        return false;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean updateWorkitemUserIds(ItemCollection entity, String from, String to, boolean replace, String adminpUniqueid) throws AccessDeniedException {
        boolean bUpdate = false;
        if (entity == null) {
            return false;
        }
        entity.replaceItemValue("txtAdminP", (Object)("AdminP:" + adminpUniqueid + " "));
        this.logOldValues(entity, "$ReadAccess");
        if (this.updateList(entity.getItemValue("$ReadAccess"), from, to, replace)) {
            bUpdate = true;
        }
        this.logOldValues(entity, "$WriteAccess");
        if (this.updateList(entity.getItemValue("$WriteAccess"), from, to, replace)) {
            bUpdate = true;
        }
        this.logOldValues(entity, "namOwner");
        if (this.updateList(entity.getItemValue("namOwner"), from, to, replace)) {
            bUpdate = true;
        }
        this.logOldValues(entity, "namCreator");
        if (this.updateList(entity.getItemValue("namCreator"), from, to, replace)) {
            bUpdate = true;
        }
        if (bUpdate) {
            this.documentService.save(entity);
            logger.fine("[AmdinP] updated: " + entity.getItemValueString("$uniqueid"));
        }
        return bUpdate;
    }

    private void logOldValues(ItemCollection entity, String field) {
        String log = entity.getItemValueString("txtAdminP");
        log = log + " " + field + "=";
        List list = entity.getItemValue(field);
        for (Object o : list) {
            log = log + o.toString() + ",";
        }
        entity.replaceItemValue("txtAdminP", (Object)log);
    }

    private boolean updateList(List list, String from, String to, boolean replace) {
        boolean update = false;
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (list.contains(from)) {
            if (to != null && !"".equals(to) && !list.contains(to)) {
                list.add(to);
                update = true;
            }
            if (replace) {
                while (list.contains(from)) {
                    list.remove(from);
                    update = true;
                }
            }
        }
        return update;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection saveJobEntity(ItemCollection adminp) throws AccessDeniedException {
        logger.fine("saveJobEntity " + adminp.getUniqueID());
        adminp = this.documentService.save(adminp);
        return adminp;
    }
}

