/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.engine.plugins.AccessPlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;

public class OwnerPlugin
extends AbstractPlugin {
    ItemCollection documentContext;
    ItemCollection documentActivity;
    ItemCollection documentNextProcessEntity;
    private static Logger logger = Logger.getLogger(AccessPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.documentActivity = adocumentActivity;
        int iNextProcessID = adocumentActivity.getItemValueInteger("numNextProcessID");
        String aModelVersion = adocumentActivity.getItemValueString("$modelVersion");
        try {
            this.documentNextProcessEntity = this.getCtx().getModelManager().getModel(aModelVersion).getTask(iNextProcessID);
        }
        catch (ModelException e) {
            return this.documentContext;
        }
        if (!(this.documentActivity.getItemValueBoolean("keyupdateacl") || this.documentNextProcessEntity != null && this.documentNextProcessEntity.getItemValueBoolean("keyupdateacl"))) {
            return this.documentContext;
        }
        if (this.documentActivity.getItemValueBoolean("keyupdateacl")) {
            this.updateOwnerByItemCollection(this.documentActivity);
        } else {
            this.updateOwnerByItemCollection(this.documentNextProcessEntity);
        }
        return this.documentContext;
    }

    private void updateOwnerByItemCollection(ItemCollection modelEntity) {
        if (modelEntity == null || !modelEntity.getItemValueBoolean("keyupdateacl")) {
            return;
        }
        List<Object> newOwnerList = new ArrayList<Object>();
        this.mergeValueList(newOwnerList, modelEntity.getItemValue("namOwnershipNames"));
        this.mergeFieldList(this.documentContext, newOwnerList, modelEntity.getItemValue("keyOwnershipFields"));
        newOwnerList = this.uniqueList(newOwnerList);
        this.documentContext.replaceItemValue("namowner", newOwnerList);
        if (logger.isLoggable(Level.FINE) && newOwnerList.size() > 0) {
            logger.fine("[OwnerPlugin] Owners:");
            for (int j = 0; j < newOwnerList.size(); ++j) {
                logger.fine("               '" + (String)newOwnerList.get(j) + "'");
            }
        }
    }
}

