/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class IntervalPlugin
extends AbstractPlugin {
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    ItemCollection documentContext;
    String sActivityResult;
    private static Logger logger = Logger.getLogger(IntervalPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        if (!"1".equals(adocumentActivity.getItemValueString("keyScheduledActivity"))) {
            return this.documentContext;
        }
        Calendar calNow = Calendar.getInstance();
        logger.fine("[IntervalPlugin] compute next interval dates for workitem " + this.documentContext.getItemValueString("$uniqueid"));
        Set fieldNames = this.documentContext.getAllItems().keySet();
        for (String fieldName : fieldNames) {
            Calendar calDate;
            String sDateField;
            block7: {
                Date date;
                String sInterval;
                if (!fieldName.toLowerCase().startsWith("keyinterval") || (sInterval = this.documentContext.getItemValueString(fieldName)).isEmpty()) continue;
                sInterval = sInterval.toLowerCase();
                sDateField = fieldName.substring(11);
                if (sDateField.isEmpty() || !this.documentContext.hasItem(sDateField) || (date = this.documentContext.getItemValueDate(sDateField)) == null) continue;
                calDate = Calendar.getInstance();
                calDate.setTime(date);
                if (!calNow.after(calDate)) continue;
                logger.fine("[IntervalPlugin] compute next interval for " + sDateField);
                calDate.set(1, calNow.get(1));
                calDate.set(2, calNow.get(2));
                calDate.set(5, calNow.get(5));
                try {
                    int iDays = Integer.parseInt(sInterval);
                    calDate.add(5, iDays);
                }
                catch (NumberFormatException nfe) {
                    if (sInterval.contains("daily")) {
                        calDate.add(5, 1);
                    }
                    if (sInterval.contains("weekly")) {
                        calDate.add(5, 7);
                    }
                    if (sInterval.contains("monthly")) {
                        calDate.add(2, 1);
                    }
                    if (!sInterval.contains("yearly")) break block7;
                    calDate.add(1, 1);
                }
            }
            this.documentContext.replaceItemValue(sDateField, (Object)calDate.getTime());
        }
        return this.documentContext;
    }
}

