/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.jee.ejb;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.jee.ejb.EntityServiceRemote;
import org.imixs.workflow.jee.jpa.CalendarItem;
import org.imixs.workflow.jee.jpa.DoubleItem;
import org.imixs.workflow.jee.jpa.Entity;
import org.imixs.workflow.jee.jpa.EntityIndex;
import org.imixs.workflow.jee.jpa.IntegerItem;
import org.imixs.workflow.jee.jpa.ReadAccess;
import org.imixs.workflow.jee.jpa.TextItem;
import org.imixs.workflow.jee.jpa.WriteAccess;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
@Deprecated
public class EntityService
implements EntityServiceRemote {
    public static final int TYP_TEXT = 0;
    public static final int TYP_INT = 1;
    public static final int TYP_DOUBLE = 2;
    public static final int TYP_CALENDAR = 3;
    public static final String ACCESSLEVEL_NOACCESS = "org.imixs.ACCESSLEVEL.NOACCESS";
    public static final String ACCESSLEVEL_READERACCESS = "org.imixs.ACCESSLEVEL.READERACCESS";
    public static final String ACCESSLEVEL_AUTHORACCESS = "org.imixs.ACCESSLEVEL.AUTHORACCESS";
    public static final String ACCESSLEVEL_EDITORACCESS = "org.imixs.ACCESSLEVEL.EDITORACCESS";
    public static final String ACCESSLEVEL_MANAGERACCESS = "org.imixs.ACCESSLEVEL.MANAGERACCESS";
    public static final String UNIQUEID = "$uniqueid";
    public static final String UNIQUEIDREF = "$uniqueidref";
    public static final String READACCESS = "$readaccess";
    public static final String WRITEACCESS = "$writeaccess";
    public static final String ISAUTHOR = "$isAuthor";
    public static final String USER_GROUP_LIST = "org.imixs.USER.GROUPLIST";
    private static final Logger logger = Logger.getLogger(EntityService.class.getName());
    public static final String OPERATION_NOTALLOWED = "OPERATION_NOTALLOWED";
    public static final String INVALID_UNIQUEID = "INVALID_UNIQUEID";
    @Resource
    SessionContext ctx;
    @Resource(name="READ_ACCESS_FIELDS")
    private String readAccessFields = "";
    @Resource(name="WRITE_ACCESS_FIELDS")
    private String writeAccessFields = "";
    @Resource(name="ACCESS_ROLES")
    private String accessRoles = "";
    @Resource(name="DISABLE_OPTIMISTIC_LOCKING")
    private Boolean disableOptimisticLocking = false;
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;

    @Override
    public String getAccessRoles() {
        return this.accessRoles;
    }

    @Override
    public void setAccessRoles(String accessRoles) {
        this.accessRoles = accessRoles;
    }

    @Override
    public String getReadAccessFields() {
        return this.readAccessFields;
    }

    @Override
    public void setReadAccessFields(String readAccessFields) {
        this.readAccessFields = readAccessFields;
    }

    @Override
    public String getWriteAccessFields() {
        return this.writeAccessFields;
    }

    @Override
    public void setWriteAccessFields(String writeAccessFields) {
        this.writeAccessFields = writeAccessFields;
    }

    @Override
    public void setDisableOptimisticLocking(Boolean disableOptimisticLocking) {
        this.disableOptimisticLocking = disableOptimisticLocking;
    }

    @Override
    public Boolean getDisableOptimisticLocking() {
        return this.disableOptimisticLocking;
    }

    @Deprecated
    public List<String> _getUserNameList() {
        Vector<String> userNameList = new Vector<String>();
        userNameList.add(this.ctx.getCallerPrincipal().getName().toString());
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS,org.imixs.ACCESSLEVEL.MANAGERACCESS," + this.accessRoles;
        StringTokenizer roleListTokens = new StringTokenizer(roleList, ",");
        while (roleListTokens.hasMoreTokens()) {
            try {
                String testRole = roleListTokens.nextToken().trim();
                if ("".equals(testRole) || !this.ctx.isCallerInRole(testRole)) continue;
                userNameList.add(testRole);
            }
            catch (Exception testRole) {}
        }
        String[] applicationGroups = this.getUserGroupList();
        if (applicationGroups != null) {
            for (String auserRole : applicationGroups) {
                userNameList.add(auserRole);
            }
        }
        return userNameList;
    }

    @Override
    @Deprecated
    public ItemCollection _save(ItemCollection itemcol) throws AccessDeniedException {
        Calendar cal;
        Entity activeEntity = null;
        ItemCollection slimItemCollection = null;
        logger.finest("[EntityService] save entity started");
        List<EntityIndex> entityIndexCache = this.readIndices();
        this.manager.setFlushMode(FlushModeType.COMMIT);
        String sID = itemcol.getItemValueString(UNIQUEID);
        if (!"".equals(sID) && (activeEntity = (Entity)this.manager.find(Entity.class, (Object)sID)) == null) {
            logger.fine("[EntityService] Entity '" + sID + "' not found!");
        }
        if (activeEntity == null) {
            if (!(this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_EDITORACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_AUTHORACCESS))) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "[EntityService] You are not allowed to perform this operation");
            }
            activeEntity = new Entity(sID);
            Date datCreated = itemcol.getItemValueDate("$Created");
            if (datCreated != null) {
                cal = Calendar.getInstance();
                cal.setTime(datCreated);
                activeEntity.setCreated(cal);
            }
            logger.finest("[EntityService] persist activeEntity");
            this.manager.persist((Object)activeEntity);
        } else if (!this.isCallerAuthor(activeEntity) || !this.isCallerReader(activeEntity)) {
            throw new AccessDeniedException(OPERATION_NOTALLOWED, "[EntityService] You are not allowed to perform this operation");
        }
        itemcol.removeItem("$isauthor");
        String aType = itemcol.getItemValueString("type");
        if ("".equals(aType)) {
            aType = "Entity";
        }
        activeEntity.setType(aType);
        cal = Calendar.getInstance();
        itemcol.replaceItemValue(UNIQUEID, (Object)activeEntity.getId());
        itemcol.replaceItemValue("$modified", (Object)cal.getTime());
        itemcol.replaceItemValue("$created", (Object)activeEntity.getCreated().getTime());
        slimItemCollection = new ItemCollection(itemcol.getAllItems());
        this.updateReadAccessList(slimItemCollection, activeEntity);
        this.updateWriteAccessList(slimItemCollection, activeEntity);
        this.explodeEntity(slimItemCollection, activeEntity, entityIndexCache);
        activeEntity.setData(slimItemCollection.getAllItems());
        itemcol.replaceItemValue("$isauthor", (Object)this.isCallerAuthor(activeEntity));
        this.manager.flush();
        itemcol.replaceItemValue("$Version", (Object)activeEntity.getVersion());
        this.manager.detach((Object)activeEntity);
        return itemcol;
    }

    @Deprecated
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection _saveByNewTransaction(ItemCollection itemcol) throws AccessDeniedException {
        return this._save(itemcol);
    }

    @Override
    @Deprecated
    public ItemCollection _load(String id) {
        Entity activeEntity = null;
        activeEntity = (Entity)this.manager.find(Entity.class, (Object)id);
        if (activeEntity != null && this.isCallerReader(activeEntity)) {
            return this.implodeEntity(activeEntity);
        }
        return null;
    }

    @Override
    @Deprecated
    public void _remove(ItemCollection itemcol) throws AccessDeniedException {
        Entity activeEntity = null;
        String sID = itemcol.getItemValueString(UNIQUEID);
        activeEntity = (Entity)this.manager.find(Entity.class, (Object)sID);
        if (activeEntity != null) {
            if (!this.isCallerReader(activeEntity) || !this.isCallerAuthor(activeEntity)) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "[EntityService] You are not allowed to perform this operation");
            }
            for (TextItem textItem : activeEntity.getTextItems()) {
                this.manager.remove((Object)textItem);
            }
            activeEntity.getTextItems().clear();
            for (CalendarItem calendarItem : activeEntity.getCalendarItems()) {
                this.manager.remove((Object)calendarItem);
            }
            activeEntity.getCalendarItems().clear();
            for (IntegerItem integerItem : activeEntity.getIntegerItems()) {
                this.manager.remove((Object)integerItem);
            }
            activeEntity.getIntegerItems().clear();
            for (DoubleItem doubleItem : activeEntity.getDoubleItems()) {
                this.manager.remove((Object)doubleItem);
            }
            activeEntity.getDoubleItems().clear();
            for (WriteAccess writeAccess : activeEntity.getWriteAccessList()) {
                this.manager.remove((Object)writeAccess);
            }
            activeEntity.getWriteAccessList().clear();
            for (ReadAccess readAccess : activeEntity.getReadAccessList()) {
                this.manager.remove((Object)readAccess);
            }
        } else {
            throw new AccessDeniedException(INVALID_UNIQUEID, "[EntityService] invalid $uniqueid");
        }
        activeEntity.getReadAccessList().clear();
        this.manager.remove((Object)activeEntity);
    }

    @Override
    public void addIndex(String stitel, int ityp) throws AccessDeniedException {
        EntityIndex activeEntityIndex = (EntityIndex)this.manager.find(EntityIndex.class, (Object)(stitel = stitel.toLowerCase()));
        if (activeEntityIndex != null) {
            return;
        }
        if (!this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            throw new AccessDeniedException(OPERATION_NOTALLOWED, "[EntityService] You are not allowed to add index fields");
        }
        logger.info("[EntityServiceBean] add new Index: " + stitel + ":" + ityp);
        activeEntityIndex = new EntityIndex(stitel, ityp);
        this.manager.persist((Object)activeEntityIndex);
    }

    @Override
    public void removeIndex(String stitel) throws AccessDeniedException {
        int indexType = 0;
        EntityIndex activeEntityIndex = (EntityIndex)this.manager.find(EntityIndex.class, (Object)(stitel = stitel.toLowerCase()));
        if (activeEntityIndex == null) {
            return;
        }
        if (!this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            throw new AccessDeniedException(OPERATION_NOTALLOWED, "[EntityService] You are not allowed to add index fields");
        }
        indexType = activeEntityIndex.getTyp();
        logger.info("[EntityService] remove Index: " + stitel + ":" + indexType);
        this.manager.remove((Object)activeEntityIndex);
    }

    @Override
    public Map<String, Integer> getIndices() {
        HashMap<String, Integer> indexList = new HashMap<String, Integer>();
        List<EntityIndex> list = this.readIndices();
        for (EntityIndex aIndex : list) {
            indexList.put(aIndex.getName(), aIndex.getTyp());
        }
        return indexList;
    }

    private List<EntityIndex> readIndices() {
        logger.finer("readIndices....");
        Query q = this.manager.createQuery("SELECT entityindex FROM EntityIndex entityindex");
        return q.getResultList();
    }

    @Override
    @Deprecated
    public List<ItemCollection> _findAllEntities(String query, int startpos, int maxcount) throws InvalidAccessException {
        long l = 0L;
        logger.fine("[EntityService] findAllEntities - Query=" + query);
        logger.fine("[EntityService] findAllEntities - Startpos=" + startpos + " maxcount=" + maxcount);
        ArrayList<ItemCollection> vectorResult = new ArrayList<ItemCollection>();
        query = this.optimizeQuery(query);
        try {
            Query q = this.manager.createQuery(query);
            if (startpos >= 0) {
                q.setFirstResult(startpos);
            }
            if (maxcount > 0) {
                q.setMaxResults(maxcount);
            }
            l = System.currentTimeMillis();
            List entityList = q.getResultList();
            logger.fine("[EntityService] findAllEntities - getResultList in " + (System.currentTimeMillis() - l) + " ms");
            if (entityList == null) {
                return vectorResult;
            }
            logger.fine("[EntityService] findAllEntities - ResultList size=" + entityList.size());
            l = System.currentTimeMillis();
            for (Entity aEntity : entityList) {
                vectorResult.add(this.implodeEntity(aEntity));
            }
            logger.fine("[EntityService] findAllEntities in " + (System.currentTimeMillis() - l) + " ms");
        }
        catch (RuntimeException nre) {
            throw new InvalidAccessException("[EntityService] Error findAllEntities: '" + query + "' ", (Exception)nre);
        }
        return vectorResult;
    }

    public int countAllEntities(String query) throws InvalidAccessException {
        long l = 0L;
        logger.fine("[EntityService] countAllEntities - Query=" + query);
        query = this.optimizeQuery(query);
        StringTokenizer st = new StringTokenizer(query);
        st.nextToken();
        String chunk1 = st.nextToken();
        String chunk2 = st.nextToken();
        int pos = query.indexOf(chunk1);
        query = query.substring(0, pos) + "COUNT" + query.substring(pos + 8);
        pos = query.indexOf(chunk2);
        query = query.substring(0, pos) + "(" + chunk2 + ".id)" + query.substring(pos + chunk2.length());
        Query q = this.manager.createQuery(query);
        Number cResults = (Number)q.getSingleResult();
        logger.fine("[EntityService] countAllEntities in " + (System.currentTimeMillis() - l) + " ms");
        return cResults.intValue();
    }

    @Override
    public ItemCollection findParentEntity(ItemCollection child) throws InvalidAccessException {
        String parentUniqueID = child.getItemValueString(UNIQUEIDREF);
        return this._load(parentUniqueID);
    }

    @Override
    public List<ItemCollection> findChildEntities(ItemCollection child, int start, int count) throws InvalidAccessException {
        String parentUniqueID = child.getItemValueString(UNIQUEID);
        String sQuery = "SELECT wi FROM Entity AS wi ";
        sQuery = sQuery + " JOIN wi.textItems as t2 ";
        sQuery = sQuery + " WHERE t2.itemName = '$uniqueidref' and t2.itemValue = '" + parentUniqueID + "' ";
        return this._findAllEntities(sQuery, start, count);
    }

    public void backup(String query, String filePath) throws IOException {
        boolean hasMoreData = true;
        int JUNK_SIZE = 100;
        long totalcount = 0L;
        int startpos = 0;
        int icount = 0;
        logger.info("[EntityService] Starting backup....");
        logger.info("[EntityService] Query=" + query);
        logger.info("[EntityService] Target=" + filePath);
        if (filePath == null || filePath.isEmpty()) {
            logger.severe("[EntityService] Invalid FilePath!");
            return;
        }
        FileOutputStream fos = new FileOutputStream(filePath);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        while (hasMoreData) {
            List<ItemCollection> col = this._findAllEntities(query, startpos, JUNK_SIZE);
            if (col.size() < JUNK_SIZE) {
                hasMoreData = false;
            }
            startpos += col.size();
            totalcount += (long)col.size();
            for (ItemCollection aworkitem : col) {
                Map hmap = aworkitem.getAllItems();
                out.writeObject(hmap);
                ++icount;
            }
            logger.fine("[EntityService] " + totalcount + " entries backuped....");
        }
        out.close();
        logger.info("[EntityService] Backup finished - " + icount + " entities read totaly.");
    }

    public void restore(String filePath) throws IOException {
        int JUNK_SIZE = 100;
        long totalcount = 0L;
        long errorCount = 0L;
        int icount = 0;
        FileInputStream fis = new FileInputStream(filePath);
        ObjectInputStream in = new ObjectInputStream(fis);
        while (true) {
            try {
                while (true) {
                    Map hmap = (Map)in.readObject();
                    ItemCollection itemCol = new ItemCollection(hmap);
                    itemCol.removeItem("$Version");
                    this._save(itemCol);
                    ++totalcount;
                    if (++icount < JUNK_SIZE) continue;
                    icount = 0;
                    logger.info("[EntityService] Restored " + totalcount + " entities....");
                }
            }
            catch (EOFException eofe) {
            }
            catch (ClassNotFoundException e) {
                logger.warning("[EntityService] error importing workitem at position " + (totalcount + ++errorCount) + " Error: " + e.getMessage());
                continue;
            }
            catch (AccessDeniedException e) {
                logger.warning("[EntityService] error importing workitem at position " + (totalcount + ++errorCount) + " Error: " + e.getMessage());
                continue;
            }
            break;
        }
        in.close();
        String loginfo = "Import successfull! " + totalcount + " Entities imported. " + errorCount + " Errors.  Import FileName:" + filePath;
        logger.info(loginfo);
    }

    private boolean isCallerReader(Entity aEntity) {
        List<ReadAccess> readAccessList = aEntity.getReadAccessList();
        if (this.ctx.isCallerInRole(ACCESSLEVEL_NOACCESS)) {
            return false;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            return true;
        }
        if (readAccessList == null || readAccessList.size() == 0) {
            return true;
        }
        boolean notemptyfield = false;
        List<String> auserNameList = this._getUserNameList();
        for (ReadAccess aReadAccess : readAccessList) {
            if (aReadAccess == null || "".equals(aReadAccess.getValue())) continue;
            notemptyfield = true;
            if (auserNameList.indexOf(aReadAccess.getValue()) <= -1) continue;
            return true;
        }
        return !notemptyfield;
    }

    private boolean isCallerAuthor(Entity aEntity) {
        List<WriteAccess> writeAccessList = aEntity.getWriteAccessList();
        if (this.ctx.isCallerInRole(ACCESSLEVEL_NOACCESS)) {
            return false;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_EDITORACCESS)) {
            return true;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_AUTHORACCESS)) {
            if (writeAccessList == null || writeAccessList.size() == 0) {
                return false;
            }
            List<String> auserNameList = this._getUserNameList();
            for (WriteAccess aWriteAccess : writeAccessList) {
                if (aWriteAccess == null || "".equals(aWriteAccess.getValue()) || auserNameList.indexOf(aWriteAccess.getValue()) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getUserGroupList() {
        String[] applicationUserGroupList = (String[])this.ctx.getContextData().get(USER_GROUP_LIST);
        if (applicationUserGroupList != null) {
            for (int i = 0; i < applicationUserGroupList.length; ++i) {
                applicationUserGroupList[i] = applicationUserGroupList[i].trim();
            }
        }
        return applicationUserGroupList;
    }

    private void updateWriteAccessList(ItemCollection itemCol, Entity aEntity) {
        ArrayList<String> vAccessFieldList = new ArrayList<String>();
        for (WriteAccess writeAccess : aEntity.getWriteAccessList()) {
            this.manager.remove((Object)writeAccess);
        }
        aEntity.getWriteAccessList().clear();
        vAccessFieldList.add("$writeAccess");
        if (this.writeAccessFields != null && !"".equals(this.writeAccessFields)) {
            String[] stringArrayList;
            for (String aentry : stringArrayList = this.writeAccessFields.split(",")) {
                vAccessFieldList.add(aentry);
            }
        }
        for (String string : vAccessFieldList) {
            List vEntryList = itemCol.getItemValue(string);
            for (Object avalue : vEntryList) {
                if (avalue == null || "".equals(avalue.toString())) continue;
                WriteAccess newItem = new WriteAccess(avalue.toString());
                this.manager.persist((Object)newItem);
                aEntity.getWriteAccessList().add(newItem);
            }
        }
    }

    private void updateReadAccessList(ItemCollection itemCol, Entity aEntity) {
        ArrayList<String> vAccessFieldList = new ArrayList<String>();
        for (ReadAccess readAccess : aEntity.getReadAccessList()) {
            this.manager.remove((Object)readAccess);
        }
        aEntity.getReadAccessList().clear();
        vAccessFieldList.add("$readAccess");
        if (this.readAccessFields != null && !"".equals(this.readAccessFields)) {
            String[] stringArrayList;
            for (String aentry : stringArrayList = this.readAccessFields.split(",")) {
                vAccessFieldList.add(aentry);
            }
        }
        for (String string : vAccessFieldList) {
            List vEntryList = itemCol.getItemValue(string);
            for (Object avalue : vEntryList) {
                if (avalue == null || "".equals(avalue.toString())) continue;
                ReadAccess newItem = new ReadAccess(avalue.toString());
                this.manager.persist((Object)newItem);
                aEntity.getReadAccessList().add(newItem);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void explodeEntity(ItemCollection itemCol, Entity aEntity, Collection<EntityIndex> entityIndexCache) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[EntityService] explodeEntity ID=" + aEntity.getId());
        }
        logger.finest("[EntityService] disableOptimisticLocking=" + this.disableOptimisticLocking);
        if (this.disableOptimisticLocking.booleanValue()) {
            itemCol.removeItem("$Version");
        } else if (itemCol.hasItem("$Version") && itemCol.getItemValueInteger("$Version") > 0) {
            int version = itemCol.getItemValueInteger("$Version");
            aEntity.setVersion(version);
            logger.finest("[EntityService] version=" + version);
        }
        this.removeDeprectedIndexValues(aEntity, entityIndexCache);
        for (EntityIndex index : entityIndexCache) {
            Serializable newItem;
            ArrayList<Serializable> itemList;
            ArrayList<Serializable> oldValueList;
            List newValueList;
            Vector<Serializable> vInvalidValues;
            if (index.getTyp() == 0) {
                List newValueList2 = itemCol.getItemValue(index.getName());
                ArrayList<String> oldValueList2 = new ArrayList<String>();
                ArrayList<TextItem> itemList2 = new ArrayList<TextItem>();
                for (TextItem aItem : aEntity.getTextItems()) {
                    if (!aItem.itemName.equals(index.getName())) continue;
                    itemList2.add(aItem);
                    oldValueList2.add(aItem.itemValue);
                }
                if (!newValueList2.equals(oldValueList2)) {
                    for (TextItem aItem : itemList2) {
                        this.manager.remove((Object)aItem);
                        aEntity.getTextItems().remove(aItem);
                    }
                    for (TextItem asingleValue : newValueList2) {
                        TextItem newItem2 = new TextItem(index.getName(), asingleValue.toString());
                        this.manager.persist((Object)newItem2);
                        aEntity.getTextItems().add(newItem2);
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.finest("[EntityService] addTextItem: " + index.getName() + "=" + asingleValue.toString());
                    }
                }
                itemCol.removeItem(index.getName());
                continue;
            }
            if (index.getTyp() == 1) {
                boolean bClassCastException = false;
                vInvalidValues = new Vector<Serializable>();
                newValueList = itemCol.getItemValue(index.getName());
                oldValueList = new ArrayList<Serializable>();
                itemList = new ArrayList<Serializable>();
                for (IntegerItem integerItem : aEntity.getIntegerItems()) {
                    if (!integerItem.itemName.equals(index.getName())) continue;
                    itemList.add(integerItem);
                    oldValueList.add(integerItem.itemValue);
                }
                if (!newValueList.equals(oldValueList)) {
                    for (IntegerItem integerItem : itemList) {
                        this.manager.remove((Object)integerItem);
                        aEntity.getIntegerItems().remove(integerItem);
                    }
                    for (Serializable serializable : newValueList) {
                        try {
                            newItem = new IntegerItem(index.getName(), (Integer)serializable);
                            this.manager.persist((Object)newItem);
                            aEntity.getIntegerItems().add((IntegerItem)newItem);
                            if (!logger.isLoggable(Level.FINEST)) continue;
                            logger.finest("[EntityService] addIntegerItem: " + index.getName() + "=" + serializable.toString());
                        }
                        catch (ClassCastException cce) {
                            bClassCastException = true;
                            logger.warning("explodeEntity - " + index.getName() + " TYP_INT: " + cce.getMessage() + " ID:" + aEntity.getId());
                            vInvalidValues.add(serializable);
                        }
                    }
                }
                if (!bClassCastException) {
                    itemCol.removeItem(index.getName());
                    continue;
                }
                itemCol.replaceItemValue(index.getName(), vInvalidValues);
                continue;
            }
            if (index.getTyp() == 2) {
                boolean bClassCastException = false;
                vInvalidValues = new Vector();
                newValueList = itemCol.getItemValue(index.getName());
                oldValueList = new ArrayList();
                itemList = new ArrayList();
                for (DoubleItem doubleItem : aEntity.getDoubleItems()) {
                    if (!doubleItem.itemName.equals(index.getName())) continue;
                    itemList.add(doubleItem);
                    oldValueList.add(doubleItem.itemValue);
                }
                if (!newValueList.equals(oldValueList)) {
                    for (DoubleItem doubleItem : itemList) {
                        this.manager.remove((Object)doubleItem);
                        aEntity.getDoubleItems().remove(doubleItem);
                    }
                    for (Serializable serializable : newValueList) {
                        try {
                            newItem = new DoubleItem(index.getName(), (Double)serializable);
                            this.manager.persist((Object)newItem);
                            aEntity.getDoubleItems().add((DoubleItem)newItem);
                            if (!logger.isLoggable(Level.FINEST)) continue;
                            logger.finest("[EntityService] addDoubleItem: " + index.getName() + "=" + serializable.toString());
                        }
                        catch (ClassCastException cce) {
                            bClassCastException = true;
                            logger.warning("explodeEntity - " + index.getName() + " TYP_DOUBLE: " + cce.getMessage() + " ID:" + aEntity.getId());
                            vInvalidValues.add(serializable);
                        }
                    }
                }
                if (!bClassCastException) {
                    itemCol.removeItem(index.getName());
                    continue;
                }
                itemCol.replaceItemValue(index.getName(), vInvalidValues);
                continue;
            }
            if (index.getTyp() == 3) {
                boolean bClassCastException = false;
                vInvalidValues = new Vector();
                newValueList = itemCol.getItemValue(index.getName());
                oldValueList = new ArrayList();
                itemList = new ArrayList();
                for (CalendarItem calendarItem : aEntity.getCalendarItems()) {
                    if (!calendarItem.itemName.equals(index.getName())) continue;
                    itemList.add(calendarItem);
                    oldValueList.add(calendarItem.itemValue);
                }
                if (!newValueList.equals(oldValueList)) {
                    for (CalendarItem calendarItem : itemList) {
                        this.manager.remove((Object)calendarItem);
                        aEntity.getCalendarItems().remove(calendarItem);
                    }
                    for (Serializable serializable : newValueList) {
                        try {
                            void var12_27;
                            if (serializable instanceof Date) {
                                Calendar cal = Calendar.getInstance();
                                cal.setTime((Date)serializable);
                                Calendar calendar = cal;
                            }
                            newItem = new CalendarItem(index.getName(), (Calendar)var12_27);
                            this.manager.persist((Object)newItem);
                            aEntity.getCalendarItems().add((CalendarItem)newItem);
                            if (!logger.isLoggable(Level.FINEST)) continue;
                            logger.finest("[EntityService] addCalendarItem: " + index.getName() + "=" + var12_27.toString());
                        }
                        catch (ClassCastException cce) {
                            bClassCastException = true;
                            logger.warning("explodeEntity - " + index.getName() + " TYP_CALENDAR: " + cce.getMessage() + " ID:" + aEntity.getId());
                            vInvalidValues.add(serializable);
                        }
                    }
                }
                if (!bClassCastException) {
                    itemCol.removeItem(index.getName());
                    continue;
                }
                itemCol.replaceItemValue(index.getName(), vInvalidValues);
                continue;
            }
            logger.warning(" explodeEntity - " + index.getName() + " Indextype:" + index.getTyp() + " unknown!");
        }
    }

    private ItemCollection implodeEntity(Entity aEntity) {
        List vValue;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[EntityService] implodeEntity ID=" + aEntity.getId());
        }
        ItemCollection itemCollection = new ItemCollection();
        itemCollection.replaceItemValue("$isauthor", (Object)this.isCallerAuthor(aEntity));
        for (TextItem textItem : aEntity.getTextItems()) {
            try {
                vValue = itemCollection.getItemValue(textItem.itemName);
                vValue.add(textItem.itemValue);
                itemCollection.replaceItemValue(textItem.itemName, (Object)vValue);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("[EntityService] readTextItem: " + textItem.itemName + "=" + textItem.itemValue);
            }
            catch (Exception e) {
                logger.warning("[EntityService] could not implode ItemValue: " + textItem.itemName);
            }
        }
        for (IntegerItem ii : aEntity.getIntegerItems()) {
            try {
                vValue = itemCollection.getItemValue(ii.itemName);
                vValue.add(ii.itemValue);
                itemCollection.replaceItemValue(ii.itemName, (Object)vValue);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("[EntityService] readIntegerItem: " + ii.itemName + "=" + ii.itemValue);
            }
            catch (Exception e) {
                logger.warning("[EntityService] could not implode ItemValue: " + ii.itemName);
            }
        }
        for (DoubleItem di : aEntity.getDoubleItems()) {
            try {
                vValue = itemCollection.getItemValue(di.itemName);
                vValue.add(di.itemValue);
                itemCollection.replaceItemValue(di.itemName, (Object)vValue);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("[EntityService] readDoubleItem: " + di.itemName + "=" + di.itemValue);
            }
            catch (Exception e) {
                logger.warning("[EntityService] could not implode ItemValue: " + di.itemName);
            }
        }
        for (CalendarItem ci : aEntity.getCalendarItems()) {
            try {
                vValue = itemCollection.getItemValue(ci.itemName);
                vValue.add(ci.itemValue.getTime());
                itemCollection.replaceItemValue(ci.itemName, (Object)vValue);
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("[EntityService] readCalendarItem: " + ci.itemName + "=" + ci.itemValue);
            }
            catch (Exception e) {
                logger.warning("[EntityService] could not implode ItemValue: " + ci.itemName);
            }
        }
        Map<String, List<Object>> activeMap = aEntity.getData();
        this.manager.detach((Object)aEntity);
        if (activeMap != null) {
            for (Map.Entry<String, List<Object>> mapEntry : activeMap.entrySet()) {
                String activePropertyName = mapEntry.getKey().toString();
                List<Object> detachePropertyValue = null;
                if (itemCollection.hasItem(activePropertyName)) {
                    logger.warning("implodeEntity - " + activePropertyName + " contains inconsistent entries -  ID:" + aEntity.getId());
                    detachePropertyValue = itemCollection.getItemValue(activePropertyName);
                } else {
                    detachePropertyValue = new Vector<Object>();
                }
                List<Object> activePropertyValue = mapEntry.getValue();
                detachePropertyValue.addAll(activePropertyValue);
                itemCollection.replaceItemValue(activePropertyName, detachePropertyValue);
            }
        }
        if (this.disableOptimisticLocking.booleanValue()) {
            itemCollection.removeItem("$Version");
        } else {
            itemCollection.replaceItemValue("$Version", (Object)aEntity.getVersion());
        }
        return itemCollection;
    }

    private void removeDeprectedIndexValues(Entity aEntity, Collection<EntityIndex> entityIndexCache) {
        ArrayList<String> indexNames = new ArrayList<String>();
        for (EntityIndex entityIndex : entityIndexCache) {
            indexNames.add(entityIndex.getName());
        }
        ArrayList<TextItem> deprecatedTextItemList = new ArrayList<TextItem>();
        for (TextItem textItem : aEntity.getTextItems()) {
            if (indexNames.contains(textItem.itemName)) continue;
            deprecatedTextItemList.add(textItem);
        }
        for (TextItem textItem : deprecatedTextItemList) {
            this.manager.remove((Object)textItem);
            aEntity.getTextItems().remove(textItem);
            logger.warning("explodeEntity - fixed deprecated TextItem '" + textItem.itemName + "'");
        }
        ArrayList<IntegerItem> arrayList = new ArrayList<IntegerItem>();
        for (IntegerItem integerItem : aEntity.getIntegerItems()) {
            if (indexNames.contains(integerItem.itemName)) continue;
            arrayList.add(integerItem);
        }
        for (IntegerItem integerItem : arrayList) {
            this.manager.remove((Object)integerItem);
            aEntity.getIntegerItems().remove(integerItem);
            logger.warning("explodeEntity - fixed deprecated IntegerItem '" + integerItem.itemName + "'");
        }
        ArrayList<DoubleItem> arrayList2 = new ArrayList<DoubleItem>();
        for (DoubleItem aItem : aEntity.getDoubleItems()) {
            if (indexNames.contains(aItem.itemName)) continue;
            arrayList2.add(aItem);
        }
        for (DoubleItem aItem : arrayList2) {
            this.manager.remove((Object)aItem);
            aEntity.getDoubleItems().remove(aItem);
            logger.warning("explodeEntity - fixed deprecated DoubleItem '" + aItem.itemName + "'");
        }
        ArrayList<CalendarItem> arrayList3 = new ArrayList<CalendarItem>();
        for (CalendarItem aItem : aEntity.getCalendarItems()) {
            if (indexNames.contains(aItem.itemName)) continue;
            arrayList3.add(aItem);
        }
        for (CalendarItem aItem : arrayList3) {
            this.manager.remove((Object)aItem);
            aEntity.getCalendarItems().remove(aItem);
            logger.warning("explodeEntity - fixed deprecated CalendarItem '" + aItem.itemName + "'");
        }
    }

    private String optimizeQuery(String aQuery) throws InvalidAccessException {
        StringBuffer nameListBuf = new StringBuffer();
        String nameList = "";
        StringTokenizer st = new StringTokenizer(aQuery = aQuery.trim());
        if (st.countTokens() < 5) {
            throw new InvalidAccessException("[EntityService] Invalid query format: " + aQuery);
        }
        st.nextToken();
        String sDistinct = st.nextToken();
        if (!"distinct".equals(sDistinct.toLowerCase().trim())) {
            int iDisPos = aQuery.toLowerCase().indexOf("select") + 6;
            aQuery = aQuery.substring(0, iDisPos) + " DISTINCT" + aQuery.substring(iDisPos);
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            return aQuery;
        }
        List<String> auserNameList = this._getUserNameList();
        for (String auserName : auserNameList) {
            nameListBuf.append(",'" + auserName + "'");
        }
        nameListBuf.deleteCharAt(0);
        nameList = nameListBuf.toString();
        logger.fine("Optimized NameList = " + nameList);
        int iPos = 0;
        iPos = aQuery.toLowerCase().indexOf("join");
        if (iPos == -1) {
            iPos = aQuery.toLowerCase().indexOf("where");
        }
        if (iPos == -1) {
            iPos = aQuery.toLowerCase().indexOf("order by");
        }
        String firstPart = iPos == -1 ? aQuery : aQuery.substring(0, iPos - 1);
        firstPart = firstPart.trim();
        iPos = firstPart.length();
        String identifier = null;
        identifier = firstPart.substring(firstPart.lastIndexOf(32)).trim();
        if (identifier.endsWith(",")) {
            identifier = identifier.substring(0, identifier.length() - 1);
        }
        String aNewQuery = aQuery.substring(0, iPos);
        aNewQuery = aNewQuery + " LEFT JOIN " + identifier + ".readAccessList access807 ";
        aQuery = (aNewQuery = aNewQuery + aQuery.substring(iPos)).trim();
        int iWherePos = aQuery.toLowerCase().indexOf("where");
        if (iWherePos > -1) {
            aQuery = aNewQuery = aQuery.substring(0, iWherePos + 5) + " (access807.value IS NULL OR access807.value IN (" + nameList + ")) AND " + aQuery.substring(iWherePos + 6);
        } else {
            int iOrderPos = aQuery.toLowerCase().indexOf("order by");
            aNewQuery = iOrderPos > -1 ? aQuery.substring(0, iOrderPos - 1) + " WHERE (access807.value IS NULL OR access807.value IN (" + nameList + ")) " + aQuery.substring(iOrderPos) : aQuery + " WHERE (access807.value IS NULL OR access807.value IN(" + nameList + ")) ";
            aQuery = aNewQuery;
        }
        logger.fine("Optimized Query=" + aQuery);
        return aQuery;
    }

    @Deprecated
    private void updateAllEntityIndexFields(Collection<Entity> entityList, String newIndexField) {
        long count = 0L;
        logger.info("[EntityServiceBean] found " + entityList.size() + " existing entities. Starting update...");
        List<EntityIndex> entityIndexCache = this.readIndices();
        for (Entity activeEntity : entityList) {
            ItemCollection slimItemcol = new ItemCollection(activeEntity.getData());
            if (newIndexField != null && !slimItemcol.hasItem(newIndexField)) continue;
            try {
                ItemCollection itemcol = this.implodeEntity(activeEntity);
                ItemCollection slimItemCollection = new ItemCollection(itemcol.getAllItems());
                this.updateReadAccessList(slimItemCollection, activeEntity);
                this.updateWriteAccessList(slimItemCollection, activeEntity);
                this.explodeEntity(slimItemCollection, activeEntity, entityIndexCache);
                activeEntity.setData(slimItemCollection.getAllItems());
            }
            catch (Exception merex) {
                logger.info("[EntityServiceBean] Error updateAllEntityIndexFields for Entity : " + activeEntity.getId());
                merex.printStackTrace();
            }
            ++count;
        }
        logger.info("[EntityServiceBean] " + count + " effective updates");
        logger.info("[EntityServiceBean] index update completed");
    }
}

