/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.ScheduleExpression;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

@Stateless
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class WorkflowSchedulerService {
    public static final String TYPE_CONFIGURATION = "configuration";
    public static final String NAME = "org.imixs.workflow.scheduler";
    public static final int OFFSET_SECONDS = 0;
    public static final int OFFSET_MINUTES = 1;
    public static final int OFFSET_HOURS = 2;
    public static final int OFFSET_DAYS = 3;
    public static final int OFFSET_WORKDAYS = 4;
    private static Logger logger = Logger.getLogger(WorkflowSchedulerService.class.getName());
    @EJB
    WorkflowService workflowService;
    @EJB
    DocumentService documentService;
    @EJB
    ModelService modelService;
    @Resource
    TimerService timerService;
    @Resource
    SessionContext ctx;
    int iProcessWorkItems = 0;
    List<String> unprocessedIDs = null;

    public ItemCollection loadConfiguration() {
        List<ItemCollection> col;
        ItemCollection configItemCollection = null;
        String searchTerm = "(type:\"configuration\" AND txtname:\"org.imixs.workflow.scheduler\")";
        try {
            col = this.documentService.find(searchTerm, 2, 0);
        }
        catch (QueryException e) {
            logger.severe("loadConfiguration - invalid param: " + e.getMessage());
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        if (col.size() > 1) {
            String message = "loadConfiguration - more than on timer configuration found! Check configuration (type:\"configuration\" txtname:\"org.imixs.workflow.scheduler\") ";
            logger.severe(message);
            throw new InvalidAccessException("INVALID_ID", message);
        }
        if (col.size() == 1) {
            logger.fine("loading existing timer configuration...");
            configItemCollection = (ItemCollection)col.iterator().next();
        } else {
            logger.fine("creating new timer configuration...");
            configItemCollection = new ItemCollection();
            configItemCollection.replaceItemValue("type", (Object)TYPE_CONFIGURATION);
            configItemCollection.replaceItemValue("txtname", (Object)NAME);
            configItemCollection.replaceItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
        }
        configItemCollection = this.updateTimerDetails(configItemCollection);
        return configItemCollection;
    }

    public ItemCollection saveConfiguration(ItemCollection configItemCollection) throws AccessDeniedException {
        configItemCollection.replaceItemValue("type", (Object)TYPE_CONFIGURATION);
        configItemCollection.replaceItemValue("txtName", (Object)NAME);
        configItemCollection.replaceItemValue("$writeAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configItemCollection.replaceItemValue("$readAccess", (Object)"org.imixs.ACCESSLEVEL.MANAGERACCESS");
        configItemCollection = this.updateTimerDetails(configItemCollection);
        configItemCollection = this.documentService.save(configItemCollection);
        return configItemCollection;
    }

    public ItemCollection start() throws AccessDeniedException, ParseException {
        ItemCollection configItemCollection = this.loadConfiguration();
        Timer timer = null;
        if (configItemCollection == null) {
            return null;
        }
        String id = configItemCollection.getUniqueID();
        while (this.findTimer(id) != null) {
            this.findTimer(id).cancel();
        }
        String sConfiguation = configItemCollection.getItemValueString("txtConfiguration");
        if (!sConfiguation.isEmpty()) {
            timer = this.createTimerOnCalendar(configItemCollection);
        } else {
            int hours = configItemCollection.getItemValueInteger("hours");
            int minutes = configItemCollection.getItemValueInteger("minutes");
            long interval = (hours * 60 + minutes) * 60 * 1000;
            configItemCollection.replaceItemValue("numInterval", (Object)new Long(interval));
            timer = this.createTimerOnInterval(configItemCollection);
        }
        if (timer != null) {
            Calendar calNow = Calendar.getInstance();
            SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
            String msg = "started at " + dateFormatDE.format(calNow.getTime()) + " by " + this.ctx.getCallerPrincipal().getName();
            configItemCollection.replaceItemValue("statusmessage", (Object)msg);
            if (timer.isCalendarTimer()) {
                configItemCollection.replaceItemValue("Schedule", (Object)timer.getSchedule().toString());
            } else {
                configItemCollection.replaceItemValue("Schedule", (Object)"");
            }
            logger.info(configItemCollection.getItemValueString("txtName") + " started: " + id);
        }
        configItemCollection = this.saveConfiguration(configItemCollection);
        return configItemCollection;
    }

    public ItemCollection stop() throws AccessDeniedException {
        ItemCollection configItemCollection = this.loadConfiguration();
        String id = configItemCollection.getUniqueID();
        boolean found = false;
        while (this.findTimer(id) != null) {
            this.findTimer(id).cancel();
            found = true;
        }
        if (found) {
            Calendar calNow = Calendar.getInstance();
            SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
            String msg = "stopped at " + dateFormatDE.format(calNow.getTime()) + " by " + this.ctx.getCallerPrincipal().getName();
            configItemCollection.replaceItemValue("statusmessage", (Object)msg);
            logger.info(configItemCollection.getItemValueString("txtName") + " stopped: " + id);
        } else {
            configItemCollection.replaceItemValue("statusmessage", (Object)"");
        }
        configItemCollection = this.saveConfiguration(configItemCollection);
        return configItemCollection;
    }

    public boolean isRunning() {
        try {
            ItemCollection configItemCollection = this.loadConfiguration();
            if (configItemCollection == null) {
                return false;
            }
            return this.findTimer(configItemCollection.getUniqueID()) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean workItemInDue(ItemCollection doc, ItemCollection docActivity) {
        try {
            int iCompareType = -1;
            int iOffsetUnit = -1;
            int iOffset = 0;
            Date dateTimeCompare = null;
            String suniqueid = doc.getItemValueString("$uniqueid");
            String sDelayUnit = docActivity.getItemValueString("keyActivityDelayUnit");
            try {
                iOffsetUnit = Integer.parseInt(sDelayUnit);
                if (iOffsetUnit < 1 || iOffsetUnit > 4) {
                    logger.warning("error parsing delay in ActivityEntity " + docActivity.getItemValueInteger("numProcessID") + "." + docActivity.getItemValueInteger("numActivityID") + " : unsuported keyActivityDelayUnit=" + sDelayUnit);
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                logger.warning("error parsing delay in ActivityEntity " + docActivity.getItemValueInteger("numProcessID") + "." + docActivity.getItemValueInteger("numActivityID") + " :" + nfe.getMessage());
                return false;
            }
            iOffset = docActivity.getItemValueInteger("numActivityDelay");
            if ("1".equals(sDelayUnit)) {
                sDelayUnit = "minutes";
            }
            if ("2".equals(sDelayUnit)) {
                sDelayUnit = "hours";
            }
            if ("3".equals(sDelayUnit)) {
                sDelayUnit = "days";
            }
            if ("4".equals(sDelayUnit)) {
                sDelayUnit = "workdays";
            }
            logger.finest(suniqueid + " offset =" + iOffset + " " + sDelayUnit);
            iCompareType = Integer.parseInt(docActivity.getItemValueString("keyScheduledBaseObject"));
            Date dateTimeNow = Calendar.getInstance().getTime();
            switch (iCompareType) {
                case 1: {
                    logger.finest(suniqueid + ": CompareType = last process");
                    if (!doc.hasItem("timWorkflowLastAccess")) {
                        return false;
                    }
                    dateTimeCompare = doc.getItemValueDate("timWorkflowLastAccess");
                    logger.finest(suniqueid + ": timWorkflowLastAccess=" + dateTimeCompare);
                    dateTimeCompare = WorkflowSchedulerService.adjustBaseDate(dateTimeCompare, iOffsetUnit, iOffset);
                    if (dateTimeCompare != null) {
                        return dateTimeCompare.before(dateTimeNow);
                    }
                    return false;
                }
                case 2: {
                    logger.finest(suniqueid + ": CompareType = last modify");
                    dateTimeCompare = doc.getItemValueDate("$modified");
                    logger.finest(suniqueid + ": modified=" + dateTimeCompare);
                    dateTimeCompare = WorkflowSchedulerService.adjustBaseDate(dateTimeCompare, iOffsetUnit, iOffset);
                    if (dateTimeCompare != null) {
                        return dateTimeCompare.before(dateTimeNow);
                    }
                    return false;
                }
                case 3: {
                    logger.finest(suniqueid + ": CompareType = creation");
                    dateTimeCompare = doc.getItemValueDate("$created");
                    logger.fine(suniqueid + ": doc.getCreated() =" + dateTimeCompare);
                    dateTimeCompare = WorkflowSchedulerService.adjustBaseDate(dateTimeCompare, iOffsetUnit, iOffset);
                    if (dateTimeCompare != null) {
                        return dateTimeCompare.before(dateTimeNow);
                    }
                    return false;
                }
                case 4: {
                    String sNameOfField = docActivity.getItemValueString("keyTimeCompareField");
                    logger.finest(suniqueid + ": CompareType = field: '" + sNameOfField + "'");
                    if (!doc.hasItem(sNameOfField)) {
                        logger.finest("[WorkflowSchedulerService] " + suniqueid + ": CompareType =" + sNameOfField + " no value found!");
                        return false;
                    }
                    dateTimeCompare = doc.getItemValueDate(sNameOfField);
                    logger.finest(suniqueid + ": " + sNameOfField + "=" + dateTimeCompare);
                    dateTimeCompare = WorkflowSchedulerService.adjustBaseDate(dateTimeCompare, iOffsetUnit, iOffset);
                    if (dateTimeCompare != null) {
                        logger.finest(suniqueid + ": Compare " + dateTimeCompare + " <-> " + dateTimeNow);
                        if (dateTimeCompare.before(dateTimeNow)) {
                            logger.finest(suniqueid + " isInDue!");
                        }
                        return dateTimeCompare.before(dateTimeNow);
                    }
                    return false;
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Calendar addWorkDays(Calendar baseDate, int days) {
        Calendar resultDate = null;
        Calendar workCal = Calendar.getInstance();
        workCal.setTime(baseDate.getTime());
        int currentWorkDay = workCal.get(7);
        if (currentWorkDay == 7) {
            workCal.add(5, days < 0 ? -1 : 2);
            currentWorkDay = workCal.get(7);
        }
        if (currentWorkDay == 1) {
            workCal.add(5, days < 0 ? -2 : 1);
            currentWorkDay = workCal.get(7);
        }
        if (currentWorkDay >= 2 && currentWorkDay <= 6) {
            boolean inCurrentWeek = false;
            if (days > 0) {
                inCurrentWeek = currentWorkDay + days < 7;
            } else {
                boolean bl = inCurrentWeek = currentWorkDay + days > 1;
            }
            if (inCurrentWeek) {
                workCal.add(5, days);
                resultDate = workCal;
            } else {
                int totalDays = 0;
                int daysInCurrentWeek = 0;
                if (days > 0) {
                    daysInCurrentWeek = 7 - currentWorkDay;
                    totalDays = daysInCurrentWeek + 2;
                } else {
                    daysInCurrentWeek = -(currentWorkDay - 1);
                    totalDays = daysInCurrentWeek - 2;
                }
                int restTotalDays = days - daysInCurrentWeek;
                int x = restTotalDays / 5;
                workCal.add(5, totalDays += restTotalDays + x * 2);
                resultDate = workCal;
            }
        }
        if (resultDate != null) {
            logger.finest("addWorkDays (" + baseDate.getTime() + ") + " + days + " = (" + resultDate.getTime() + ")");
        }
        return resultDate;
    }

    @Timeout
    void runTimer(Timer timer) throws AccessDeniedException {
        ItemCollection configItemCollection;
        block9: {
            configItemCollection = this.loadConfiguration();
            logger.info(" started....");
            if (!this.isImixsDayOfWeek(configItemCollection)) {
                logger.info("runTimer skipped because today is no imixsDayOfWeek");
                return;
            }
            configItemCollection.replaceItemValue("datLastRun", (Object)new Date());
            this.iProcessWorkItems = 0;
            this.unprocessedIDs = new ArrayList<String>();
            try {
                List<String> modelVersions = this.modelService.getVersions();
                for (String version : modelVersions) {
                    logger.info("processing ModelVersion: " + version);
                    Collection<ItemCollection> colScheduledActivities = this.findScheduledActivities(version);
                    logger.info(" " + colScheduledActivities.size() + " scheduled activityEntities found in ModelVersion: " + version);
                    for (ItemCollection aactivityEntity : colScheduledActivities) {
                        this.processWorkListByActivityEntity(aactivityEntity);
                    }
                }
            }
            catch (Exception e) {
                logger.severe(" error processing worklist: " + e.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block9;
                e.printStackTrace();
            }
        }
        logger.info("finished successfull");
        logger.info(this.iProcessWorkItems + " workitems processed");
        if (this.unprocessedIDs.size() > 0) {
            logger.warning(this.unprocessedIDs.size() + " workitems could be processed!");
            for (String aid : this.unprocessedIDs) {
                logger.warning("          " + aid);
            }
        }
        Date endDate = configItemCollection.getItemValueDate("datstop");
        String sTimerID = configItemCollection.getItemValueString("$uniqueid");
        configItemCollection.replaceItemValue("numWorkItemsProcessed", (Object)this.iProcessWorkItems);
        configItemCollection.replaceItemValue("numWorkItemsUnprocessed", (Object)this.unprocessedIDs.size());
        String sConfiguation = configItemCollection.getItemValueString("txtConfiguration");
        if (sConfiguation.isEmpty()) {
            Calendar calNow = Calendar.getInstance();
            if (endDate != null && calNow.getTime().after(endDate)) {
                timer.cancel();
                System.out.println("Timeout - sevice stopped: " + sTimerID);
                SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
                String msg = "stopped at " + dateFormatDE.format(calNow.getTime()) + " by datstop=" + dateFormatDE.format(endDate);
                configItemCollection.replaceItemValue("statusmessage", (Object)msg);
            }
        }
        configItemCollection = this.saveConfiguration(configItemCollection);
    }

    Timer createTimerOnInterval(ItemCollection configItemCollection) {
        Date startDate = configItemCollection.getItemValueDate("datstart");
        Date endDate = configItemCollection.getItemValueDate("datstop");
        long interval = configItemCollection.getItemValueInteger("numInterval");
        if (startDate == null) {
            startDate = new Date();
        }
        if (endDate != null) {
            Calendar calStart = Calendar.getInstance();
            calStart.setTime(startDate);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(endDate);
            if (calStart.after(calEnd)) {
                logger.warning(configItemCollection.getItemValueString("txtName") + " stop-date (" + startDate + ") is before start-date (" + endDate + "). Timer will not be started!");
                return null;
            }
        }
        Timer timer = null;
        timer = this.timerService.createTimer(startDate, interval, (Serializable)((Object)configItemCollection.getUniqueID()));
        return timer;
    }

    Timer createTimerOnCalendar(ItemCollection configItemCollection) throws ParseException {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)((Object)configItemCollection.getUniqueID()));
        ScheduleExpression scheduerExpression = new ScheduleExpression();
        List calendarConfiguation = configItemCollection.getItemValue("txtConfiguration");
        for (String confgEntry : calendarConfiguation) {
            Date convertedDate;
            SimpleDateFormat dateFormat;
            if (confgEntry.startsWith("second=")) {
                scheduerExpression.second(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("minute=")) {
                scheduerExpression.minute(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("hour=")) {
                scheduerExpression.hour(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfWeek=")) {
                scheduerExpression.dayOfWeek(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfMonth=")) {
                scheduerExpression.dayOfMonth(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("month=")) {
                scheduerExpression.month(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("year=")) {
                scheduerExpression.year(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("timezone=")) {
                scheduerExpression.timezone(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("start=")) {
                dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
                scheduerExpression.start(convertedDate);
            }
            if (!confgEntry.startsWith("end=")) continue;
            dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
            scheduerExpression.end(convertedDate);
        }
        Timer timer = this.timerService.createCalendarTimer(scheduerExpression, timerConfig);
        return timer;
    }

    Collection<ItemCollection> findScheduledActivities(String aModelVersion) throws Exception {
        Vector<ItemCollection> vectorActivities = new Vector<ItemCollection>();
        List colProcessList = null;
        colProcessList = this.modelService.getModel(aModelVersion).findAllTasks();
        for (ItemCollection aprocessentity : colProcessList) {
            int processid = aprocessentity.getItemValueInteger("numprocessid");
            logger.fine("Analyse processentity '" + processid + "'");
            List aActivityList = this.modelService.getModel(aModelVersion).findAllEventsByTask(processid);
            for (ItemCollection aactivityEntity : aActivityList) {
                logger.fine("Analyse acitity '" + aactivityEntity.getItemValueString("txtname") + "'");
                if (!"1".equals(aactivityEntity.getItemValueString("keyScheduledActivity"))) continue;
                vectorActivities.add(aactivityEntity);
            }
        }
        return vectorActivities;
    }

    Timer findTimer(String id) {
        Timer timer = null;
        for (Object obj : this.timerService.getTimers()) {
            Timer atimer = (Timer)obj;
            String timerID = atimer.getInfo().toString();
            if (!id.equals(timerID)) continue;
            if (timer != null) {
                logger.severe("more then one timer with id " + id + " was found!");
            }
            timer = atimer;
        }
        return timer;
    }

    void processWorkListByActivityEntity(ItemCollection activityEntity) throws Exception {
        int iProcessID = activityEntity.getItemValueInteger("numprocessid");
        int iActivityID = activityEntity.getItemValueInteger("numActivityID");
        String sModelVersion = activityEntity.getItemValueString("$modelversion");
        logger.info("processing " + iProcessID + "." + iActivityID + " (" + sModelVersion + ") ...");
        String searchTerm = "(type:\"workitem\" AND $processid:\"" + iProcessID + "\" AND $modelversion:\"" + sModelVersion + "\")";
        logger.fine("select: " + searchTerm);
        List<ItemCollection> worklist = this.documentService.find(searchTerm, 1000, 0);
        logger.fine("[WorkflowSchedulerService] " + worklist.size() + " workitems found");
        for (ItemCollection workitem : worklist) {
            if (!WorkflowSchedulerService.workItemInDue(workitem, activityEntity)) continue;
            String sID = workitem.getItemValueString("$uniqueid");
            logger.fine("workitem " + sID + "is in due");
            workitem.replaceItemValue("$activityid", (Object)iActivityID);
            try {
                logger.finest("getBusinessObject.....");
                ((WorkflowSchedulerService)this.ctx.getBusinessObject(WorkflowSchedulerService.class)).processSingleWorkitem(workitem);
                ++this.iProcessWorkItems;
            }
            catch (Exception e) {
                logger.warning("error processing workitem: " + sID);
                if (logger.isLoggable(Level.FINEST)) {
                    e.printStackTrace();
                }
                this.unprocessedIDs.add(sID);
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void processSingleWorkitem(ItemCollection aWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException {
        this.workflowService.processWorkItem(aWorkitem);
    }

    private ItemCollection updateTimerDetails(ItemCollection configuration) {
        if (configuration == null) {
            return configuration;
        }
        String id = configuration.getUniqueID();
        try {
            Timer timer = this.findTimer(id);
            if (timer != null) {
                configuration.replaceItemValue("nextTimeout", (Object)timer.getNextTimeout());
                configuration.replaceItemValue("timeRemaining", (Object)timer.getTimeRemaining());
            } else {
                configuration.removeItem("nextTimeout");
                configuration.removeItem("timeRemaining");
            }
        }
        catch (Exception e) {
            logger.warning("unable to updateTimerDetails: " + e.getMessage());
            configuration.removeItem("nextTimeout");
            configuration.removeItem("timeRemaining");
        }
        return configuration;
    }

    private boolean isImixsDayOfWeek(ItemCollection configItemCollection) {
        List calendarConfiguation = configItemCollection.getItemValue("txtConfiguration");
        for (String confgEntry : calendarConfiguation) {
            if (!confgEntry.startsWith("imixsDayOfWeek=")) continue;
            logger.info(confgEntry);
            try {
                String dayValue = confgEntry.substring(confgEntry.indexOf(61) + 1);
                int iStartDay = 0;
                int iEndDay = 0;
                int iSeparator = dayValue.indexOf(45);
                if (iSeparator > -1) {
                    iStartDay = Integer.valueOf(dayValue.substring(0, iSeparator));
                    iEndDay = Integer.valueOf(dayValue.substring(iSeparator + 1));
                } else {
                    iEndDay = iStartDay = Integer.valueOf(dayValue).intValue();
                }
                Calendar now = Calendar.getInstance();
                now.setTime(new Date());
                int iDay = now.get(7);
                if (--iDay < iStartDay || iDay > iEndDay) {
                    logger.info("imixsDayOfWeek=false");
                    return false;
                }
                logger.info("imixsDayOfWeek=true");
                return true;
            }
            catch (Exception e) {
                logger.warning("imixsDayOfWeek not parseable!");
            }
        }
        return true;
    }

    private static Date adjustBaseDate(Date baseDate, int offsetUnit, int offset) {
        if (baseDate != null) {
            if (offsetUnit == 4) {
                Calendar baseCal = Calendar.getInstance();
                baseCal.setTime(baseDate);
                return WorkflowSchedulerService.addWorkDays(baseCal, offset).getTime();
            }
            if (offsetUnit == 1) {
                offset *= 60;
            } else if (offsetUnit == 2) {
                offset *= 3600;
            } else if (offsetUnit == 3) {
                offset *= 86400;
            }
            Calendar calTimeCompare = Calendar.getInstance();
            calTimeCompare.setTime(baseDate);
            calTimeCompare.add(13, offset);
            return calTimeCompare.getTime();
        }
        return null;
    }
}

