/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;

public class ApplicationPlugin
extends AbstractPlugin {
    public static final String PROCESS_UNDEFINED = "PROCESS_UNDEFINED";
    ItemCollection documentContext;
    private String sEditorID;
    private String sType;
    private String sImageURL;
    private String sStatus;
    private String sGroup;
    private String sAbstract;
    private String sSummary;
    private static Logger logger = Logger.getLogger(ApplicationPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.sEditorID = null;
        this.sImageURL = null;
        this.sAbstract = null;
        this.sSummary = null;
        int iNextProcessID = adocumentActivity.getItemValueInteger("numNextProcessID");
        ItemCollection itemColNextProcess = null;
        String aModelVersion = adocumentActivity.getItemValueString("$modelVersion");
        try {
            itemColNextProcess = this.getCtx().getModelManager().getModel(aModelVersion).getTask(iNextProcessID);
        }
        catch (ModelException e) {
            logger.warning("Warning - Task '" + iNextProcessID + "' is not defined by model version '" + aModelVersion + "' : " + e.getMessage());
            return this.documentContext;
        }
        this.sEditorID = itemColNextProcess.getItemValueString("txtEditorID");
        this.sImageURL = itemColNextProcess.getItemValueString("txtImageURL");
        this.sStatus = itemColNextProcess.getItemValueString("txtname");
        this.sGroup = itemColNextProcess.getItemValueString("txtworkflowgroup");
        this.sType = itemColNextProcess.getItemValueString("txttype");
        this.sAbstract = itemColNextProcess.getItemValueString("txtworkflowabstract");
        if (!"".equals(this.sAbstract)) {
            this.sAbstract = this.replaceDynamicValues(this.sAbstract, this.documentContext);
        }
        this.sSummary = itemColNextProcess.getItemValueString("txtworkflowsummary");
        if (!"".equals(this.sSummary)) {
            this.sSummary = this.replaceDynamicValues(this.sSummary, this.documentContext);
        }
        this.documentContext.replaceItemValue("txtWorkflowStatus", (Object)this.sStatus);
        this.documentContext.replaceItemValue("txtworkflowgroup", (Object)this.sGroup);
        if (this.sEditorID != null && !"".equals(this.sEditorID)) {
            this.documentContext.replaceItemValue("txtWorkflowEditorID", (Object)this.sEditorID);
        }
        if (this.sImageURL != null && !"".equals(this.sImageURL)) {
            this.documentContext.replaceItemValue("txtWorkflowImageURL", (Object)this.sImageURL);
        }
        if (this.sType != null && !"".equals(this.sType)) {
            this.documentContext.replaceItemValue("type", (Object)this.sType);
        }
        if (this.sAbstract != null) {
            this.documentContext.replaceItemValue("txtworkflowabstract", (Object)this.sAbstract);
        }
        if (this.sSummary != null) {
            this.documentContext.replaceItemValue("txtworkflowsummary", (Object)this.sSummary);
        }
        return this.documentContext;
    }
}

