/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.PropertyService;
import org.imixs.workflow.exceptions.IndexException;

@Singleton
public class LuceneUpdateService {
    protected static final String DEFAULT_ANALYSER = "org.apache.lucene.analysis.standard.ClassicAnalyzer";
    protected static final String DEFAULT_INDEX_DIRECTORY = "imixs-workflow-index";
    protected static final String ANONYMOUS = "ANONYMOUS";
    private List<String> searchFieldList = null;
    private List<String> indexFieldListAnalyse = null;
    private List<String> indexFieldListNoAnalyse = null;
    private String indexDirectoryPath = null;
    private String analyserClass = null;
    private Properties properties = null;
    private static List<String> DEFAULT_SEARCH_FIELD_LIST = Arrays.asList("txtworkflowsummary", "txtworkflowabstract");
    private static List<String> DEFAULT_NOANALYSE_FIELD_LIST = Arrays.asList("$modelversion", "$processid", "$workitemid", "$uniqueidref", "type", "$writeaccess", "$modified", "$created", "namcreator", "txtworkflowgroup", "txtname", "namowner", "txtworkitemref");
    @EJB
    PropertyService propertyService;
    private static Logger logger = Logger.getLogger(LuceneUpdateService.class.getName());

    @PostConstruct
    void init() {
        String sName;
        StringTokenizer st;
        this.properties = this.propertyService.getProperties();
        this.indexDirectoryPath = this.properties.getProperty("lucence.indexDir", DEFAULT_INDEX_DIRECTORY);
        this.analyserClass = this.properties.getProperty("lucence.analyzerClass", DEFAULT_ANALYSER);
        String sFulltextFieldList = this.properties.getProperty("lucence.fulltextFieldList");
        String sIndexFieldListAnalyse = this.properties.getProperty("lucence.indexFieldListAnalyze");
        String sIndexFieldListNoAnalyse = this.properties.getProperty("lucence.indexFieldListNoAnalyze");
        logger.finest("lucene IndexDir=" + this.indexDirectoryPath);
        logger.finest("lucene FulltextFieldList=" + sFulltextFieldList);
        logger.finest("lucene IndexFieldListAnalyse=" + sIndexFieldListAnalyse);
        logger.finest("lucene IndexFieldListNoAnalyse=" + sIndexFieldListNoAnalyse);
        this.searchFieldList = new ArrayList<String>();
        this.searchFieldList.addAll(DEFAULT_SEARCH_FIELD_LIST);
        if (sFulltextFieldList != null && !sFulltextFieldList.isEmpty()) {
            st = new StringTokenizer(sFulltextFieldList, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName) || this.searchFieldList.contains(sName)) continue;
                this.searchFieldList.add(sName);
            }
        }
        this.indexFieldListAnalyse = new ArrayList<String>();
        if (sIndexFieldListAnalyse != null && !sIndexFieldListAnalyse.isEmpty()) {
            st = new StringTokenizer(sIndexFieldListAnalyse, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
                this.indexFieldListAnalyse.add(sName);
            }
        }
        this.indexFieldListNoAnalyse = new ArrayList<String>();
        this.indexFieldListNoAnalyse.addAll(DEFAULT_NOANALYSE_FIELD_LIST);
        if (sIndexFieldListNoAnalyse != null && !sIndexFieldListNoAnalyse.isEmpty()) {
            st = new StringTokenizer(sIndexFieldListNoAnalyse, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase();
                if (this.indexFieldListNoAnalyse.contains(sName)) continue;
                this.indexFieldListNoAnalyse.add(sName);
            }
        }
    }

    public ItemCollection getConfiguration() {
        ItemCollection config = new ItemCollection();
        config.replaceItemValue("lucence.indexDir", (Object)this.indexDirectoryPath);
        config.replaceItemValue("lucence.analyzerClass", (Object)this.analyserClass);
        config.replaceItemValue("lucence.fulltextFieldList", this.searchFieldList);
        config.replaceItemValue("lucence.indexFieldListAnalyze", this.indexFieldListAnalyse);
        config.replaceItemValue("lucence.indexFieldListNoAnalyze", this.indexFieldListNoAnalyse);
        return config;
    }

    public void updateDocument(ItemCollection documentContext) {
        ArrayList<ItemCollection> documents = new ArrayList<ItemCollection>();
        documents.add(documentContext);
        this.updateDocuments(documents);
    }

    public void updateDocuments(Collection<ItemCollection> documents) {
        IndexWriter awriter = null;
        long ltime = System.currentTimeMillis();
        try {
            awriter = this.createIndexWriter();
            for (ItemCollection workitem : documents) {
                Term term = new Term("$uniqueid", workitem.getItemValueString("$uniqueid"));
                logger.finest("lucene add/update workitem '" + workitem.getItemValueString("$uniqueid") + "' to index...");
                awriter.updateDocument(term, (Iterable)this.createDocument(workitem));
            }
        }
        catch (IOException luceneEx) {
            logger.warning("lucene error: " + luceneEx.getMessage());
            throw new IndexException("INVALID_INDEX", "Unable to update lucene search index", (Exception)luceneEx);
        }
        finally {
            if (awriter != null) {
                logger.finest("lucene close IndexWriter...");
                try {
                    awriter.close();
                }
                catch (CorruptIndexException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)e);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("lucene update worklist in " + (System.currentTimeMillis() - ltime) + " ms (" + documents.size() + " worktiems total)");
        }
    }

    public void removeDocument(String uniqueID) {
        IndexWriter awriter = null;
        long ltime = System.currentTimeMillis();
        try {
            awriter = this.createIndexWriter();
            Term term = new Term("$uniqueid", uniqueID);
            awriter.deleteDocuments(new Term[]{term});
        }
        catch (CorruptIndexException e) {
            throw new IndexException("INVALID_INDEX", "Unable to remove workitem '" + uniqueID + "' from search index", (Exception)((Object)e));
        }
        catch (LockObtainFailedException e) {
            throw new IndexException("INVALID_INDEX", "Unable to remove workitem '" + uniqueID + "' from search index", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new IndexException("INVALID_INDEX", "Unable to remove workitem '" + uniqueID + "' from search index", (Exception)e);
        }
        finally {
            if (awriter != null) {
                logger.finest("lucene close IndexWriter...");
                try {
                    awriter.close();
                }
                catch (CorruptIndexException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)e);
                }
            }
        }
        logger.fine("lucene removeDocument in " + (System.currentTimeMillis() - ltime) + " ms");
    }

    IndexWriter createIndexWriter() throws IOException {
        FSDirectory indexDir = FSDirectory.open((Path)Paths.get(this.indexDirectoryPath, new String[0]));
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new ClassicAnalyzer());
        return new IndexWriter((Directory)indexDir, indexWriterConfig);
    }

    Document createDocument(ItemCollection aworkitem) {
        String sValue = null;
        Document doc = new Document();
        String sContent = "";
        for (String aFieldname : this.searchFieldList) {
            sValue = "";
            List vValues = aworkitem.getItemValue(aFieldname);
            if (vValues.size() == 0) continue;
            for (Object o : vValues) {
                if (o == null) continue;
                if (o instanceof Calendar || o instanceof Date) {
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
                    String sDateValue = o instanceof Calendar ? dateformat.format(((Calendar)o).getTime()) : dateformat.format((Date)o);
                    sValue = sValue + sDateValue + ",";
                    continue;
                }
                sValue = sValue + o.toString() + ",";
            }
            if (sValue == null) continue;
            logger.finest("lucene add SearchField: " + aFieldname + "=" + sValue);
            sContent = sContent + sValue + ",";
        }
        logger.finest("add lucene field content=" + sContent);
        doc.add((IndexableField)new TextField("content", sContent, Field.Store.NO));
        for (String aFieldname : this.indexFieldListAnalyse) {
            this.addItemValues(doc, aworkitem, aFieldname, true);
        }
        for (String aFieldname : this.indexFieldListNoAnalyse) {
            this.addItemValues(doc, aworkitem, aFieldname, false);
        }
        doc.add((IndexableField)new StringField("$uniqueid", aworkitem.getItemValueString("$uniqueid"), Field.Store.YES));
        List vReadAccess = aworkitem.getItemValue("$readAccess");
        if (vReadAccess.size() == 0 || vReadAccess.size() == 1 && "".equals(((String)vReadAccess.get(0)).toString())) {
            sValue = ANONYMOUS;
            doc.add((IndexableField)new StringField("$readaccess", sValue, Field.Store.NO));
        } else {
            sValue = "";
            for (String sReader : vReadAccess) {
                doc.add((IndexableField)new StringField("$readaccess", sReader, Field.Store.NO));
            }
        }
        return doc;
    }

    void addItemValues(Document doc, ItemCollection workitem, String itemName, boolean analyzeValue) {
        String sValue = null;
        List vValues = workitem.getItemValue(itemName);
        if (vValues.size() == 0) {
            return;
        }
        if (vValues.get(0) == null) {
            return;
        }
        boolean firstValue = true;
        for (Object singleValue : vValues) {
            if (singleValue instanceof Calendar || singleValue instanceof Date) {
                SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
                String sDateValue = singleValue instanceof Calendar ? dateformat.format(((Calendar)singleValue).getTime()) : dateformat.format((Date)singleValue);
                sValue = sDateValue;
            } else {
                sValue = singleValue.toString();
            }
            logger.finest("lucene add IndexField (analyse=" + analyzeValue + "): " + itemName + "=" + sValue);
            if (analyzeValue) {
                doc.add((IndexableField)new TextField(itemName, sValue, Field.Store.NO));
            } else {
                doc.add((IndexableField)new StringField(itemName, sValue, Field.Store.NO));
                if (firstValue) {
                    doc.add((IndexableField)new SortedDocValuesField(itemName, new BytesRef((CharSequence)sValue)));
                }
            }
            firstValue = false;
        }
    }
}

