/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class RulePlugin
extends AbstractPlugin {
    public static final String INVALID_SCRIPT = "INVALID_SCRIPT";
    public static final String VALIDATION_ERROR = "VALIDATION_ERROR";
    private static Logger logger = Logger.getLogger(RulePlugin.class.getName());
    private static final HashSet<Class<?>> BASIC_OBJECT_TYPES = RulePlugin.getBasicObjectTypes();

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        ScriptEngine engine = this.evaluateBusinessRule(adocumentContext, adocumentActivity);
        if (engine != null) {
            Double d;
            Long lNextTask;
            Double d2;
            Long followUpActivity;
            ItemCollection result = this.convertScriptVariableToItemCollection(engine, "result");
            Boolean isValidActivity = true;
            if (result != null && result.hasItem("isValid")) {
                isValidActivity = result.getItemValueBoolean("isValid");
                result.removeItem("isValid");
            } else {
                isValidActivity = (Boolean)engine.get("isValid");
            }
            if (isValidActivity != null && !isValidActivity.booleanValue()) {
                String sErrorCode = VALIDATION_ERROR;
                Object oErrorCode = null;
                if (result != null && result.hasItem("errorCode")) {
                    oErrorCode = result.getItemValueString("errorCode");
                    result.removeItem("errorCode");
                } else {
                    oErrorCode = engine.get("errorCode");
                }
                if (oErrorCode != null && oErrorCode instanceof String) {
                    sErrorCode = oErrorCode.toString();
                }
                Object[] params = null;
                if (result != null && result.hasItem("errorMessage")) {
                    params = result.getItemValue("errorMessage").toArray();
                    result.removeItem("errorMessage");
                } else {
                    params = this.evaluateNativeScriptArray(engine, "errorMessage");
                }
                throw new PluginException(RulePlugin.class.getName(), sErrorCode, "BusinessRule: validation failed - ErrorCode=" + sErrorCode, params);
            }
            this.updateEvent(engine, adocumentActivity);
            Object followUp = null;
            if (result != null && result.hasItem("followUp")) {
                followUp = result.getItemValueString("followUp");
                result.removeItem("followUp");
            } else {
                followUp = engine.get("followUp");
            }
            if (followUp != null && (followUpActivity = Long.valueOf((d2 = Double.valueOf(followUp.toString())).longValue())) != null && followUpActivity > 0L) {
                adocumentActivity.replaceItemValue("keyFollowUp", (Object)"1");
                adocumentActivity.replaceItemValue("numNextActivityID", (Object)followUpActivity);
            }
            Object nextTask = null;
            if (result != null && result.hasItem("nextTask")) {
                nextTask = result.getItemValueString("nextTask");
                result.removeItem("nextTask");
            } else {
                nextTask = engine.get("nextTask");
            }
            if (nextTask != null && (lNextTask = Long.valueOf((d = Double.valueOf(nextTask.toString())).longValue())) != null && lNextTask > 0L) {
                adocumentActivity.replaceItemValue("numNextProcessID", (Object)lNextTask);
            }
            if (result != null) {
                for (Map.Entry entry : result.getAllItems().entrySet()) {
                    String itemName = (String)entry.getKey();
                    if (itemName.startsWith("$")) continue;
                    logger.fine("Update item '" + itemName + "'");
                    adocumentContext.replaceItemValue(itemName, entry.getValue());
                }
            }
            return adocumentContext;
        }
        return adocumentContext;
    }

    public ScriptEngine evaluateBusinessRule(ItemCollection documentContext, ItemCollection activity) throws PluginException {
        String script = activity.getItemValueString("txtBusinessRule");
        if ("".equals(script.trim())) {
            return null;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        String sEngineType = activity.getItemValueString("txtBusinessRuleEngine");
        if ("".equals(sEngineType)) {
            sEngineType = "javascript";
        }
        ScriptEngine engine = manager.getEngineByName(sEngineType);
        engine.put("event", this.convertItemCollection(activity));
        engine.put("workitem", this.convertItemCollection(documentContext));
        logger.fine("SCRIPT:" + script);
        try {
            engine.eval(script);
        }
        catch (ScriptException e) {
            throw new PluginException(RulePlugin.class.getSimpleName(), INVALID_SCRIPT, "BusinessRule contains invalid script:" + e.getMessage(), (Exception)e);
        }
        return engine;
    }

    public Object[] evaluateNativeScriptArray(ScriptEngine engine, String expression) {
        Object[] params = null;
        if (engine == null) {
            logger.severe("RulePlugin evaluateScritpObject error: no script engine! - call run()");
            return null;
        }
        Object objectResult = engine.get(expression);
        if (objectResult != null && objectResult instanceof String) {
            params = new String[]{objectResult.toString()};
            return params;
        }
        try {
            String jsNashorn = " if (typeof importClass != 'function') { load('nashorn:mozilla_compat.js');}";
            String jsCode = "importPackage(java.util);var _evaluateScriptParam = Arrays.asList(" + expression + "); ";
            engine.eval(jsNashorn + jsCode);
            List resultList = (List)engine.get("_evaluateScriptParam");
            if (resultList == null) {
                return null;
            }
            if ("[undefined]".equals(resultList.toString())) {
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("evalueateScript object to Java");
                for (Object val : resultList) {
                    logger.fine(val.toString());
                }
            }
            return resultList.toArray();
        }
        catch (ScriptException se) {
            logger.fine("[RulePlugin] error evaluating " + expression + " - " + se.getMessage());
            return null;
        }
    }

    private void updateEvent(ScriptEngine engine, ItemCollection event) {
        Map<String, Object[]> orginalActivity = this.convertItemCollection(event);
        Map scriptActivity = (Map)engine.get("event");
        for (Map.Entry entry : scriptActivity.entrySet()) {
            Object[] oActivity;
            String expression = "event.get('" + (String)entry.getKey() + "')";
            Object[] oScript = this.evaluateNativeScriptArray(engine, expression);
            if (oScript == null || (oActivity = orginalActivity.get(entry.getKey())) == null || Arrays.deepEquals(oScript, oActivity)) continue;
            logger.fine("update event property " + (String)entry.getKey());
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(oScript));
            event.replaceItemValue((String)entry.getKey(), list);
        }
    }

    private ItemCollection convertScriptVariableToItemCollection(ScriptEngine engine, String variable) {
        ItemCollection result = null;
        Map scriptResult = (Map)engine.get(variable);
        if (scriptResult != null && scriptResult.entrySet().size() > 0) {
            result = new ItemCollection();
            for (Map.Entry entry : scriptResult.entrySet()) {
                if (RulePlugin.isBasicObjectType(entry.getValue().getClass())) {
                    logger.fine("adding " + variable + " property " + (String)entry.getKey());
                    ArrayList list = new ArrayList();
                    list.add(entry.getValue());
                    result.replaceItemValue((String)entry.getKey(), list);
                    continue;
                }
                String expression = "result['" + (String)entry.getKey() + "']";
                Object[] oScript = this.evaluateNativeScriptArray(engine, expression);
                if (oScript == null) continue;
                logger.fine("adding " + variable + " property " + (String)entry.getKey());
                ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(oScript));
                result.replaceItemValue((String)entry.getKey(), list);
            }
        }
        return result;
    }

    private Map<String, Object[]> convertItemCollection(ItemCollection itemCol) {
        HashMap<String, Object[]> result = new HashMap<String, Object[]>();
        Map itemList = itemCol.getAllItems();
        for (Map.Entry entry : itemList.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase();
            List value = (List)entry.getValue();
            if (value.size() <= 0 || !RulePlugin.isBasicObjectType(value.get(0).getClass())) continue;
            result.put(key, value.toArray());
        }
        return result;
    }

    private static boolean isBasicObjectType(Class<?> clazz) {
        return BASIC_OBJECT_TYPES.contains(clazz);
    }

    private static HashSet<Class<?>> getBasicObjectTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        ret.add(BigDecimal.class);
        ret.add(BigInteger.class);
        ret.add(String.class);
        ret.add(Object.class);
        ret.add(Date.class);
        ret.add(Calendar.class);
        ret.add(GregorianCalendar.class);
        return ret;
    }
}

