/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.adminp.AdminPService;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.engine.jpa.EventLog;
import org.imixs.workflow.engine.lucene.LuceneItemAdapter;
import org.imixs.workflow.exceptions.IndexException;

@Singleton
public class LuceneUpdateService {
    protected static final String DEFAULT_ANALYSER = "org.apache.lucene.analysis.standard.ClassicAnalyzer";
    protected static final String DEFAULT_INDEX_DIRECTORY = "imixs-workflow-index";
    protected static final String ANONYMOUS = "ANONYMOUS";
    public static final String EVENTLOG_TOPIC_ADD = "lucene.add";
    public static final String EVENTLOG_TOPIC_REMOVE = "lucene.remove";
    protected static final int EVENTLOG_ENTRY_FLUSH_COUNT = 16;
    @Inject
    @ConfigProperty(name="lucence.indexDir", defaultValue="imixs-workflow-index")
    private String luceneIndexDir;
    @Inject
    @ConfigProperty(name="lucence.analyzerClass", defaultValue="org.apache.lucene.analysis.standard.ClassicAnalyzer")
    private String luceneAnalyserClass;
    @Inject
    @ConfigProperty(name="lucence.fulltextFieldList", defaultValue="")
    private String luceneFulltextFieldList;
    @Inject
    @ConfigProperty(name="lucence.indexFieldListAnalyze", defaultValue="")
    private String luceneIndexFieldListAnalyse;
    @Inject
    @ConfigProperty(name="lucence.indexFieldListNoAnalyze", defaultValue="")
    private String luceneIndexFieldListNoAnalyse;
    @Inject
    @ConfigProperty(name="lucence.indexFieldListStore", defaultValue="")
    private String luceneIndexFieldListStore;
    private List<String> searchFieldList = null;
    private List<String> indexFieldListAnalyse = null;
    private List<String> indexFieldListNoAnalyse = null;
    private List<String> indexFieldListStore = null;
    private static List<String> DEFAULT_SEARCH_FIELD_LIST = Arrays.asList("$workflowsummary", "$workflowabstract");
    private static List<String> DEFAULT_NOANALYSE_FIELD_LIST = Arrays.asList("$modelversion", "$taskid", "$processid", "$workitemid", "$uniqueidref", "type", "$writeaccess", "$modified", "$created", "namcreator", "$creator", "$editor", "$lasteditor", "$workflowgroup", "$workflowstatus", "txtworkflowgroup", "name", "txtname", "$owner", "namowner", "txtworkitemref", "$uniqueidsource", "$uniqueidversions", "$lasttask", "$lastevent", "$lasteventdate");
    private static List<String> DEFAULT_STORE_FIELD_LIST = Arrays.asList("type", "$taskid", "$writeaccess", "$workflowsummary", "$workflowabstract", "$workflowgroup", "$workflowstatus", "$modified", "$created", "$lasteventdate", "$creator", "$editor", "$lasteditor", "$owner", "namowner");
    @EJB
    private EventLogService eventLogService;
    @Inject
    private LuceneItemAdapter luceneItemAdapter;
    @EJB
    private AdminPService adminPService;
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    private static Logger logger = Logger.getLogger(LuceneUpdateService.class.getName());

    @PostConstruct
    void init() {
        String sName;
        StringTokenizer st;
        logger.finest("......lucene IndexDir=" + this.luceneIndexDir);
        logger.finest("......lucene FulltextFieldList=" + this.luceneFulltextFieldList);
        logger.finest("......lucene IndexFieldListAnalyse=" + this.luceneIndexFieldListAnalyse);
        logger.finest("......lucene IndexFieldListNoAnalyse=" + this.luceneIndexFieldListNoAnalyse);
        this.searchFieldList = new ArrayList<String>();
        this.searchFieldList.addAll(DEFAULT_SEARCH_FIELD_LIST);
        if (this.luceneFulltextFieldList != null && !this.luceneFulltextFieldList.isEmpty()) {
            st = new StringTokenizer(this.luceneFulltextFieldList, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName) || this.searchFieldList.contains(sName)) continue;
                this.searchFieldList.add(sName);
            }
        }
        this.indexFieldListAnalyse = new ArrayList<String>();
        if (this.luceneIndexFieldListAnalyse != null && !this.luceneIndexFieldListAnalyse.isEmpty()) {
            st = new StringTokenizer(this.luceneIndexFieldListAnalyse, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName)) continue;
                this.indexFieldListAnalyse.add(sName);
            }
        }
        this.indexFieldListNoAnalyse = new ArrayList<String>();
        this.indexFieldListNoAnalyse.addAll(DEFAULT_NOANALYSE_FIELD_LIST);
        if (this.luceneIndexFieldListNoAnalyse != null && !this.luceneIndexFieldListNoAnalyse.isEmpty()) {
            st = new StringTokenizer(this.luceneIndexFieldListNoAnalyse, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if (this.indexFieldListNoAnalyse.contains(sName)) continue;
                this.indexFieldListNoAnalyse.add(sName);
            }
        }
        this.indexFieldListStore = new ArrayList<String>();
        this.indexFieldListStore.addAll(DEFAULT_STORE_FIELD_LIST);
        if (this.luceneIndexFieldListStore != null && !this.luceneIndexFieldListStore.isEmpty()) {
            st = new StringTokenizer(this.luceneIndexFieldListStore, ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if (this.indexFieldListStore.contains(sName)) continue;
                this.indexFieldListStore.add(sName);
            }
        }
        for (String fieldName : this.indexFieldListStore) {
            if (this.indexFieldListAnalyse.contains(fieldName)) continue;
            this.indexFieldListAnalyse.add(fieldName);
        }
    }

    public ItemCollection getConfiguration() {
        ItemCollection config = new ItemCollection();
        config.replaceItemValue("lucence.indexDir", (Object)this.luceneIndexDir);
        config.replaceItemValue("lucence.analyzerClass", (Object)this.luceneAnalyserClass);
        config.replaceItemValue("lucence.fulltextFieldList", this.searchFieldList);
        config.replaceItemValue("lucence.indexFieldListAnalyze", this.indexFieldListAnalyse);
        config.replaceItemValue("lucence.indexFieldListNoAnalyze", this.indexFieldListNoAnalyse);
        config.replaceItemValue("lucence.indexFieldListStore", this.indexFieldListStore);
        return config;
    }

    public void updateDocument(ItemCollection documentContext) {
        ArrayList<ItemCollection> documents = new ArrayList<ItemCollection>();
        documents.add(documentContext);
        this.updateDocuments(documents);
    }

    public void updateDocuments(Collection<ItemCollection> documents) {
        long ltime = System.currentTimeMillis();
        for (ItemCollection workitem : documents) {
            if (workitem.getItemValueBoolean("$noindex")) continue;
            this.eventLogService.createEvent(EVENTLOG_TOPIC_ADD, workitem.getUniqueID());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("... update eventLog cache in " + (System.currentTimeMillis() - ltime) + " ms (" + documents.size() + " documents to be index)");
        }
    }

    public void updateDocumentsUncommitted(Collection<ItemCollection> documents) {
        IndexWriter awriter = null;
        long ltime = System.currentTimeMillis();
        try {
            awriter = this.createIndexWriter();
            for (ItemCollection workitem : documents) {
                if (workitem.getItemValueBoolean("$noindex")) continue;
                Term term = new Term("$uniqueid", workitem.getItemValueString("$uniqueid"));
                logger.finest("......lucene add/update uncommitted workitem '" + workitem.getItemValueString("$uniqueid") + "' to index...");
                awriter.updateDocument(term, (Iterable)this.createDocument(workitem));
            }
        }
        catch (IOException luceneEx) {
            logger.warning("lucene error: " + luceneEx.getMessage());
            throw new IndexException("INVALID_INDEX", "Unable to update lucene search index", (Exception)luceneEx);
        }
        finally {
            if (awriter != null) {
                logger.finest("......lucene close IndexWriter...");
                try {
                    awriter.close();
                }
                catch (CorruptIndexException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)e);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("... update index block in " + (System.currentTimeMillis() - ltime) + " ms (" + documents.size() + " workitems total)");
        }
    }

    public void removeDocument(String uniqueID) {
        long ltime = System.currentTimeMillis();
        this.eventLogService.createEvent(EVENTLOG_TOPIC_REMOVE, uniqueID);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("... update eventLog cache in " + (System.currentTimeMillis() - ltime) + " ms (1 document to be removed)");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean flushEventLog(int junkSize) {
        long total = 0L;
        long count = 0L;
        boolean dirtyIndex = true;
        long l = System.currentTimeMillis();
        while (dirtyIndex) {
            try {
                dirtyIndex = !this.flushEventLogByCount(16);
                if (!dirtyIndex) continue;
                total += 16L;
                if ((count += 16L) >= 100L) {
                    logger.finest("...flush event log: " + total + " entries in " + (System.currentTimeMillis() - l) + "ms...");
                    count = 0L;
                }
                if (total < (long)junkSize) continue;
                logger.finest("...flush event: Issue #439  -> total count >=" + total + " flushEventLog will be continued...");
                return false;
            }
            catch (IndexException e) {
                logger.warning("...unable to flush lucene event log: " + e.getMessage());
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushEventLogByCount(int count) {
        Date lastEventDate = null;
        boolean cacheIsEmpty = true;
        IndexWriter indexWriter = null;
        long l = System.currentTimeMillis();
        logger.finest("......flush eventlog cache....");
        List<EventLog> events = this.eventLogService.findEventsByTopic(count + 1, EVENTLOG_TOPIC_ADD, EVENTLOG_TOPIC_REMOVE);
        if (events != null && events.size() > 0) {
            try {
                indexWriter = this.createIndexWriter();
                int _counter = 0;
                for (EventLog eventLogEntry : events) {
                    long l2;
                    Term term = new Term("$uniqueid", eventLogEntry.getRef());
                    Document doc = (Document)this.manager.find(Document.class, (Object)eventLogEntry.getRef());
                    if (doc != null && EVENTLOG_TOPIC_ADD.equals(eventLogEntry.getTopic())) {
                        l2 = System.currentTimeMillis();
                        ItemCollection workitem = new ItemCollection();
                        workitem.setAllItems(doc.getData());
                        if (!workitem.getItemValueBoolean("$noindex")) {
                            indexWriter.updateDocument(term, (Iterable)this.createDocument(workitem));
                            logger.finest("......lucene add/update workitem '" + doc.getId() + "' to index in " + (System.currentTimeMillis() - l2) + "ms");
                        }
                    } else {
                        l2 = System.currentTimeMillis();
                        indexWriter.deleteDocuments(new Term[]{term});
                        logger.finest("......lucene remove workitem '" + term + "' from index in " + (System.currentTimeMillis() - l2) + "ms");
                    }
                    lastEventDate = eventLogEntry.getCreated().getTime();
                    this.eventLogService.removeEvent(eventLogEntry);
                    if (++_counter < count) continue;
                    cacheIsEmpty = false;
                    break;
                }
            }
            catch (IOException luceneEx) {
                logger.warning("...unable to flush lucene event log: " + luceneEx.getMessage());
                boolean bl = true;
                return bl;
            }
            finally {
                if (indexWriter != null) {
                    logger.finest("......lucene close IndexWriter...");
                    try {
                        indexWriter.close();
                    }
                    catch (CorruptIndexException e) {
                        throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)((Object)e));
                    }
                    catch (IOException e) {
                        throw new IndexException("INVALID_INDEX", "Unable to close lucene IndexWriter: ", (Exception)e);
                    }
                }
            }
        }
        logger.fine("...flushEventLog - " + events.size() + " events in " + (System.currentTimeMillis() - l) + " ms - last log entry: " + lastEventDate);
        return cacheIsEmpty;
    }

    private org.apache.lucene.document.Document createDocument(ItemCollection aworkitem) {
        String sValue = null;
        org.apache.lucene.document.Document doc = new org.apache.lucene.document.Document();
        String sContent = "";
        for (String string : this.searchFieldList) {
            sValue = "";
            List vValues = aworkitem.getItemValue(string);
            if (vValues.size() == 0) continue;
            for (Object o : vValues) {
                if (o == null) continue;
                if (o instanceof Calendar || o instanceof Date) {
                    SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
                    String sDateValue = o instanceof Calendar ? dateformat.format(((Calendar)o).getTime()) : dateformat.format((Date)o);
                    sValue = sValue + sDateValue + ",";
                    continue;
                }
                sValue = sValue + o.toString() + ",";
            }
            if (sValue == null) continue;
            sContent = sContent + sValue + ",";
        }
        logger.finest("......add lucene field content=" + sContent);
        doc.add((IndexableField)new TextField("content", sContent, Field.Store.NO));
        ArrayList<String> _localFieldListStore = new ArrayList<String>();
        _localFieldListStore.addAll(this.indexFieldListStore);
        for (String aFieldname : this.indexFieldListAnalyse) {
            this.addItemValues(doc, aworkitem, aFieldname, true, _localFieldListStore.contains(aFieldname));
            _localFieldListStore.remove(aFieldname);
        }
        for (String aFieldname : this.indexFieldListNoAnalyse) {
            this.addItemValues(doc, aworkitem, aFieldname, false, _localFieldListStore.contains(aFieldname));
        }
        doc.add((IndexableField)new StringField("$uniqueid", aworkitem.getItemValueString("$uniqueid"), Field.Store.YES));
        List list = aworkitem.getItemValue("$readAccess");
        if (list.size() == 0 || list.size() == 1 && "".equals(((String)list.get(0)).toString())) {
            sValue = ANONYMOUS;
            doc.add((IndexableField)new StringField("$readaccess", sValue, Field.Store.NO));
        } else {
            sValue = "";
            for (String sReader : list) {
                doc.add((IndexableField)new StringField("$readaccess", sReader, Field.Store.NO));
            }
        }
        return doc;
    }

    private void addItemValues(org.apache.lucene.document.Document doc, ItemCollection workitem, String _itemName, boolean analyzeValue, boolean store) {
        String itemName = _itemName;
        if (itemName == null) {
            return;
        }
        List vValues = workitem.getItemValue(itemName = itemName.toLowerCase().trim());
        if (vValues.size() == 0) {
            return;
        }
        if (vValues.get(0) == null) {
            return;
        }
        boolean firstValue = true;
        for (Object singleValue : vValues) {
            IndexableField indexableField = null;
            indexableField = store ? this.luceneItemAdapter.adaptItemValue(itemName, singleValue, analyzeValue, Field.Store.YES) : this.luceneItemAdapter.adaptItemValue(itemName, singleValue, analyzeValue, Field.Store.NO);
            doc.add(indexableField);
            if (!analyzeValue && firstValue) {
                SortedDocValuesField sortedDocField = this.luceneItemAdapter.adaptSortableItemValue(itemName, singleValue);
                doc.add((IndexableField)sortedDocField);
            }
            firstValue = false;
        }
    }

    private IndexWriter createIndexWriter() throws IOException {
        IndexWriterConfig indexWriterConfig;
        FSDirectory indexDir = FSDirectory.open((Path)Paths.get(this.luceneIndexDir, new String[0]));
        if (!DirectoryReader.indexExists((Directory)indexDir)) {
            logger.info("...lucene index does not yet exist, initialize the index now....");
            this.rebuildIndex((Directory)indexDir);
        }
        try {
            indexWriterConfig = new IndexWriterConfig((Analyzer)Class.forName(this.luceneAnalyserClass).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IndexException("INVALID_INDEX", "Unable to create analyzer '" + this.luceneAnalyserClass + "'", (Exception)e);
        }
        return new IndexWriter((Directory)indexDir, indexWriterConfig);
    }

    public void rebuildIndex(Directory indexDir) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new ClassicAnalyzer());
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        IndexWriter indexWriter = new IndexWriter(indexDir, indexWriterConfig);
        indexWriter.close();
        logger.info("...rebuild lucene index job created...");
        ItemCollection job = new ItemCollection();
        job.replaceItemValue("numinterval", (Object)2);
        job.replaceItemValue("job", (Object)"REBUILD_LUCENE_INDEX");
        this.adminPService.createJob(job);
    }
}

