/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.engine.plugins.AccessPlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;

public class ApplicationPlugin
extends AbstractPlugin {
    public static final String PROCESS_UNDEFINED = "PROCESS_UNDEFINED";
    private ItemCollection documentContext;
    private String sEditorID;
    private String sImageURL;
    private String sAbstract;
    private String sSummary;
    private static Logger logger = Logger.getLogger(ApplicationPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        this.documentContext = adocumentContext;
        this.sEditorID = null;
        this.sImageURL = null;
        this.sAbstract = null;
        this.sSummary = null;
        ItemCollection itemColNextProcess = null;
        try {
            itemColNextProcess = this.getWorkflowService().evalNextTask(adocumentContext, adocumentActivity);
        }
        catch (ModelException e) {
            throw new PluginException(AccessPlugin.class.getSimpleName(), e.getErrorCode(), e.getMessage());
        }
        this.sEditorID = itemColNextProcess.getItemValueString("txtEditorID");
        this.sImageURL = itemColNextProcess.getItemValueString("txtImageURL");
        this.sAbstract = itemColNextProcess.getItemValueString("txtworkflowabstract");
        if (!"".equals(this.sAbstract)) {
            this.sAbstract = this.getWorkflowService().adaptText(this.sAbstract, this.documentContext);
        }
        this.sSummary = itemColNextProcess.getItemValueString("txtworkflowsummary");
        if (!"".equals(this.sSummary)) {
            this.sSummary = this.getWorkflowService().adaptText(this.sSummary, this.documentContext);
        }
        if (this.sEditorID != null && !"".equals(this.sEditorID)) {
            this.documentContext.replaceItemValue("txtWorkflowEditorID", (Object)this.sEditorID);
        }
        if (this.sImageURL != null && !"".equals(this.sImageURL)) {
            this.documentContext.replaceItemValue("txtWorkflowImageURL", (Object)this.sImageURL);
        }
        if (this.sAbstract != null) {
            this.documentContext.replaceItemValue("$workflowabstract", (Object)this.sAbstract);
            this.documentContext.replaceItemValue("txtworkflowabstract", (Object)this.sAbstract);
        }
        if (this.sSummary != null) {
            this.documentContext.replaceItemValue("$workflowsummary", (Object)this.sSummary);
            this.documentContext.replaceItemValue("txtworkflowsummary", (Object)this.sSummary);
        }
        return this.documentContext;
    }
}

