/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.bpmn.BPMNModel;
import org.imixs.workflow.bpmn.BPMNParser;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowScheduler;
import org.imixs.workflow.engine.scheduler.SchedulerService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.QueryException;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;
import org.xml.sax.SAXException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Startup
@Singleton
public class SetupService {
    public static String SETUP_OK = "OK";
    public static String MODEL_INITIALIZED = "MODEL_INITIALIZED";
    private static Logger logger = Logger.getLogger(SetupService.class.getName());
    @Inject
    @ConfigProperty(name="MODEL_DEFAULT_DATA", defaultValue="")
    private String envModelDefaultData;
    @Inject
    @ConfigProperty(name="model.default.data", defaultValue="")
    private String modelDefaultData;
    @EJB
    private DocumentService documentService;
    @EJB
    private ModelService modelService;
    @EJB
    private SchedulerService schedulerService;
    @Resource
    private TimerService timerService;

    public int getModelCount() {
        return this.modelService.getVersions().size();
    }

    @PostConstruct
    public void startup() {
        logger.info("...setup service started...");
        if (this.modelService.getVersions().isEmpty()) {
            this.scanDefaultModels();
        } else {
            logger.info("...model status = OK");
        }
        this.migrateWorkflowScheduler();
        this.schedulerService.startAllSchedulers();
    }

    public void scanDefaultModels() {
        String[] modelResources;
        String modelData;
        logger.finest("......scan default models...");
        String string = modelData = !this.envModelDefaultData.isEmpty() ? this.envModelDefaultData : this.modelDefaultData;
        if ("".equals(modelData)) {
            return;
        }
        for (String modelResource : modelResources = modelData.split(";")) {
            if (modelResource.endsWith(".bpmn") || modelResource.endsWith(".xml")) {
                logger.info("...uploading default model file: '" + modelResource + "'....");
                InputStream inputStream = null;
                try {
                    if (modelResource.startsWith("/")) {
                        File initialFile = new File(modelResource);
                        inputStream = new FileInputStream(initialFile);
                    } else {
                        inputStream = SetupService.class.getClassLoader().getResourceAsStream(modelResource);
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    int next = inputStream.read();
                    while (next > -1) {
                        bos.write(next);
                        next = inputStream.read();
                    }
                    bos.flush();
                    byte[] result = bos.toByteArray();
                    if (modelResource.endsWith(".bpmn")) {
                        BPMNModel model = BPMNParser.parseModel((byte[])result, (String)"UTF-8");
                        this.modelService.saveModel(model);
                    } else {
                        this.importXmlEntityData(result);
                    }
                    return;
                }
                catch (IOException | ParseException | ParserConfigurationException | ModelException | SAXException e) {
                    logger.severe("unable to load model configuration - please check imixs.properties file for key 'setup.defaultModel'");
                    throw new RuntimeException("loadDefaultModels - unable to load model configuration - please check imixs.properties file for key 'setup.defaultModel'");
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            logger.severe("Wrong model format: '" + modelResource + "' - expected *.bpmn or *.xml");
        }
    }

    public void importXmlEntityData(byte[] filestream) {
        String sModelVersion = null;
        if (filestream == null) {
            return;
        }
        try {
            XMLDataCollection ecol = null;
            logger.fine("importXmlEntityData - importModel, verifing file content....");
            Object jaxbObject = null;
            ByteArrayInputStream input = new ByteArrayInputStream(filestream);
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDataCollection.class});
                Unmarshaller m = context.createUnmarshaller();
                jaxbObject = m.unmarshal((InputStream)input);
            }
            catch (JAXBException e) {
                throw new ModelException("INVALID_MODEL", "error - wrong xml file format - unable to import model file: ", (Exception)((Object)e));
            }
            if (jaxbObject == null) {
                throw new ModelException("INVALID_MODEL", "error - wrong xml file format - unable to import model file!");
            }
            ecol = (XMLDataCollection)jaxbObject;
            if (ecol.getDocument().length > 0) {
                ItemCollection itemCollection;
                Vector<String> vModelVersions = new Vector<String>();
                for (XMLDocument aentity : ecol.getDocument()) {
                    itemCollection = XMLDocumentAdapter.putDocument((XMLDocument)aentity);
                    if (!"WorkflowEnvironmentEntity".equals(itemCollection.getItemValueString("type")) || !"environment.profile".equals(itemCollection.getItemValueString("txtName")) || vModelVersions.indexOf(sModelVersion = itemCollection.getItemValueString("$ModelVersion")) != -1) continue;
                    vModelVersions.add(sModelVersion);
                }
                for (String aModelVersion : vModelVersions) {
                    logger.fine("importXmlEntityData - removing existing configuration for model version '" + aModelVersion + "'");
                    this.modelService.removeModel(aModelVersion);
                }
                for (int i = 0; i < ecol.getDocument().length; ++i) {
                    XMLDocument entity = ecol.getDocument()[i];
                    itemCollection = XMLDocumentAdapter.putDocument((XMLDocument)entity);
                    this.documentService.save(itemCollection);
                }
                logger.fine("importXmlEntityData - " + ecol.getDocument().length + " entries sucessfull imported");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void migrateWorkflowScheduler() {
        List<ItemCollection> col;
        ItemCollection configItemCollection = null;
        String searchTerm = "(type:\"configuration\" AND txtname:\"org.imixs.workflow.scheduler\")";
        try {
            col = this.documentService.find(searchTerm, 1, 0);
        }
        catch (QueryException e) {
            logger.severe("loadConfiguration - invalid param: " + e.getMessage());
            throw new InvalidAccessException("INVALID_ID", e.getMessage(), (Exception)((Object)e));
        }
        if (col.size() == 1) {
            Timer oldTimer;
            configItemCollection = (ItemCollection)col.iterator().next();
            ItemCollection scheduler = new ItemCollection();
            if (this.schedulerService.loadConfiguration("org.imixs.workflow.scheduler") == null) {
                logger.info("...migrating deprecated workflow scheduler configuration...");
                scheduler.setItemValue("type", (Object)"scheduler");
                scheduler.setItemValue("_scheduler_definition", (Object)configItemCollection.getItemValue("txtConfiguration"));
                scheduler.setItemValue("_scheduler_class", (Object)WorkflowScheduler.class.getName());
                scheduler.setItemValue("_scheduler_enabled", (Object)configItemCollection.getItemValueBoolean("_enabled"));
                scheduler.setItemValue("txtname", (Object)"org.imixs.workflow.scheduler");
                this.schedulerService.saveConfiguration(scheduler);
            }
            if ((oldTimer = this.findTimer(configItemCollection.getUniqueID())) != null) {
                logger.info("...stopping deprecated workflow scheduler");
            }
            logger.info("...deleting deprecated workflow scheduler");
            this.documentService.remove(configItemCollection);
        }
    }

    Timer findTimer(String id) {
        Timer timer = null;
        for (Object obj : this.timerService.getTimers()) {
            Timer atimer = (Timer)obj;
            String timerID = atimer.getInfo().toString();
            if (!id.equals(timerID)) continue;
            if (timer != null) {
                logger.severe("more then one timer with id " + id + " was found!");
            }
            timer = atimer;
        }
        return timer;
    }
}

