/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import javax.inject.Named;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.imixs.workflow.engine.lucene.LuceneUpdateService;

@Named
public class LuceneItemAdapter {
    private static Logger logger = Logger.getLogger(LuceneUpdateService.class.getName());

    public IndexableField adaptItemValue(String itemName, Object itemValue, boolean doAnalyze) {
        return this.adaptItemValue(itemName, itemValue, doAnalyze, Field.Store.NO);
    }

    public IndexableField adaptItemValue(String itemName, Object itemValue, boolean doAnalyze, Field.Store stored) {
        String stringValue = this.convertItemValue(itemValue);
        logger.finest("......lucene add IndexField (analyzed=" + doAnalyze + "): " + itemName + "=" + stringValue);
        if (doAnalyze) {
            return new TextField(itemName, stringValue, stored);
        }
        return new StringField(itemName, stringValue, stored);
    }

    public SortedDocValuesField adaptSortableItemValue(String itemName, Object itemValue) {
        String stringValue = this.convertItemValue(itemValue);
        logger.finest("......lucene add sortable IndexValue: " + itemName + "=" + stringValue);
        return new SortedDocValuesField(itemName, new BytesRef((CharSequence)stringValue));
    }

    public String convertItemValue(Object itemValue) {
        String convertedValue = "";
        if (itemValue instanceof Calendar || itemValue instanceof Date) {
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            String sDateValue = itemValue instanceof Calendar ? dateformat.format(((Calendar)itemValue).getTime()) : dateformat.format((Date)itemValue);
            convertedValue = sDateValue;
        } else {
            convertedValue = itemValue.toString();
        }
        return convertedValue;
    }
}

