/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowContext;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.engine.plugins.AccessPlugin;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;
import org.imixs.workflow.xml.XSLHandler;

public class DocumentComposerPlugin
extends AbstractPlugin {
    public static String ITEM_DOCUMENT_COMPOSER = "document-composer";
    public static String INVALID_DATA_OBJECT = "INVALID_DATA_OBJECT";
    public static String INVALID_XSL_FORMAT = "INVALID_XSL_FORMAT";
    private static Logger logger = Logger.getLogger(DocumentComposerPlugin.class.getName());

    @Override
    public void init(WorkflowContext actx) throws PluginException {
        super.init(actx);
    }

    public ItemCollection run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        String templateName;
        List<String> dataObject;
        long l = System.currentTimeMillis();
        ItemCollection itemColNextProcess = null;
        try {
            itemColNextProcess = this.getWorkflowService().evalNextTask(documentContext, documentActivity);
        }
        catch (ModelException e) {
            throw new PluginException(AccessPlugin.class.getSimpleName(), e.getErrorCode(), e.getMessage());
        }
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(documentActivity, documentContext);
        if (evalItemCollection != null && evalItemCollection.hasItem(ITEM_DOCUMENT_COMPOSER) && (dataObject = this.findDataObject(templateName = evalItemCollection.getItemValueString(ITEM_DOCUMENT_COMPOSER + ".data-object"), itemColNextProcess)) != null) {
            String template = dataObject.get(1);
            String outputItem = evalItemCollection.getItemValueString(ITEM_DOCUMENT_COMPOSER);
            String output = this.transformXSLTemplate(documentContext, template);
            documentContext.replaceItemValue(outputItem, (Object)output);
            logger.fine("...composed document in " + (System.currentTimeMillis() - l) + "ms");
        }
        return documentContext;
    }

    private List<String> findDataObject(String objectName, ItemCollection task) throws PluginException {
        List dataObjects = task.getItemValue("dataObjects");
        for (List dataObj : dataObjects) {
            String name = (String)dataObj.get(0);
            if (objectName == null || objectName.isEmpty()) {
                return dataObj;
            }
            if (!objectName.equals(name)) continue;
            return dataObj;
        }
        throw new PluginException(this.getClass().getName(), INVALID_DATA_OBJECT, "dataobject with name '" + objectName + "' not defined in Task " + task.getItemValueInteger("numTask"));
    }

    public String transformXSLTemplate(ItemCollection documentContext, String xslTemplate) throws PluginException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String encoding = "UTF-8";
        logger.finest("......transfor mail body based on XSL template....");
        try {
            XMLDocument xml = XMLDocumentAdapter.getDocument((ItemCollection)documentContext);
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDocument.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal((Object)xml, (Writer)writer);
            XSLHandler.transform((String)writer.toString(), (String)xslTemplate, (String)encoding, (OutputStream)outputStream);
            String string = outputStream.toString(encoding);
            return string;
        }
        catch (Exception e) {
            logger.warning("Error processing XSL template!");
            throw new PluginException(this.getClass().getSimpleName(), INVALID_XSL_FORMAT, e.getMessage(), e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

