/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.lucene.LuceneUpdateService;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class LuceneSearchService {
    public static final int DEFAULT_MAX_SEARCH_RESULT = 9999;
    public static final int DEFAULT_PAGE_SIZE = 100;
    @Inject
    @ConfigProperty(name="lucence.indexDir", defaultValue="imixs-workflow-index")
    private String luceneIndexDir;
    @Inject
    @ConfigProperty(name="lucene.defaultOperator", defaultValue="AND")
    private String luceneDefaultOperator;
    @Inject
    @ConfigProperty(name="lucene.splitOnWhitespace", defaultValue="true")
    private boolean luceneSplitOnWhitespace;
    @EJB
    private DocumentService documentService;
    @EJB
    private LuceneUpdateService luceneUpdateService;
    private static Logger logger = Logger.getLogger(LuceneSearchService.class.getName());

    public List<ItemCollection> search(String sSearchTerm) throws QueryException {
        return this.search(sSearchTerm, 9999, 0, null, null);
    }

    public List<ItemCollection> search(String sSearchTerm, int pageSize, int pageIndex) throws QueryException {
        return this.search(sSearchTerm, pageSize, pageIndex, null, null);
    }

    public List<ItemCollection> search(String sSearchTerm, int pageSize, int pageIndex, Sort sortOrder, QueryParser.Operator defaultOperator) throws QueryException {
        return this.search(sSearchTerm, pageSize, pageIndex, sortOrder, defaultOperator, false);
    }

    public List<ItemCollection> search(String searchTerm, int pageSize, int pageIndex, Sort sortOrder, QueryParser.Operator defaultOperator, boolean loadStubs) throws QueryException {
        long ltime = System.currentTimeMillis();
        this.flush();
        if (pageSize <= 0) {
            pageSize = 100;
        }
        if (pageIndex < 0) {
            pageIndex = 0;
        }
        logger.finest("......lucene search: pageNumber=" + pageIndex + " pageSize=" + pageSize);
        ArrayList<ItemCollection> workitems = new ArrayList<ItemCollection>();
        searchTerm = this.getExtendedSearchTerm(searchTerm);
        if (searchTerm == null || "".equals(searchTerm)) {
            return workitems;
        }
        try {
            IndexSearcher searcher = this.createIndexSearcher();
            QueryParser parser = this.createQueryParser();
            parser.setAllowLeadingWildcard(true);
            if (defaultOperator != null) {
                parser.setDefaultOperator(defaultOperator);
            }
            long lsearchtime = System.currentTimeMillis();
            TopDocs topDocs = null;
            TopScoreDocCollector collector = null;
            int startIndex = pageIndex * pageSize;
            int maxSearchResult = 9999;
            if (startIndex + pageSize > 9999) {
                maxSearchResult = startIndex + 3 * pageSize;
                logger.warning("PageIndex (" + pageSize + "x" + pageIndex + ") exeeded DEFAULT_MAX_SEARCH_RESULT(" + 9999 + ") -> new MAX_SEARCH_RESULT is set to " + maxSearchResult);
            }
            Query query = parser.parse(searchTerm);
            if (sortOrder != null) {
                logger.finest("......lucene result sorted by sortOrder= '" + sortOrder + "' ");
                collector = TopFieldCollector.create((Sort)sortOrder, (int)maxSearchResult, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                logger.finest("......lucene result sorted by score ");
                collector = TopScoreDocCollector.create((int)maxSearchResult);
            }
            searcher.search(query, (Collector)collector);
            topDocs = collector.topDocs(startIndex, pageSize);
            ScoreDoc[] scoreDosArray = topDocs.scoreDocs;
            logger.finest("...returned " + scoreDosArray.length + " documents in " + (System.currentTimeMillis() - lsearchtime) + " ms - total hits=" + topDocs.totalHits);
            SimpleDateFormat luceneDateformat = new SimpleDateFormat("yyyyMMddHHmmss");
            for (ScoreDoc scoredoc : scoreDosArray) {
                Document luceneDoc = searcher.doc(scoredoc.doc);
                String sID = luceneDoc.get("$uniqueid");
                ItemCollection imixsDoc = null;
                if (loadStubs) {
                    imixsDoc = this.convertLuceneDocument(luceneDoc, luceneDateformat);
                    imixsDoc.replaceItemValue("$uniqueid", (Object)sID);
                } else {
                    logger.finest("......lucene lookup $uniqueid=" + sID);
                    imixsDoc = this.documentService.load(sID);
                }
                if (imixsDoc != null) {
                    workitems.add(imixsDoc);
                    continue;
                }
                logger.warning("lucene index returned unreadable workitem : " + sID);
                this.luceneUpdateService.removeDocument(sID);
            }
            searcher.getIndexReader().close();
            logger.fine("...search result computed in " + (System.currentTimeMillis() - ltime) + " ms - loadStubs=" + loadStubs);
        }
        catch (IOException e) {
            logger.severe("Lucene index error: " + e.getMessage());
            throw new InvalidAccessException("INVALID_INDEX", e.getMessage(), (Exception)e);
        }
        catch (ParseException e) {
            logger.severe("Lucene search error: " + e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)((Object)e));
        }
        return workitems;
    }

    public void flush() {
        long ltime = System.currentTimeMillis();
        int flushCount = 0;
        while (!this.luceneUpdateService.flushEventLog(2048)) {
            flushCount = 2048;
            logger.info("...flush event log: " + flushCount + " entries updated in " + (System.currentTimeMillis() - ltime) + "ms ...");
        }
    }

    public int getTotalHits(String _searchTerm, int _maxResult, QueryParser.Operator defaultOperator) throws QueryException {
        int result;
        String sSearchTerm;
        int maxResult = _maxResult;
        if (maxResult <= 0) {
            maxResult = 9999;
        }
        if ((sSearchTerm = this.getExtendedSearchTerm(_searchTerm)) == null || "".equals(sSearchTerm)) {
            return 0;
        }
        try {
            IndexSearcher searcher = this.createIndexSearcher();
            QueryParser parser = this.createQueryParser();
            parser.setAllowLeadingWildcard(true);
            if (defaultOperator != null) {
                parser.setDefaultOperator(defaultOperator);
            }
            TopScoreDocCollector collector = null;
            Query query = parser.parse(sSearchTerm);
            collector = TopScoreDocCollector.create((int)maxResult);
            searcher.search(query, (Collector)collector);
            result = collector.getTotalHits();
            logger.finest("......lucene count result = " + result);
        }
        catch (IOException e) {
            logger.severe("Lucene index error: " + e.getMessage());
            throw new InvalidAccessException("INVALID_INDEX", e.getMessage(), (Exception)e);
        }
        catch (ParseException e) {
            logger.severe("Lucene search error: " + e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)((Object)e));
        }
        return result;
    }

    String getExtendedSearchTerm(String sSearchTerm) throws QueryException {
        if (sSearchTerm == null || "".equals(sSearchTerm)) {
            logger.warning("No search term provided!");
            return "";
        }
        if (!this.documentService.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            List<String> userNameList = this.documentService.getUserNameList();
            String sAccessTerm = "($readaccess:ANONYMOUS";
            for (String aRole : userNameList) {
                if ("".equals(aRole)) continue;
                sAccessTerm = sAccessTerm + " OR $readaccess:\"" + aRole + "\"";
            }
            sAccessTerm = sAccessTerm + ") AND ";
            sSearchTerm = sAccessTerm + sSearchTerm;
        }
        logger.finest("......lucene final searchTerm=" + sSearchTerm);
        return sSearchTerm;
    }

    Directory createIndexDirectory() throws IOException {
        logger.finest("......createIndexDirectory...");
        FSDirectory indexDir = FSDirectory.open((Path)Paths.get(this.luceneIndexDir, new String[0]));
        return indexDir;
    }

    IndexSearcher createIndexSearcher() throws IOException {
        DirectoryReader reader = null;
        logger.finest("......createIndexSearcher...");
        Directory indexDir = this.createIndexDirectory();
        try {
            reader = DirectoryReader.open((Directory)indexDir);
        }
        catch (IOException ioe) {
            if (!DirectoryReader.indexExists((Directory)indexDir)) {
                logger.info("...lucene index does not yet exist, trying to initialize the index....");
                this.luceneUpdateService.rebuildIndex(indexDir);
                reader = DirectoryReader.open((Directory)indexDir);
            }
            throw ioe;
        }
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        return searcher;
    }

    QueryParser createQueryParser() {
        QueryParser parser = new QueryParser("content", (Analyzer)new KeywordAnalyzer());
        if (this.luceneDefaultOperator != null && "OR".equals(this.luceneDefaultOperator.toUpperCase())) {
            logger.finest("......DefaultOperator: OR");
            parser.setDefaultOperator(QueryParser.Operator.OR);
        } else {
            logger.finest("......DefaultOperator: AND");
            parser.setDefaultOperator(QueryParser.Operator.AND);
        }
        logger.finest("......SplitOnWhitespace: " + this.luceneSplitOnWhitespace);
        parser.setSplitOnWhitespace(this.luceneSplitOnWhitespace);
        return parser;
    }

    ItemCollection convertLuceneDocument(Document luceneDoc, SimpleDateFormat luceneDateformat) {
        ItemCollection imixsDoc = new ItemCollection();
        List fields = luceneDoc.getFields();
        for (IndexableField indexableField : fields) {
            Object objectValue = null;
            String stringValue = indexableField.stringValue();
            if (LuceneSearchService.isNumeric(stringValue)) {
                if (stringValue.length() == 14 && !stringValue.contains(".")) {
                    try {
                        objectValue = luceneDateformat.parse(stringValue);
                    }
                    catch (java.text.ParseException parseException) {
                        // empty catch block
                    }
                }
                if (objectValue == null) {
                    try {
                        Number number = NumberFormat.getInstance().parse(stringValue);
                        objectValue = number;
                    }
                    catch (java.text.ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if (objectValue == null) {
                objectValue = stringValue;
            }
            logger.finest(".........append " + indexableField.name() + " = " + objectValue);
            imixsDoc.appendItemValue(indexableField.name(), objectValue);
        }
        imixsDoc.replaceItemValue("$isAuthor", (Object)this.documentService.isAuthor(imixsDoc));
        return imixsDoc;
    }

    private static boolean isNumeric(String str) {
        boolean dot = false;
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (c == '.' && !dot) {
                dot = true;
                continue;
            }
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public String escapeSearchTerm(String searchTerm, boolean ignoreBracket) {
        if (searchTerm == null || searchTerm.isEmpty()) {
            return searchTerm;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < searchTerm.length(); ++i) {
            char c = searchTerm.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '?' || c == '|' || c == '&' || c == '/') {
                sb.append('\\');
            }
            if (!(ignoreBracket || c != '(' && c != ')')) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String escapeSearchTerm(String searchTerm) {
        return this.escapeSearchTerm(searchTerm, false);
    }

    public String normalizeSearchTerm(String searchTerm) throws QueryException {
        if (searchTerm == null) {
            return "";
        }
        if (searchTerm.trim().isEmpty()) {
            return "";
        }
        ClassicAnalyzer analyzer = new ClassicAnalyzer();
        QueryParser parser = new QueryParser("content", (Analyzer)analyzer);
        parser.setAllowLeadingWildcard(true);
        try {
            Query result = parser.parse(this.escapeSearchTerm(searchTerm, false));
            searchTerm = result.toString("content");
        }
        catch (ParseException e) {
            logger.warning("Unable to normalze serchTerm '" + searchTerm + "'  -> " + e.getMessage());
            throw new QueryException("QUERY_NOT_UNDERSTANDABLE", e.getMessage(), (Exception)((Object)e));
        }
        return this.escapeSearchTerm(searchTerm, true);
    }
}

