/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.imixs.workflow.engine.jpa.EventLog;

@Stateless
public class EventLogService {
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    private static Logger logger = Logger.getLogger(EventLogService.class.getName());

    public EventLog createEvent(String topic, String refID) {
        return this.createEvent(topic, refID, null);
    }

    public EventLog createEvent(String topic, String refID, Map<String, List<Object>> data) {
        if (refID == null || refID.isEmpty()) {
            logger.warning("create EventLog failed - given ref-id is empty!");
            return null;
        }
        this.manager.setFlushMode(FlushModeType.COMMIT);
        EventLog eventLog = new EventLog(topic, refID, data);
        this.manager.persist((Object)eventLog);
        logger.finest("......created new eventLog '" + refID + "' => " + topic);
        return eventLog;
    }

    public List<EventLog> findEventsByTopic(int maxCount, String ... topic) {
        List<EventLog> result = new ArrayList();
        String query = "SELECT eventlog FROM EventLog AS eventlog ";
        query = query + "WHERE (";
        for (String _topic : topic) {
            query = query + "eventlog.topic = '" + _topic + "' OR ";
        }
        query = query.substring(0, query.length() - 3);
        query = query + ") ORDER BY eventlog.created ASC";
        Query q = this.manager.createQuery(query);
        q.setMaxResults(maxCount);
        result = q.getResultList();
        logger.fine("found " + result.size() + " event for topic " + topic);
        return result;
    }

    public List<EventLog> findEventsByRef(int maxCount, String ref, String ... topic) {
        List result = null;
        String query = "SELECT eventlog FROM EventLog AS eventlog ";
        query = query + "WHERE (eventlog.ref = '" + ref + "' AND (";
        for (String _topic : topic) {
            query = query + "eventlog.topic = '" + _topic + "' OR ";
        }
        query = query.substring(0, query.length() - 3);
        query = query + ") ORDER BY eventlog.created ASC";
        Query q = this.manager.createQuery(query);
        q.setMaxResults(maxCount);
        result = q.getResultList();
        logger.fine("found " + result.size() + " event for topic " + topic);
        return result;
    }

    public void removeEvent(EventLog _eventLog) {
        EventLog eventLog = _eventLog;
        if (eventLog != null && !this.manager.contains((Object)eventLog)) {
            eventLog = (EventLog)this.manager.find(EventLog.class, (Object)eventLog.getId());
        }
        if (eventLog != null) {
            try {
                this.manager.remove((Object)eventLog);
            }
            catch (OptimisticLockException e) {
                logger.finest(e.getMessage());
            }
        }
    }
}

