/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ImixsConfigSource
implements ConfigSource {
    public static final String NAME = "ImixsConfigSource";
    private Map<String, String> properties = null;
    private static Logger logger = Logger.getLogger(ImixsConfigSource.class.getName());

    public int getOrdinal() {
        return 900;
    }

    public String getValue(String key) {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties.get(key);
    }

    public String getName() {
        return NAME;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties;
    }

    private void loadProperties() {
        block3: {
            this.properties = new HashMap<String, String>();
            Properties fileProperties = new Properties();
            try {
                fileProperties.load(Thread.currentThread().getContextClassLoader().getResource("imixs.properties").openStream());
                for (Object key : fileProperties.keySet()) {
                    String value = fileProperties.getProperty(key.toString());
                    if (value == null || value.isEmpty()) continue;
                    this.properties.put(key.toString(), value);
                }
            }
            catch (Exception e) {
                logger.warning("unable to find imixs.properties in current classpath");
                if (!logger.isLoggable(Level.FINE)) break block3;
                e.printStackTrace();
            }
        }
    }
}

