/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.util.XMLParser;

public class SplitAndJoinPlugin
extends AbstractPlugin {
    public static final String LINK_PROPERTY = "txtworkitemref";
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    public static final String SUBPROCESS_CREATE = "subprocess_create";
    public static final String SUBPROCESS_UPDATE = "subprocess_update";
    public static final String ORIGIN_UPDATE = "origin_update";
    private static Logger logger = Logger.getLogger(SplitAndJoinPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException, AccessDeniedException, ProcessingErrorException {
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(adocumentActivity, adocumentContext, false);
        if (evalItemCollection == null) {
            return adocumentContext;
        }
        try {
            List processValueList;
            if (evalItemCollection.hasItem(SUBPROCESS_CREATE)) {
                logger.finest("......processing subprocess_create");
                processValueList = evalItemCollection.getItemValue(SUBPROCESS_CREATE);
                this.createSubprocesses(processValueList, adocumentContext);
            }
            if (evalItemCollection.hasItem(SUBPROCESS_UPDATE)) {
                logger.finest("......sprocessing subprocess_update");
                processValueList = evalItemCollection.getItemValue(SUBPROCESS_UPDATE);
                this.updateSubprocesses(processValueList, adocumentContext);
            }
            if (evalItemCollection.hasItem(ORIGIN_UPDATE)) {
                logger.finest("......processing origin_update");
                String processValue = evalItemCollection.getItemValueString(ORIGIN_UPDATE);
                this.updateOrigin(processValue, adocumentContext);
            }
        }
        catch (ModelException e) {
            throw new PluginException(e.getErrorContext(), e.getErrorCode(), e.getMessage(), (Exception)((Object)e));
        }
        return adocumentContext;
    }

    protected void createSubprocesses(List<String> subProcessDefinitions, ItemCollection originWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            String workflowResult;
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = XMLParser.parseItemStructure((String)processValue)) == null) continue;
            ItemCollection workitemSubProcess = new ItemCollection();
            this.copyItemList(processData.getItemValueString("items"), originWorkitem, workitemSubProcess);
            String sModelVersion = processData.getItemValueString("modelversion");
            if (sModelVersion.isEmpty()) {
                sModelVersion = originWorkitem.getModelVersion();
            }
            workitemSubProcess.replaceItemValue("$modelversion", (Object)sModelVersion);
            String task_pattern = processData.getItemValueString("task");
            if (task_pattern.isEmpty() && processData.hasItem("processid")) {
                task_pattern = processData.getItemValueString("processid");
                logger.warning("...subprocess_create uses deprecated tag 'processid' instead of 'task'. Please check your model");
            }
            workitemSubProcess.setTaskID(Integer.valueOf(task_pattern).intValue());
            String event_pattern = processData.getItemValueString("event");
            if (event_pattern.isEmpty() && processData.hasItem("activityid")) {
                event_pattern = processData.getItemValueString("activityid");
                logger.warning("...subprocess_create uses deprecated tag 'activityid' instead of 'event'. Please check your model");
            }
            workitemSubProcess.setEventID(Integer.valueOf(event_pattern).intValue());
            workitemSubProcess.replaceItemValue("$uniqueidref", (Object)originWorkitem.getUniqueID());
            workitemSubProcess = this.getWorkflowService().processWorkItem(workitemSubProcess);
            logger.finest("...... successful created new subprocess.");
            this.addWorkitemRef(workitemSubProcess.getUniqueID(), originWorkitem);
            if (!processData.hasItem("action") || (workflowResult = processData.getItemValueString("action")).isEmpty()) continue;
            workflowResult = this.getWorkflowService().adaptText(workflowResult, workitemSubProcess);
            originWorkitem.replaceItemValue("action", (Object)workflowResult);
        }
    }

    protected void updateSubprocesses(List<String> subProcessDefinitions, ItemCollection originWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        if (subProcessDefinitions == null || subProcessDefinitions.size() == 0) {
            return;
        }
        for (String processValue : subProcessDefinitions) {
            ItemCollection processData;
            if (processValue.trim().isEmpty() || (processData = XMLParser.parseItemStructure((String)processValue)) == null) continue;
            String model_pattern = processData.getItemValueString("modelversion");
            String task_pattern = processData.getItemValueString("task");
            if (task_pattern.isEmpty() && processData.hasItem("processid")) {
                task_pattern = processData.getItemValueString("processid");
                logger.warning("...subprocess_update uses deprecated tag 'processid' instead of 'task'. Please check your model");
            }
            List subProcessRefList = originWorkitem.getItemValue(LINK_PROPERTY);
            for (String subProcessRef : subProcessRefList) {
                String workflowResult;
                ItemCollection workitemSubProcess = this.getWorkflowService().getWorkItem(subProcessRef);
                String subModelVersion = workitemSubProcess.getModelVersion();
                String subProcessID = "" + workitemSubProcess.getTaskID();
                if (Pattern.compile(model_pattern).matcher(subModelVersion).find() && Pattern.compile(task_pattern).matcher(subProcessID).find()) {
                    String workflowResult2;
                    logger.finest("...... subprocess matches criteria.");
                    this.copyItemList(processData.getItemValueString("items"), originWorkitem, workitemSubProcess);
                    String event_pattern = processData.getItemValueString("event");
                    if (event_pattern.isEmpty() && processData.hasItem("activityid")) {
                        event_pattern = processData.getItemValueString("activityid");
                        logger.warning("...subprocess_update uses deprecated tag 'activityid' instead of 'event'. Please check your model");
                    }
                    workitemSubProcess.setEventID(Integer.valueOf(event_pattern).intValue());
                    workitemSubProcess = this.getWorkflowService().processWorkItem(workitemSubProcess);
                    if (processData.hasItem("action") && !(workflowResult2 = processData.getItemValueString("action")).isEmpty()) {
                        workflowResult2 = this.getWorkflowService().adaptText(workflowResult2, workitemSubProcess);
                        originWorkitem.replaceItemValue("action", (Object)workflowResult2);
                    }
                    logger.finest("...... successful updated subprocess.");
                }
                if (!processData.hasItem("action") || (workflowResult = processData.getItemValueString("action")).isEmpty()) continue;
                workflowResult = this.getWorkflowService().adaptText(workflowResult, workitemSubProcess);
                originWorkitem.replaceItemValue("action", (Object)workflowResult);
            }
        }
    }

    protected void updateOrigin(String originProcessDefinition, ItemCollection subprocessWorkitem) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection originWorkitem = null;
        if (originProcessDefinition == null || originProcessDefinition.isEmpty()) {
            return;
        }
        ItemCollection processData = XMLParser.parseItemStructure((String)originProcessDefinition);
        String model_pattern = processData.getItemValueString("modelversion");
        String task_pattern = processData.getItemValueString("task");
        if (task_pattern.isEmpty() && processData.hasItem("processid")) {
            task_pattern = processData.getItemValueString("processid");
            logger.warning("...origin_update uses deprecated tag 'processid' instead of 'task'. Please check your model");
        }
        List refs = subprocessWorkitem.getItemValue("$uniqueidref");
        for (String ref : refs) {
            String workflowResult;
            originWorkitem = this.getWorkflowService().getWorkItem(ref);
            if (originWorkitem == null) continue;
            String subModelVersion = originWorkitem.getModelVersion();
            String subProcessID = "" + originWorkitem.getTaskID();
            if (!Pattern.compile(model_pattern).matcher(subModelVersion).find() || !Pattern.compile(task_pattern).matcher(subProcessID).find()) continue;
            logger.finest("...... origin matches criteria.");
            String event_pattern = processData.getItemValueString("event");
            if (event_pattern.isEmpty() && processData.hasItem("activityid")) {
                event_pattern = processData.getItemValueString("activityid");
                logger.warning("...origin_update uses deprecated tag 'activityid' instead of 'event'. Please check your model");
            }
            originWorkitem.setEventID(Integer.valueOf(event_pattern).intValue());
            this.copyItemList(processData.getItemValueString("items"), subprocessWorkitem, originWorkitem);
            originWorkitem = this.getWorkflowService().processWorkItem(originWorkitem);
            if (processData.hasItem("action") && !(workflowResult = processData.getItemValueString("action")).isEmpty()) {
                workflowResult = this.getWorkflowService().adaptText(workflowResult, originWorkitem);
                subprocessWorkitem.replaceItemValue("action", (Object)workflowResult);
            }
            logger.finest("...... successful processed originprocess.");
        }
    }

    protected void copyItemList(String items, ItemCollection source, ItemCollection target) {
        StringTokenizer st = new StringTokenizer(items, ",");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            if (field.startsWith("(") && field.endsWith(")")) {
                Pattern itemPattern = Pattern.compile(field);
                Map map = source.getAllItems();
                for (String itemName : map.keySet()) {
                    if (!itemPattern.matcher(itemName).find()) continue;
                    target.replaceItemValue(itemName, (Object)source.getItemValue(itemName));
                }
                continue;
            }
            int pos = field.indexOf(124);
            if (pos > -1) {
                target.replaceItemValue(field.substring(pos + 1).trim(), (Object)source.getItemValue(field.substring(0, pos).trim()));
                continue;
            }
            target.replaceItemValue(field, (Object)source.getItemValue(field));
        }
    }

    protected void addWorkitemRef(String aUniqueID, ItemCollection workitem) {
        logger.fine("LinkController add workitem reference: " + aUniqueID);
        List refList = workitem.getItemValue(LINK_PROPERTY);
        if (refList.size() == 1 && "".equals(refList.get(0))) {
            refList.remove(0);
        }
        if (refList.indexOf(aUniqueID) == -1) {
            refList.add(aUniqueID);
            workitem.replaceItemValue(LINK_PROPERTY, (Object)refList);
        }
    }
}

