/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ImixsConfigSource
implements ConfigSource {
    public static final String NAME = "ImixsConfigSource";
    private Map<String, String> properties = null;
    private static Logger logger = Logger.getLogger(ImixsConfigSource.class.getName());

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public int getOrdinal() {
        return 900;
    }

    public String getValue(String key) {
        String keyAlternative;
        String value;
        if (this.properties == null) {
            this.loadProperties();
        }
        if (!((value = this.properties.get(key)) != null && !value.isEmpty() || (keyAlternative = this.getAlternative(key)) == null || keyAlternative.isEmpty() || (value = this.properties.get(keyAlternative)) == null || value.isEmpty())) {
            logger.warning("Deprecated imixs.property '" + keyAlternative + "' should be replaced by '" + key + "'");
        }
        return value;
    }

    public String getName() {
        return NAME;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties;
    }

    private void loadProperties() {
        block3: {
            this.properties = new HashMap<String, String>();
            Properties fileProperties = new Properties();
            try {
                fileProperties.load(Thread.currentThread().getContextClassLoader().getResource("imixs.properties").openStream());
                for (Object key : fileProperties.keySet()) {
                    String value = fileProperties.getProperty(key.toString());
                    if (value == null || value.isEmpty()) continue;
                    this.properties.put(key.toString(), value);
                }
            }
            catch (Exception e) {
                logger.warning("unable to find imixs.properties in current classpath");
                if (!logger.isLoggable(Level.FINE)) break block3;
                e.printStackTrace();
            }
        }
    }

    private String getAlternative(String key) {
        if ("index.fields".equals(key)) {
            return "lucence.fulltextFieldList";
        }
        if ("index.fields.analyze".equals(key)) {
            return "lucence.indexFieldListAnalyze";
        }
        if ("index.fields.noanalyze".equals(key)) {
            return "lucence.indexFieldListNoAnalyze";
        }
        if ("index.fields.store".equals(key)) {
            return "lucence.indexFieldListStore";
        }
        if ("index.operator".equals(key)) {
            return "lucence.defaultOperator";
        }
        if ("index.splitwhitespace".equals(key)) {
            return "lucence.splitOnWhitespace";
        }
        return null;
    }
}

