/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import jakarta.annotation.Resource;
import jakarta.ejb.SessionContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.QuerySelector;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.scheduler.Scheduler;
import org.imixs.workflow.engine.scheduler.SchedulerException;
import org.imixs.workflow.engine.scheduler.SchedulerService;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.QueryException;

public class WorkflowScheduler
implements Scheduler {
    public static final String NAME = "org.imixs.workflow.scheduler";
    public static final int OFFSET_SECONDS = 0;
    public static final int OFFSET_MINUTES = 1;
    public static final int OFFSET_HOURS = 2;
    public static final int OFFSET_DAYS = 3;
    public static final int OFFSET_WORKDAYS = 4;
    private static final int MAX_WORKITEM_COUNT = 1000;
    private static Logger logger = Logger.getLogger(WorkflowScheduler.class.getName());
    @Inject
    private WorkflowService workflowService;
    @Inject
    private DocumentService documentService;
    @Inject
    private ModelService modelService;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    @Any
    protected Instance<QuerySelector> selectors;
    @Resource
    private SessionContext ctx;
    private int iProcessWorkItems = 0;
    private List<String> unprocessedIDs = null;

    public boolean workItemInDue(ItemCollection doc, ItemCollection docActivity) {
        try {
            int iCompareType = -1;
            int iOffsetUnit = -1;
            int iOffset = 0;
            Date dateTimeCompare = null;
            String suniqueid = doc.getItemValueString("$uniqueid");
            String sDelayUnit = docActivity.getItemValueString("keyActivityDelayUnit");
            try {
                iOffsetUnit = Integer.parseInt(sDelayUnit);
                if (iOffsetUnit < 1 || iOffsetUnit > 4) {
                    logger.warning("error parsing delay in ActivityEntity " + docActivity.getItemValueInteger("numProcessID") + "." + docActivity.getItemValueInteger("numActivityID") + " : unsuported keyActivityDelayUnit=" + sDelayUnit);
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                logger.warning("error parsing delay in ActivityEntity " + docActivity.getItemValueInteger("numProcessID") + "." + docActivity.getItemValueInteger("numActivityID") + " :" + nfe.getMessage());
                return false;
            }
            iOffset = docActivity.getItemValueInteger("numActivityDelay");
            if ("1".equals(sDelayUnit)) {
                sDelayUnit = "minutes";
            }
            if ("2".equals(sDelayUnit)) {
                sDelayUnit = "hours";
            }
            if ("3".equals(sDelayUnit)) {
                sDelayUnit = "days";
            }
            if ("4".equals(sDelayUnit)) {
                sDelayUnit = "workdays";
            }
            logger.finest("......" + suniqueid + " offset =" + iOffset + " " + sDelayUnit);
            iCompareType = docActivity.getItemValueInteger("keyScheduledBaseObject");
            Date dateTimeNow = Calendar.getInstance().getTime();
            switch (iCompareType) {
                case 1: {
                    logger.finest("......" + suniqueid + ": CompareType = last event");
                    if (!doc.hasItem("$lastEventDate")) {
                        logger.info("migrating $lasteventdate...");
                        if (doc.hasItem("$lastProcessingDate")) {
                            doc.replaceItemValue("$lastEventDate", (Object)doc.getItemValue("$lastProcessingDate"));
                        } else {
                            doc.replaceItemValue("$lastEventDate", (Object)doc.getItemValue("timWorkflowLastAccess"));
                        }
                    }
                    if ((dateTimeCompare = doc.getItemValueDate("$lastEventDate")) == null) {
                        logger.warning(suniqueid + ": item '$lastEventDate' is missing!");
                        return false;
                    }
                    logger.finest("......" + suniqueid + ": $lastEventDate=" + dateTimeCompare);
                    dateTimeCompare = this.adjustBaseDate(dateTimeCompare, iOffsetUnit, iOffset);
                    if (dateTimeCompare != null) {
                        return dateTimeCompare.before(dateTimeNow);
                    }
                    return false;
                }
                case 2: {
                    logger.finest("......" + suniqueid + ": CompareType = last modify");
                    dateTimeCompare = doc.getItemValueDate("$modified");
                    logger.finest("......" + suniqueid + ": modified=" + dateTimeCompare);
                    dateTimeCompare = this.adjustBaseDate(dateTimeCompare, iOffsetUnit, iOffset);
                    if (dateTimeCompare != null) {
                        return dateTimeCompare.before(dateTimeNow);
                    }
                    return false;
                }
                case 3: {
                    logger.finest("......" + suniqueid + ": CompareType = creation");
                    dateTimeCompare = doc.getItemValueDate("$created");
                    logger.finest("......" + suniqueid + ": doc.getCreated() =" + dateTimeCompare);
                    dateTimeCompare = this.adjustBaseDate(dateTimeCompare, iOffsetUnit, iOffset);
                    if (dateTimeCompare != null) {
                        return dateTimeCompare.before(dateTimeNow);
                    }
                    return false;
                }
                case 4: {
                    String sNameOfField = docActivity.getItemValueString("keyTimeCompareField");
                    logger.finest("......" + suniqueid + ": CompareType = field: '" + sNameOfField + "'");
                    if (!doc.hasItem(sNameOfField)) {
                        logger.finest("......" + suniqueid + ": CompareType =" + sNameOfField + " no value found!");
                        return false;
                    }
                    dateTimeCompare = doc.getItemValueDate(sNameOfField);
                    logger.finest("......" + suniqueid + ": " + sNameOfField + "=" + dateTimeCompare);
                    dateTimeCompare = this.adjustBaseDate(dateTimeCompare, iOffsetUnit, iOffset);
                    if (dateTimeCompare != null) {
                        logger.finest("......" + suniqueid + ": Compare " + dateTimeCompare + " <-> " + dateTimeNow);
                        if (dateTimeCompare.before(dateTimeNow)) {
                            logger.finest("......" + suniqueid + " isInDue!");
                        }
                        return dateTimeCompare.before(dateTimeNow);
                    }
                    return false;
                }
            }
            logger.warning("Time Base is not defined, verify model!");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Calendar addWorkDays(Calendar baseDate, int days) {
        Calendar resultDate = null;
        Calendar workCal = Calendar.getInstance();
        workCal.setTime(baseDate.getTime());
        int currentWorkDay = workCal.get(7);
        if (currentWorkDay == 7) {
            workCal.add(5, days < 0 ? -1 : 2);
            currentWorkDay = workCal.get(7);
        }
        if (currentWorkDay == 1) {
            workCal.add(5, days < 0 ? -2 : 1);
            currentWorkDay = workCal.get(7);
        }
        if (currentWorkDay >= 2 && currentWorkDay <= 6) {
            boolean inCurrentWeek = false;
            if (days > 0) {
                inCurrentWeek = currentWorkDay + days < 7;
            } else {
                boolean bl = inCurrentWeek = currentWorkDay + days > 1;
            }
            if (inCurrentWeek) {
                workCal.add(5, days);
                resultDate = workCal;
            } else {
                int totalDays = 0;
                int daysInCurrentWeek = 0;
                if (days > 0) {
                    daysInCurrentWeek = 7 - currentWorkDay;
                    totalDays = daysInCurrentWeek + 2;
                } else {
                    daysInCurrentWeek = -(currentWorkDay - 1);
                    totalDays = daysInCurrentWeek - 2;
                }
                int restTotalDays = days - daysInCurrentWeek;
                int x = restTotalDays / 5;
                workCal.add(5, totalDays += restTotalDays + x * 2);
                resultDate = workCal;
            }
        }
        if (resultDate != null) {
            logger.finest("......addWorkDays (" + baseDate.getTime() + ") + " + days + " = (" + resultDate.getTime() + ")");
        }
        return resultDate;
    }

    @Override
    public ItemCollection run(ItemCollection configItemCollection) throws SchedulerException {
        block6: {
            this.iProcessWorkItems = 0;
            this.unprocessedIDs = new ArrayList<String>();
            try {
                List<String> modelVersions = this.modelService.getVersions();
                Collections.sort(modelVersions, Collections.reverseOrder());
                for (String version : modelVersions) {
                    Collection<ItemCollection> scheduledEvents = this.findScheduledEvents(version);
                    this.schedulerService.logMessage(version + " (" + scheduledEvents.size() + " scheduled events)", configItemCollection, null);
                    for (ItemCollection aactivityEntity : scheduledEvents) {
                        this.processWorkListByEvent(aactivityEntity, configItemCollection);
                    }
                }
            }
            catch (Exception e) {
                logger.severe("Error processing worklist: " + e.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block6;
                e.printStackTrace();
            }
        }
        this.schedulerService.logMessage("================================", configItemCollection, null);
        this.schedulerService.logMessage("... WorkflowScheduler completed.", configItemCollection, null);
        this.schedulerService.logMessage("..." + this.iProcessWorkItems + " workitems processed", configItemCollection, null);
        if (this.unprocessedIDs.size() > 0) {
            this.schedulerService.logWarning(this.unprocessedIDs.size() + " workitems could not be processed:", configItemCollection, null);
            for (String aid : this.unprocessedIDs) {
                this.schedulerService.logWarning("          " + aid, configItemCollection, null);
            }
        }
        configItemCollection.replaceItemValue("numWorkItemsProcessed", (Object)this.iProcessWorkItems);
        configItemCollection.replaceItemValue("numWorkItemsUnprocessed", (Object)this.unprocessedIDs.size());
        return configItemCollection;
    }

    protected Collection<ItemCollection> findScheduledEvents(String aModelVersion) throws ModelException {
        Vector<ItemCollection> vectorActivities = new Vector<ItemCollection>();
        List colProcessList = null;
        colProcessList = this.modelService.getModel(aModelVersion).findAllTasks();
        for (ItemCollection aprocessentity : colProcessList) {
            int processid = aprocessentity.getItemValueInteger("numprocessid");
            logger.finest("......analyse processentity '" + processid + "'");
            List aActivityList = this.modelService.getModel(aModelVersion).findAllEventsByTask(processid);
            for (ItemCollection aactivityEntity : aActivityList) {
                logger.finest("......analyse acitity '" + aactivityEntity.getItemValueString("txtname") + "'");
                if (!"1".equals(aactivityEntity.getItemValueString("keyScheduledActivity"))) continue;
                vectorActivities.add(aactivityEntity);
            }
        }
        return vectorActivities;
    }

    protected void processWorkListByEvent(ItemCollection event, ItemCollection configItemCollection) throws ModelException, QueryException {
        int taskID = event.getItemValueInteger("numprocessid");
        int eventID = event.getItemValueInteger("numActivityID");
        String modelVersionEvent = event.getItemValueString("$modelversion");
        ItemCollection taskElement = this.modelService.getModel(modelVersionEvent).getTask(taskID);
        String workflowGroup = taskElement.getItemValueString("txtworkflowgroup");
        Object searchTerm = null;
        searchTerm = event.getItemValueString("txtscheduledview");
        if (((String)searchTerm).isEmpty()) {
            searchTerm = "($taskid:\"" + taskID + "\" AND $workflowgroup:\"" + workflowGroup + "\")";
        }
        List worklist = null;
        String classPattern = "^[a-z][a-z0-9_]*(\\.[A-Za-z0-9_]+)+$";
        if (Pattern.compile(classPattern).matcher((CharSequence)searchTerm).find()) {
            QuerySelector selector = this.findSelectorByName((String)searchTerm);
            if (selector != null) {
                this.schedulerService.logMessage("...CDI selector = " + (String)searchTerm, configItemCollection, null);
                worklist = selector.find(1000, 0);
            }
        } else {
            this.schedulerService.logMessage("...selector = " + (String)searchTerm, configItemCollection, null);
            worklist = this.documentService.find((String)searchTerm, 1000, 0);
        }
        logger.finest("......" + worklist.size() + " workitems found");
        for (ItemCollection workitem : worklist) {
            String type = workitem.getType();
            if (type.endsWith("deleted") || workitem.getItemValueBoolean("$immutable")) continue;
            if (!modelVersionEvent.equals(workitem.getModelVersion())) {
                try {
                    this.modelService.getModel(workitem.getModelVersion());
                    logger.finest("......skip because model version is older than current version...");
                    continue;
                }
                catch (ModelException me) {
                    logger.fine("...deprecated model version '" + workitem.getModelVersion() + "' no longer exists -> migrating to new model version '" + modelVersionEvent + "'");
                    workitem.model(modelVersionEvent);
                }
            }
            if (!this.workItemInDue(workitem, event)) continue;
            String sID = workitem.getItemValueString("$uniqueid");
            logger.finest("......document " + sID + "is in due");
            workitem.setEventID(eventID);
            try {
                logger.finest("......getBusinessObject.....");
                workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
                ++this.iProcessWorkItems;
            }
            catch (Exception e) {
                logger.warning("error processing workitem: " + sID + " Error=" + e.getMessage());
                if (logger.isLoggable(Level.FINEST)) {
                    e.printStackTrace();
                }
                this.unprocessedIDs.add(sID);
            }
        }
    }

    private Date adjustBaseDate(Date baseDate, int offsetUnit, int offset) {
        if (baseDate != null) {
            if (offsetUnit == 4) {
                Calendar baseCal = Calendar.getInstance();
                baseCal.setTime(baseDate);
                return this.addWorkDays(baseCal, offset).getTime();
            }
            if (offsetUnit == 1) {
                offset *= 60;
            } else if (offsetUnit == 2) {
                offset *= 3600;
            } else if (offsetUnit == 3) {
                offset *= 86400;
            }
            Calendar calTimeCompare = Calendar.getInstance();
            calTimeCompare.setTime(baseDate);
            calTimeCompare.add(13, offset);
            return calTimeCompare.getTime();
        }
        return null;
    }

    private QuerySelector findSelectorByName(String selectorClassName) {
        if (selectorClassName == null || selectorClassName.isEmpty()) {
            return null;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        if (this.selectors == null || !this.selectors.iterator().hasNext()) {
            if (debug) {
                logger.finest("......no CDI selectors injected");
            }
            return null;
        }
        for (QuerySelector selector : this.selectors) {
            if (!selector.getClass().getName().equals(selectorClassName)) continue;
            if (debug) {
                logger.finest("......CDI selector '" + selectorClassName + "' successful injected");
            }
            return selector;
        }
        return null;
    }
}

