/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import jakarta.annotation.Resource;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerService;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.Plugin;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;
import org.imixs.workflow.engine.adminp.JobHandlerRebuildIndex;
import org.imixs.workflow.engine.adminp.JobHandlerRenameUser;
import org.imixs.workflow.engine.adminp.JobHandlerUpgradeWorkitems;
import org.imixs.workflow.exceptions.AccessDeniedException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Stateless
public class AdminPService {
    public static final String JOB_RENAME_USER = "RENAME_USER";
    public static final String JOB_REBUILD_INDEX = "JOB_REBUILD_INDEX";
    public static final String JOB_UPGRADE = "UPGRADE";
    public static final String JOB_MIGRATION = "MIGRATION";
    private static final int DEFAULT_INTERVAL = 1;
    @Resource
    SessionContext ctx;
    @Resource
    TimerService timerService;
    @Inject
    DocumentService documentService;
    @Inject
    JobHandlerUpgradeWorkitems jobHandlerUpgradeWorkitems;
    @Inject
    JobHandlerRenameUser jobHandlerRenameUser;
    @Inject
    JobHandlerRebuildIndex jobHandlerRebuildIndex;
    @Inject
    @Any
    private Instance<JobHandler> jobHandlers;
    @Inject
    @Any
    private Instance<Plugin> plugins;
    private static Logger logger = Logger.getLogger(AdminPService.class.getName());

    public ItemCollection createJob(ItemCollection adminp) throws AccessDeniedException {
        adminp.replaceItemValue("type", (Object)"adminp");
        adminp.replaceItemValue("$snapshot.history", (Object)1);
        String jobtype = adminp.getItemValueString("job");
        adminp.replaceItemValue("$uniqueid", (Object)WorkflowKernel.generateUniqueID());
        int interval = adminp.getItemValueInteger("numInterval");
        if (interval <= 0) {
            interval = 1;
            adminp.replaceItemValue("numInterval", (Object)interval);
        }
        Calendar cal = Calendar.getInstance();
        Date terminationDate = cal.getTime();
        cal.add(10, 24);
        adminp.replaceItemValue("datTerminate", (Object)terminationDate);
        adminp = this.documentService.save(adminp);
        Timer timer = this.timerService.createTimer(terminationDate, (long)(60 * interval * 1000), (Serializable)((Object)adminp.getItemValueString("$uniqueid")));
        logger.info("Job " + jobtype + " (" + timer.getInfo().toString() + ") started... ");
        return adminp;
    }

    public void deleteJob(String id) throws AccessDeniedException {
        ItemCollection adminp = this.cancelTimer(id);
        if (adminp != null) {
            this.documentService.remove(adminp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    public void scheduleTimer(Timer timer) {
        String sTimerID = null;
        boolean debug = logger.isLoggable(Level.FINE);
        long lProfiler = System.currentTimeMillis();
        sTimerID = timer.getInfo().toString();
        ItemCollection adminp = this.documentService.load(sTimerID);
        try {
            if (adminp == null) {
                logger.info("Process " + sTimerID + " was removed - timer will be canceled");
                timer.cancel();
                return;
            }
            String job = adminp.getItemValueString("job");
            logger.info("Job " + job + " (" + adminp.getUniqueID() + ")  processing...");
            JobHandler jobHandler = null;
            if (job.equals(JOB_RENAME_USER)) {
                jobHandler = this.jobHandlerRenameUser;
            }
            if (job.equals(JOB_UPGRADE)) {
                jobHandler = this.jobHandlerUpgradeWorkitems;
            }
            if (job.equals(JOB_REBUILD_INDEX) || job.equals("REBUILD_LUCENE_INDEX")) {
                jobHandler = this.jobHandlerRebuildIndex;
            }
            if (jobHandler == null) {
                jobHandler = this.findJobHandlerByName(job);
            }
            if (jobHandler != null) {
                adminp.replaceItemValue("$workflowStatus", (Object)"PROCESSING");
                adminp = this.documentService.save(adminp);
                adminp = jobHandler.run(adminp);
                if (adminp.getItemValueBoolean("iscompleted")) {
                    timer.cancel();
                    adminp.replaceItemValue("$workflowStatus", (Object)"COMPLETED");
                    logger.info("Job " + job + " (" + adminp.getUniqueID() + ") completed - timer stopped");
                } else {
                    adminp.replaceItemValue("$workflowStatus", (Object)"WAITING");
                }
            } else {
                logger.warning("Unable to start AdminP Job. JobHandler class '" + job + "' not defined!");
                timer.cancel();
                adminp.replaceItemValue("$workflowStatus", (Object)"FAILED");
                logger.info("Job " + adminp.getUniqueID() + " - timer stopped");
            }
        }
        catch (AdminPException e) {
            e.printStackTrace();
            timer.cancel();
            logger.severe("AdminP job '" + sTimerID + "' failed - " + e.getMessage());
            if (adminp != null) {
                adminp.replaceItemValue("$workflowStatus", (Object)"FAILED");
                adminp.replaceItemValue("errormessage", (Object)e.getMessage());
            }
        }
        finally {
            block27: {
                try {
                    if (adminp != null) {
                        adminp = this.documentService.save(adminp);
                    } else {
                        logger.warning("Unable to update adminp job status - adminp document is null!");
                    }
                }
                catch (EJBException | AccessDeniedException e2) {
                    logger.warning("Unable to update adminp job status - reason: " + e2.getMessage());
                    if (!debug) break block27;
                    e2.printStackTrace();
                }
            }
        }
        logger.fine("...timer call finished successfull after " + (System.currentTimeMillis() - lProfiler) + " ms");
    }

    private JobHandler findJobHandlerByName(String jobHandlerClassName) {
        if (jobHandlerClassName == null || jobHandlerClassName.isEmpty()) {
            return null;
        }
        if (this.jobHandlers == null || !this.jobHandlers.iterator().hasNext()) {
            logger.finest("......no CDI jobHandlers injected");
            return null;
        }
        for (JobHandler jobHandler : this.jobHandlers) {
            if (!jobHandler.getClass().getName().equals(jobHandlerClassName)) continue;
            logger.finest("......CDI JobHandler '" + jobHandlerClassName + "' successful injected");
            return jobHandler;
        }
        return null;
    }

    private ItemCollection cancelTimer(String id) {
        Timer timer;
        logger.finest("......cancelTimer - id:" + id + " ....");
        ItemCollection adminp = this.documentService.load(id);
        if (adminp == null) {
            logger.warning("failed to load timer data ID:" + id + " ");
        }
        if ((timer = this.findTimer(id)) != null) {
            timer.cancel();
            logger.info("cancelTimer - id:" + id + " successful.");
        } else {
            logger.info("cancelTimer - id:" + id + " failed - timer does no longer exist.");
        }
        if (adminp != null) {
            adminp.replaceItemValue("txtTimerStatus", (Object)"Stopped");
        }
        return adminp;
    }

    private Timer findTimer(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        for (Object obj : this.timerService.getTimers()) {
            String timerid;
            Timer timer = (Timer)obj;
            if (!(timer.getInfo() instanceof String) || !id.equals(timerid = timer.getInfo().toString())) continue;
            return timer;
        }
        logger.warning("findTimer - id:" + id + " does no longer exist.");
        return null;
    }
}

