/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.exceptions.InvalidAccessException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@Stateless
@LocalBean
public class JobHandlerRebuildIndex
implements JobHandler {
    private static final String BLOCK_SIZE_DEFAULT = "500";
    private static final String TIMEOUT_DEFAULT = "120";
    @Inject
    @ConfigProperty(name="lucene.rebuild.block_size", defaultValue="500")
    int block_size;
    @Inject
    @ConfigProperty(name="lucene.rebuild.time_out", defaultValue="120")
    int time_out;
    private static final int READ_AHEAD = 32;
    public static final String ITEM_SYNCPOINT = "syncpoint";
    public static final String ITEM_SYNCDATE = "syncdate";
    public static final String SNAPSHOT_TYPE_PRAFIX = "snapshot-";
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    @Inject
    UpdateService updateService;
    private static Logger logger = Logger.getLogger(JobHandlerRebuildIndex.class.getName());

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection run(ItemCollection adminp) throws AdminPException {
        long lProfiler = System.currentTimeMillis();
        long syncPoint = adminp.getItemValueLong("_syncpoint");
        int totalCount = adminp.getItemValueInteger("numUpdates");
        int blockCount = 0;
        logger.info("...Job JOB_REBUILD_INDEX (" + adminp.getUniqueID() + ") - lucene.rebuild.block_size=" + this.block_size);
        logger.info("...Job JOB_REBUILD_INDEX (" + adminp.getUniqueID() + ") - lucene.rebuild.time_out=" + this.time_out);
        try {
            block9: {
                long time;
                do {
                    ArrayList<ItemCollection> resultList = new ArrayList<ItemCollection>();
                    List<Document> documents = this.findNextDocumentsBySyncPoint(syncPoint);
                    if (documents == null || documents.size() <= 0) break block9;
                    for (Document doc : documents) {
                        syncPoint = doc.getCreated().getTimeInMillis();
                        try {
                            resultList.add(new ItemCollection(doc.getData()));
                        }
                        catch (InvalidAccessException e) {
                            logger.warning("...unable to index document '" + doc.getId() + "' " + e.getMessage());
                        }
                        this.manager.detach((Object)doc);
                    }
                    this.updateService.updateIndex(resultList);
                    this.manager.flush();
                    totalCount += resultList.size();
                    if ((blockCount += resultList.size()) >= this.block_size) {
                        time = (System.currentTimeMillis() - lProfiler) / 1000L;
                        if (time == 0L) {
                            time = 1L;
                        }
                        logger.info("...Job JOB_REBUILD_INDEX (" + adminp.getUniqueID() + ") - ..." + totalCount + " documents indexed in " + time + " sec. ... ");
                        blockCount = 0;
                    }
                    if ((time = (System.currentTimeMillis() - lProfiler) / 1000L) != 0L) continue;
                    time = 1L;
                } while (time <= (long)this.time_out);
                logger.info("...Job JOB_REBUILD_INDEX (" + adminp.getUniqueID() + ") - suspended: " + totalCount + " documents indexed in " + time + " sec. ");
                adminp.replaceItemValue("_syncpoint", (Object)syncPoint);
                adminp.replaceItemValue("iscompleted", (Object)false);
                adminp.replaceItemValue("numUpdates", (Object)totalCount);
                adminp.replaceItemValue("numProcessed", (Object)totalCount);
                adminp.replaceItemValue("numLastCount", (Object)0);
                return adminp;
            }
            this.manager.flush();
        }
        catch (Exception e) {
            logger.severe("...Job JOB_REBUILD_INDEX (" + adminp.getUniqueID() + ") - failed - " + e.getMessage() + " last syncpoint  " + syncPoint + " - " + totalCount + "  documents reindexed....");
            e.printStackTrace();
            adminp.replaceItemValue("iscompleted", (Object)false);
            Date syncDate = new Date(syncPoint);
            adminp.replaceItemValue("error", (Object)e.getMessage());
            adminp.replaceItemValue(ITEM_SYNCPOINT, (Object)syncPoint);
            adminp.replaceItemValue(ITEM_SYNCDATE, (Object)syncDate);
            adminp.replaceItemValue("numUpdates", (Object)totalCount);
            adminp.replaceItemValue("numProcessed", (Object)totalCount);
            adminp.replaceItemValue("numLastCount", (Object)0);
            return adminp;
        }
        long time = (System.currentTimeMillis() - lProfiler) / 1000L;
        if (time == 0L) {
            time = 1L;
        }
        logger.info("...Job JOB_REBUILD_INDEX (" + adminp.getUniqueID() + ") - Finished: " + totalCount + " documents indexed in " + time + " sec. ");
        adminp.replaceItemValue("iscompleted", (Object)true);
        adminp.replaceItemValue("numUpdates", (Object)totalCount);
        adminp.replaceItemValue("numProcessed", (Object)totalCount);
        adminp.replaceItemValue("numLastCount", (Object)0);
        return adminp;
    }

    private List<Document> findNextDocumentsBySyncPoint(long lSyncpoint) {
        Date syncpoint = new Date(lSyncpoint);
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Object query = "SELECT document FROM Document AS document ";
        query = (String)query + " WHERE document.created > '" + isoFormat.format(syncpoint) + "'";
        query = (String)query + " AND NOT document.type LIKE 'snapshot-%' ";
        query = (String)query + " AND NOT document.type LIKE 'workitemlob%' ";
        query = (String)query + " AND document.type != 'event' ";
        query = (String)query + " ORDER BY document.created ASC";
        Query q = this.manager.createQuery((String)query);
        q.setFirstResult(0);
        q.setMaxResults(32);
        List documentList = q.getResultList();
        if (documentList != null && documentList.size() > 0) {
            Document lastDocument = null;
            Document nextToLastDocument = null;
            if (documentList.size() == 32) {
                lastDocument = (Document)documentList.get(31);
                nextToLastDocument = (Document)documentList.get(30);
                if (lastDocument != null && nextToLastDocument != null && lastDocument.getCreated().equals(nextToLastDocument.getCreated())) {
                    logger.finest("......there are more than one document with the same creation timestamp!");
                    syncpoint = new Date(lastDocument.getCreated().getTimeInMillis());
                    query = "SELECT document FROM Document AS document ";
                    query = (String)query + " WHERE document.created = '" + isoFormat.format(syncpoint) + "'";
                    query = (String)query + " AND NOT document.type LIKE 'snapshot-%' ";
                    query = (String)query + " AND NOT document.type LIKE 'workitemlob%' ";
                    query = (String)query + " AND document.type != 'event' ";
                    query = (String)query + " ORDER BY document.created ASC";
                    q = this.manager.createQuery((String)query);
                    q.setFirstResult(0);
                    q.setMaxResults(this.block_size);
                    documentList.addAll(q.getResultList());
                    return documentList;
                }
                documentList.remove(lastDocument);
                this.manager.detach((Object)lastDocument);
                return documentList;
            }
            return documentList;
        }
        return null;
    }
}

